/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardTeam;

public class PersistentScoreboard
extends PersistentBase {
    public static final String FILE_ID = "scoreboard";
    private final Scoreboard scoreboard;

    public PersistentScoreboard(Scoreboard var0) {
        this.scoreboard = var0;
    }

    public void loadFrom(a var02) {
        var02.objectives().forEach(this.scoreboard::loadObjective);
        var02.scores().forEach(this.scoreboard::loadPlayerScore);
        var02.displaySlots().forEach((var0, var1) -> {
            ScoreboardObjective var2 = this.scoreboard.getObjective((String)var1);
            this.scoreboard.setDisplayObjective((DisplaySlot)var0, var2);
        });
        var02.teams().forEach(this.scoreboard::loadPlayerTeam);
    }

    public a pack() {
        EnumMap<DisplaySlot, String> var0 = new EnumMap<DisplaySlot, String>(DisplaySlot.class);
        for (DisplaySlot var4 : DisplaySlot.values()) {
            ScoreboardObjective var5 = this.scoreboard.getDisplayObjective(var4);
            if (var5 == null) continue;
            var0.put(var4, var5.getName());
        }
        return new a(this.scoreboard.getObjectives().stream().map(ScoreboardObjective::pack).toList(), this.scoreboard.packPlayerScores(), var0, this.scoreboard.getPlayerTeams().stream().map(ScoreboardTeam::pack).toList());
    }

    public record a(List<ScoreboardObjective.a> objectives, List<Scoreboard.a> scores, Map<DisplaySlot, String> displaySlots, List<ScoreboardTeam.a> teams) {
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ScoreboardObjective.a.CODEC.listOf().optionalFieldOf("Objectives", List.of()).forGetter(a::objectives), (App)Scoreboard.a.CODEC.listOf().optionalFieldOf("PlayerScores", List.of()).forGetter(a::scores), (App)Codec.unboundedMap(DisplaySlot.CODEC, (Codec)Codec.STRING).optionalFieldOf("DisplaySlots", Map.of()).forGetter(a::displaySlots), (App)ScoreboardTeam.a.CODEC.listOf().optionalFieldOf("Teams", List.of()).forGetter(a::teams)).apply((Applicative)var0, a::new));
    }
}

