/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.CriterionTriggerAbstract;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.level.storage.loot.LootTableInfo;

public class CriterionTriggerBredAnimals
extends CriterionTriggerAbstract<a> {
    @Override
    public Codec<a> codec() {
        return a.CODEC;
    }

    public void trigger(EntityPlayer var0, EntityAnimal var1, EntityAnimal var2, @Nullable EntityAgeable var32) {
        LootTableInfo var4 = CriterionConditionEntity.createContext(var0, var1);
        LootTableInfo var5 = CriterionConditionEntity.createContext(var0, var2);
        LootTableInfo var6 = var32 != null ? CriterionConditionEntity.createContext(var0, var32) : null;
        this.trigger(var0, var3 -> var3.matches(var4, var5, var6));
    }

    public record a(Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> parent, Optional<ContextAwarePredicate> partner, Optional<ContextAwarePredicate> child) implements CriterionTriggerAbstract.a
    {
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)CriterionConditionEntity.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(a::player), (App)CriterionConditionEntity.ADVANCEMENT_CODEC.optionalFieldOf("parent").forGetter(a::parent), (App)CriterionConditionEntity.ADVANCEMENT_CODEC.optionalFieldOf("partner").forGetter(a::partner), (App)CriterionConditionEntity.ADVANCEMENT_CODEC.optionalFieldOf("child").forGetter(a::child)).apply((Applicative)var0, a::new));

        public static Criterion<a> bredAnimals() {
            return CriterionTriggers.BRED_ANIMALS.createCriterion(new a(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
        }

        public static Criterion<a> bredAnimals(CriterionConditionEntity.a var0) {
            return CriterionTriggers.BRED_ANIMALS.createCriterion(new a(Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(CriterionConditionEntity.wrap(var0))));
        }

        public static Criterion<a> bredAnimals(Optional<CriterionConditionEntity> var0, Optional<CriterionConditionEntity> var1, Optional<CriterionConditionEntity> var2) {
            return CriterionTriggers.BRED_ANIMALS.createCriterion(new a(Optional.empty(), CriterionConditionEntity.wrap(var0), CriterionConditionEntity.wrap(var1), CriterionConditionEntity.wrap(var2)));
        }

        public boolean matches(LootTableInfo var0, LootTableInfo var1, @Nullable LootTableInfo var2) {
            if (this.child.isPresent() && (var2 == null || !this.child.get().matches(var2))) {
                return false;
            }
            return a.matches(this.parent, var0) && a.matches(this.partner, var1) || a.matches(this.parent, var1) && a.matches(this.partner, var0);
        }

        private static boolean matches(Optional<ContextAwarePredicate> var0, LootTableInfo var1) {
            return var0.isEmpty() || var0.get().matches(var1);
        }

        @Override
        public void validate(CriterionValidator var0) {
            CriterionTriggerAbstract.a.super.validate(var0);
            var0.validateEntity(this.parent, "parent");
            var0.validateEntity(this.partner, "partner");
            var0.validateEntity(this.child, "child");
        }
    }
}

