/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import org.apache.commons.io.FilenameUtils;

public class ResourceSelectorArgument<T>
implements ArgumentType<Collection<Holder.c<T>>> {
    private static final Collection<String> EXAMPLES = List.of("minecraft:*", "*:asset", "*");
    public static final Dynamic2CommandExceptionType ERROR_NO_MATCHES = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.translatableEscape("argument.resource_selector.not_found", var0, var1));
    final ResourceKey<? extends IRegistry<T>> registryKey;
    private final HolderLookup<T> registryLookup;

    ResourceSelectorArgument(CommandBuildContext var0, ResourceKey<? extends IRegistry<T>> var1) {
        this.registryKey = var1;
        this.registryLookup = var0.lookupOrThrow(var1);
    }

    public Collection<Holder.c<T>> parse(StringReader var0) throws CommandSyntaxException {
        String var12 = ResourceSelectorArgument.ensureNamespaced(ResourceSelectorArgument.readPattern(var0));
        List<Holder.c<T>> var2 = this.registryLookup.listElements().filter(var1 -> ResourceSelectorArgument.matches(var12, var1.key().location())).toList();
        if (var2.isEmpty()) {
            throw ERROR_NO_MATCHES.createWithContext((ImmutableStringReader)var0, (Object)var12, (Object)this.registryKey.location());
        }
        return var2;
    }

    public static <T> Collection<Holder.c<T>> parse(StringReader var0, HolderLookup<T> var12) {
        String var2 = ResourceSelectorArgument.ensureNamespaced(ResourceSelectorArgument.readPattern(var0));
        return var12.listElements().filter(var1 -> ResourceSelectorArgument.matches(var2, var1.key().location())).toList();
    }

    private static String readPattern(StringReader var0) {
        int var1 = var0.getCursor();
        while (var0.canRead() && ResourceSelectorArgument.isAllowedPatternCharacter(var0.peek())) {
            var0.skip();
        }
        return var0.getString().substring(var1, var0.getCursor());
    }

    private static boolean isAllowedPatternCharacter(char var0) {
        return MinecraftKey.isAllowedInResourceLocation(var0) || var0 == '*' || var0 == '?';
    }

    private static String ensureNamespaced(String var0) {
        if (!var0.contains(":")) {
            return "minecraft:" + var0;
        }
        return var0;
    }

    private static boolean matches(String var0, MinecraftKey var1) {
        return FilenameUtils.wildcardMatch((String)var1.toString(), (String)var0);
    }

    public static <T> ResourceSelectorArgument<T> resourceSelector(CommandBuildContext var0, ResourceKey<? extends IRegistry<T>> var1) {
        return new ResourceSelectorArgument<T>(var0, var1);
    }

    public static <T> Collection<Holder.c<T>> getSelectedResources(CommandContext<CommandListenerWrapper> var0, String var1) {
        return (Collection)var0.getArgument(var1, Collection.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        return ICompletionProvider.listSuggestions(var0, var1, this.registryKey, ICompletionProvider.a.ELEMENTS);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static class net.minecraft.commands.arguments.ResourceSelectorArgument$a<T>
    implements ArgumentTypeInfo<ResourceSelectorArgument<T>, a> {
        @Override
        public void serializeToNetwork(a var0, PacketDataSerializer var1) {
            var1.writeResourceKey(var0.registryKey);
        }

        @Override
        public a deserializeFromNetwork(PacketDataSerializer var0) {
            return new a(var0.readRegistryKey());
        }

        @Override
        public void serializeToJson(a var0, JsonObject var1) {
            var1.addProperty("registry", var0.registryKey.location().toString());
        }

        @Override
        public a unpack(ResourceSelectorArgument<T> var0) {
            return new a(var0.registryKey);
        }

        @Override
        public /* synthetic */ ArgumentTypeInfo.a deserializeFromNetwork(PacketDataSerializer packetDataSerializer) {
            return this.deserializeFromNetwork(packetDataSerializer);
        }

        public final class a
        implements ArgumentTypeInfo.a<ResourceSelectorArgument<T>> {
            final ResourceKey<? extends IRegistry<T>> registryKey;

            a(ResourceKey var1) {
                this.registryKey = var1;
            }

            @Override
            public ResourceSelectorArgument<T> instantiate(CommandBuildContext var0) {
                return new ResourceSelectorArgument(var0, this.registryKey);
            }

            @Override
            public ArgumentTypeInfo<ResourceSelectorArgument<T>, ?> type() {
                return a.this;
            }

            @Override
            public /* synthetic */ ArgumentType instantiate(CommandBuildContext commandBuildContext) {
                return this.instantiate(commandBuildContext);
            }
        }
    }
}

