/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.blocks;

import com.google.common.collect.Maps;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;

public class ArgumentBlock {
    public static final SimpleCommandExceptionType ERROR_NO_TAGS_ALLOWED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("argument.block.tag.disallowed"));
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_BLOCK = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("argument.block.id.invalid", var0));
    public static final Dynamic2CommandExceptionType ERROR_UNKNOWN_PROPERTY = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.translatableEscape("argument.block.property.unknown", var0, var1));
    public static final Dynamic2CommandExceptionType ERROR_DUPLICATE_PROPERTY = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.translatableEscape("argument.block.property.duplicate", var1, var0));
    public static final Dynamic3CommandExceptionType ERROR_INVALID_VALUE = new Dynamic3CommandExceptionType((var0, var1, var2) -> IChatBaseComponent.translatableEscape("argument.block.property.invalid", var0, var2, var1));
    public static final Dynamic2CommandExceptionType ERROR_EXPECTED_VALUE = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.translatableEscape("argument.block.property.novalue", var0, var1));
    public static final SimpleCommandExceptionType ERROR_EXPECTED_END_OF_PROPERTIES = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("argument.block.property.unclosed"));
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_TAG = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("arguments.block.tag.unknown", var0));
    private static final char SYNTAX_START_PROPERTIES = '[';
    private static final char SYNTAX_START_NBT = '{';
    private static final char SYNTAX_END_PROPERTIES = ']';
    private static final char SYNTAX_EQUALS = '=';
    private static final char SYNTAX_PROPERTY_SEPARATOR = ',';
    private static final char SYNTAX_TAG = '#';
    private static final Function<SuggestionsBuilder, CompletableFuture<Suggestions>> SUGGEST_NOTHING = SuggestionsBuilder::buildFuture;
    private final HolderLookup<Block> blocks;
    private final StringReader reader;
    private final boolean forTesting;
    private final boolean allowNbt;
    private final Map<IBlockState<?>, Comparable<?>> properties = Maps.newHashMap();
    private final Map<String, String> vagueProperties = Maps.newHashMap();
    private MinecraftKey id = MinecraftKey.withDefaultNamespace("");
    @Nullable
    private BlockStateList<Block, IBlockData> definition;
    @Nullable
    private IBlockData state;
    @Nullable
    private NBTTagCompound nbt;
    @Nullable
    private HolderSet<Block> tag;
    private Function<SuggestionsBuilder, CompletableFuture<Suggestions>> suggestions = SUGGEST_NOTHING;

    private ArgumentBlock(HolderLookup<Block> var0, StringReader var1, boolean var2, boolean var3) {
        this.blocks = var0;
        this.reader = var1;
        this.forTesting = var2;
        this.allowNbt = var3;
    }

    public static a parseForBlock(HolderLookup<Block> var0, String var1, boolean var2) throws CommandSyntaxException {
        return ArgumentBlock.parseForBlock(var0, new StringReader(var1), var2);
    }

    public static a parseForBlock(HolderLookup<Block> var0, StringReader var1, boolean var2) throws CommandSyntaxException {
        int var3 = var1.getCursor();
        try {
            ArgumentBlock var4 = new ArgumentBlock(var0, var1, false, var2);
            var4.parse();
            return new a(var4.state, var4.properties, var4.nbt);
        }
        catch (CommandSyntaxException var4) {
            var1.setCursor(var3);
            throw var4;
        }
    }

    public static Either<a, b> parseForTesting(HolderLookup<Block> var0, String var1, boolean var2) throws CommandSyntaxException {
        return ArgumentBlock.parseForTesting(var0, new StringReader(var1), var2);
    }

    public static Either<a, b> parseForTesting(HolderLookup<Block> var0, StringReader var1, boolean var2) throws CommandSyntaxException {
        int var3 = var1.getCursor();
        try {
            ArgumentBlock var4 = new ArgumentBlock(var0, var1, true, var2);
            var4.parse();
            if (var4.tag != null) {
                return Either.right((Object)new b(var4.tag, var4.vagueProperties, var4.nbt));
            }
            return Either.left((Object)new a(var4.state, var4.properties, var4.nbt));
        }
        catch (CommandSyntaxException var4) {
            var1.setCursor(var3);
            throw var4;
        }
    }

    public static CompletableFuture<Suggestions> fillSuggestions(HolderLookup<Block> var0, SuggestionsBuilder var1, boolean var2, boolean var3) {
        StringReader var4 = new StringReader(var1.getInput());
        var4.setCursor(var1.getStart());
        ArgumentBlock var5 = new ArgumentBlock(var0, var4, var2, var3);
        try {
            var5.parse();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return var5.suggestions.apply(var1.createOffset(var4.getCursor()));
    }

    private void parse() throws CommandSyntaxException {
        this.suggestions = this.forTesting ? this::suggestBlockIdOrTag : this::suggestItem;
        if (this.reader.canRead() && this.reader.peek() == '#') {
            this.readTag();
            this.suggestions = this::suggestOpenVaguePropertiesOrNbt;
            if (this.reader.canRead() && this.reader.peek() == '[') {
                this.readVagueProperties();
                this.suggestions = this::suggestOpenNbt;
            }
        } else {
            this.readBlock();
            this.suggestions = this::suggestOpenPropertiesOrNbt;
            if (this.reader.canRead() && this.reader.peek() == '[') {
                this.readProperties();
                this.suggestions = this::suggestOpenNbt;
            }
        }
        if (this.allowNbt && this.reader.canRead() && this.reader.peek() == '{') {
            this.suggestions = SUGGEST_NOTHING;
            this.readNbt();
        }
    }

    private CompletableFuture<Suggestions> suggestPropertyNameOrEnd(SuggestionsBuilder var0) {
        if (var0.getRemaining().isEmpty()) {
            var0.suggest(String.valueOf(']'));
        }
        return this.suggestPropertyName(var0);
    }

    private CompletableFuture<Suggestions> suggestVaguePropertyNameOrEnd(SuggestionsBuilder var0) {
        if (var0.getRemaining().isEmpty()) {
            var0.suggest(String.valueOf(']'));
        }
        return this.suggestVaguePropertyName(var0);
    }

    private CompletableFuture<Suggestions> suggestPropertyName(SuggestionsBuilder var0) {
        String var1 = var0.getRemaining().toLowerCase(Locale.ROOT);
        for (IBlockState<?> var3 : this.state.getProperties()) {
            if (this.properties.containsKey(var3) || !var3.getName().startsWith(var1)) continue;
            var0.suggest(var3.getName() + "=");
        }
        return var0.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestVaguePropertyName(SuggestionsBuilder var0) {
        String var1 = var0.getRemaining().toLowerCase(Locale.ROOT);
        if (this.tag != null) {
            for (Holder holder : this.tag) {
                for (IBlockState<?> var5 : ((Block)holder.value()).getStateDefinition().getProperties()) {
                    if (this.vagueProperties.containsKey(var5.getName()) || !var5.getName().startsWith(var1)) continue;
                    var0.suggest(var5.getName() + "=");
                }
            }
        }
        return var0.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestOpenNbt(SuggestionsBuilder var0) {
        if (var0.getRemaining().isEmpty() && this.hasBlockEntity()) {
            var0.suggest(String.valueOf('{'));
        }
        return var0.buildFuture();
    }

    private boolean hasBlockEntity() {
        if (this.state != null) {
            return this.state.hasBlockEntity();
        }
        if (this.tag != null) {
            for (Holder holder : this.tag) {
                if (!((Block)holder.value()).defaultBlockState().hasBlockEntity()) continue;
                return true;
            }
        }
        return false;
    }

    private CompletableFuture<Suggestions> suggestEquals(SuggestionsBuilder var0) {
        if (var0.getRemaining().isEmpty()) {
            var0.suggest(String.valueOf('='));
        }
        return var0.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestNextPropertyOrEnd(SuggestionsBuilder var0) {
        if (var0.getRemaining().isEmpty()) {
            var0.suggest(String.valueOf(']'));
        }
        if (var0.getRemaining().isEmpty() && this.properties.size() < this.state.getProperties().size()) {
            var0.suggest(String.valueOf(','));
        }
        return var0.buildFuture();
    }

    private static <T extends Comparable<T>> SuggestionsBuilder addSuggestions(SuggestionsBuilder var0, IBlockState<T> var1) {
        for (Comparable var3 : var1.getPossibleValues()) {
            if (var3 instanceof Integer) {
                Integer var4 = (Integer)var3;
                var0.suggest(var4.intValue());
                continue;
            }
            var0.suggest(var1.getName(var3));
        }
        return var0;
    }

    private CompletableFuture<Suggestions> suggestVaguePropertyValue(SuggestionsBuilder var0, String var1) {
        boolean var2 = false;
        if (this.tag != null) {
            block0: for (Holder holder : this.tag) {
                Block var5 = (Block)holder.value();
                IBlockState<?> var6 = var5.getStateDefinition().getProperty(var1);
                if (var6 != null) {
                    ArgumentBlock.addSuggestions(var0, var6);
                }
                if (var2) continue;
                for (IBlockState<?> var8 : var5.getStateDefinition().getProperties()) {
                    if (this.vagueProperties.containsKey(var8.getName())) continue;
                    var2 = true;
                    continue block0;
                }
            }
        }
        if (var2) {
            var0.suggest(String.valueOf(','));
        }
        var0.suggest(String.valueOf(']'));
        return var0.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestOpenVaguePropertiesOrNbt(SuggestionsBuilder var0) {
        if (var0.getRemaining().isEmpty() && this.tag != null) {
            Holder var4;
            Block var5;
            boolean var1 = false;
            boolean var2 = false;
            Iterator iterator = this.tag.iterator();
            while (!(!iterator.hasNext() || (var1 |= !(var5 = (Block)(var4 = (Holder)iterator.next()).value()).getStateDefinition().getProperties().isEmpty()) && (var2 |= var5.defaultBlockState().hasBlockEntity()))) {
            }
            if (var1) {
                var0.suggest(String.valueOf('['));
            }
            if (var2) {
                var0.suggest(String.valueOf('{'));
            }
        }
        return var0.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestOpenPropertiesOrNbt(SuggestionsBuilder var0) {
        if (var0.getRemaining().isEmpty()) {
            if (!this.definition.getProperties().isEmpty()) {
                var0.suggest(String.valueOf('['));
            }
            if (this.state.hasBlockEntity()) {
                var0.suggest(String.valueOf('{'));
            }
        }
        return var0.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestTag(SuggestionsBuilder var0) {
        return ICompletionProvider.suggestResource(this.blocks.listTagIds().map(TagKey::location), var0, String.valueOf('#'));
    }

    private CompletableFuture<Suggestions> suggestItem(SuggestionsBuilder var0) {
        return ICompletionProvider.suggestResource(this.blocks.listElementIds().map(ResourceKey::location), var0);
    }

    private CompletableFuture<Suggestions> suggestBlockIdOrTag(SuggestionsBuilder var0) {
        this.suggestTag(var0);
        this.suggestItem(var0);
        return var0.buildFuture();
    }

    private void readBlock() throws CommandSyntaxException {
        int var0 = this.reader.getCursor();
        this.id = MinecraftKey.read(this.reader);
        Block var1 = this.blocks.get(ResourceKey.create(Registries.BLOCK, this.id)).orElseThrow(() -> {
            this.reader.setCursor(var0);
            return ERROR_UNKNOWN_BLOCK.createWithContext((ImmutableStringReader)this.reader, (Object)this.id.toString());
        }).value();
        this.definition = var1.getStateDefinition();
        this.state = var1.defaultBlockState();
    }

    private void readTag() throws CommandSyntaxException {
        if (!this.forTesting) {
            throw ERROR_NO_TAGS_ALLOWED.createWithContext((ImmutableStringReader)this.reader);
        }
        int var0 = this.reader.getCursor();
        this.reader.expect('#');
        this.suggestions = this::suggestTag;
        MinecraftKey var1 = MinecraftKey.read(this.reader);
        this.tag = this.blocks.get(TagKey.create(Registries.BLOCK, var1)).orElseThrow(() -> {
            this.reader.setCursor(var0);
            return ERROR_UNKNOWN_TAG.createWithContext((ImmutableStringReader)this.reader, (Object)var1.toString());
        });
    }

    private void readProperties() throws CommandSyntaxException {
        this.reader.skip();
        this.suggestions = this::suggestPropertyNameOrEnd;
        this.reader.skipWhitespace();
        while (this.reader.canRead() && this.reader.peek() != ']') {
            this.reader.skipWhitespace();
            int var0 = this.reader.getCursor();
            String var12 = this.reader.readString();
            IBlockState<?> var2 = this.definition.getProperty(var12);
            if (var2 == null) {
                this.reader.setCursor(var0);
                throw ERROR_UNKNOWN_PROPERTY.createWithContext((ImmutableStringReader)this.reader, (Object)this.id.toString(), (Object)var12);
            }
            if (this.properties.containsKey(var2)) {
                this.reader.setCursor(var0);
                throw ERROR_DUPLICATE_PROPERTY.createWithContext((ImmutableStringReader)this.reader, (Object)this.id.toString(), (Object)var12);
            }
            this.reader.skipWhitespace();
            this.suggestions = this::suggestEquals;
            if (!this.reader.canRead() || this.reader.peek() != '=') {
                throw ERROR_EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader, (Object)this.id.toString(), (Object)var12);
            }
            this.reader.skip();
            this.reader.skipWhitespace();
            this.suggestions = var1 -> ArgumentBlock.addSuggestions(var1, var2).buildFuture();
            int var3 = this.reader.getCursor();
            this.setValue(var2, this.reader.readString(), var3);
            this.suggestions = this::suggestNextPropertyOrEnd;
            this.reader.skipWhitespace();
            if (!this.reader.canRead()) continue;
            if (this.reader.peek() == ',') {
                this.reader.skip();
                this.suggestions = this::suggestPropertyName;
                continue;
            }
            if (this.reader.peek() == ']') break;
            throw ERROR_EXPECTED_END_OF_PROPERTIES.createWithContext((ImmutableStringReader)this.reader);
        }
        if (!this.reader.canRead()) {
            throw ERROR_EXPECTED_END_OF_PROPERTIES.createWithContext((ImmutableStringReader)this.reader);
        }
        this.reader.skip();
    }

    private void readVagueProperties() throws CommandSyntaxException {
        this.reader.skip();
        this.suggestions = this::suggestVaguePropertyNameOrEnd;
        int var0 = -1;
        this.reader.skipWhitespace();
        while (this.reader.canRead() && this.reader.peek() != ']') {
            this.reader.skipWhitespace();
            int var12 = this.reader.getCursor();
            String var2 = this.reader.readString();
            if (this.vagueProperties.containsKey(var2)) {
                this.reader.setCursor(var12);
                throw ERROR_DUPLICATE_PROPERTY.createWithContext((ImmutableStringReader)this.reader, (Object)this.id.toString(), (Object)var2);
            }
            this.reader.skipWhitespace();
            if (!this.reader.canRead() || this.reader.peek() != '=') {
                this.reader.setCursor(var12);
                throw ERROR_EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader, (Object)this.id.toString(), (Object)var2);
            }
            this.reader.skip();
            this.reader.skipWhitespace();
            this.suggestions = var1 -> this.suggestVaguePropertyValue((SuggestionsBuilder)var1, var2);
            var0 = this.reader.getCursor();
            String var3 = this.reader.readString();
            this.vagueProperties.put(var2, var3);
            this.reader.skipWhitespace();
            if (!this.reader.canRead()) continue;
            var0 = -1;
            if (this.reader.peek() == ',') {
                this.reader.skip();
                this.suggestions = this::suggestVaguePropertyName;
                continue;
            }
            if (this.reader.peek() == ']') break;
            throw ERROR_EXPECTED_END_OF_PROPERTIES.createWithContext((ImmutableStringReader)this.reader);
        }
        if (!this.reader.canRead()) {
            if (var0 >= 0) {
                this.reader.setCursor(var0);
            }
            throw ERROR_EXPECTED_END_OF_PROPERTIES.createWithContext((ImmutableStringReader)this.reader);
        }
        this.reader.skip();
    }

    private void readNbt() throws CommandSyntaxException {
        this.nbt = MojangsonParser.parseCompoundAsArgument(this.reader);
    }

    private <T extends Comparable<T>> void setValue(IBlockState<T> var0, String var1, int var2) throws CommandSyntaxException {
        Optional<T> var3 = var0.getValue(var1);
        if (!var3.isPresent()) {
            this.reader.setCursor(var2);
            throw ERROR_INVALID_VALUE.createWithContext((ImmutableStringReader)this.reader, (Object)this.id.toString(), (Object)var0.getName(), (Object)var1);
        }
        this.state = (IBlockData)this.state.setValue(var0, (Comparable)var3.get());
        this.properties.put(var0, (Comparable)var3.get());
    }

    public static String serialize(IBlockData var02) {
        StringBuilder var1 = new StringBuilder(var02.getBlockHolder().unwrapKey().map(var0 -> var0.location().toString()).orElse("air"));
        if (!var02.getProperties().isEmpty()) {
            var1.append('[');
            boolean var2 = false;
            for (Map.Entry<IBlockState<?>, Comparable<?>> var4 : var02.getValues().entrySet()) {
                if (var2) {
                    var1.append(',');
                }
                ArgumentBlock.appendProperty(var1, var4.getKey(), var4.getValue());
                var2 = true;
            }
            var1.append(']');
        }
        return var1.toString();
    }

    private static <T extends Comparable<T>> void appendProperty(StringBuilder var0, IBlockState<T> var1, Comparable<?> var2) {
        var0.append(var1.getName());
        var0.append('=');
        var0.append(var1.getName(var2));
    }

    public record a(IBlockData blockState, Map<IBlockState<?>, Comparable<?>> properties, @Nullable NBTTagCompound nbt) {
    }

    public record b(HolderSet<Block> tag, Map<String, String> vagueProperties, @Nullable NBTTagCompound nbt) {
    }
}

