/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.common.custom;

import java.util.UUID;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.DebugEntityNameGenerator;

public record BreezeDebugPayload(a breezeInfo) implements CustomPacketPayload
{
    public static final StreamCodec<PacketDataSerializer, BreezeDebugPayload> STREAM_CODEC = CustomPacketPayload.codec(BreezeDebugPayload::write, BreezeDebugPayload::new);
    public static final CustomPacketPayload.b<BreezeDebugPayload> TYPE = CustomPacketPayload.createType("debug/breeze");

    private BreezeDebugPayload(PacketDataSerializer var0) {
        this(new a(var0));
    }

    private void write(PacketDataSerializer var0) {
        this.breezeInfo.write(var0);
    }

    public CustomPacketPayload.b<BreezeDebugPayload> type() {
        return TYPE;
    }

    public record a(UUID uuid, int id, Integer attackTarget, BlockPosition jumpTarget) {
        public a(PacketDataSerializer var0) {
            this(var0.readUUID(), var0.readInt(), var0.readNullable(PacketDataSerializer::readInt), var0.readNullable(BlockPosition.STREAM_CODEC));
        }

        public void write(PacketDataSerializer var0) {
            var0.writeUUID(this.uuid);
            var0.writeInt(this.id);
            var0.writeNullable(this.attackTarget, PacketDataSerializer::writeInt);
            var0.writeNullable(this.jumpTarget, BlockPosition.STREAM_CODEC);
        }

        public String generateName() {
            return DebugEntityNameGenerator.getEntityName(this.uuid);
        }

        @Override
        public String toString() {
            return this.generateName();
        }
    }
}

