/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.common.custom;

import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.World;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;

public record StructuresDebugPayload(ResourceKey<World> dimension, StructureBoundingBox mainBB, List<a> pieces) implements CustomPacketPayload
{
    public static final StreamCodec<PacketDataSerializer, StructuresDebugPayload> STREAM_CODEC = CustomPacketPayload.codec(StructuresDebugPayload::write, StructuresDebugPayload::new);
    public static final CustomPacketPayload.b<StructuresDebugPayload> TYPE = CustomPacketPayload.createType("debug/structures");

    private StructuresDebugPayload(PacketDataSerializer var0) {
        this(var0.readResourceKey(Registries.DIMENSION), StructuresDebugPayload.readBoundingBox(var0), var0.readList(a::new));
    }

    private void write(PacketDataSerializer var0) {
        var0.writeResourceKey(this.dimension);
        StructuresDebugPayload.writeBoundingBox(var0, this.mainBB);
        var0.writeCollection(this.pieces, (var1, var2) -> var2.write(var0));
    }

    public CustomPacketPayload.b<StructuresDebugPayload> type() {
        return TYPE;
    }

    static StructureBoundingBox readBoundingBox(PacketDataSerializer var0) {
        return new StructureBoundingBox(var0.readInt(), var0.readInt(), var0.readInt(), var0.readInt(), var0.readInt(), var0.readInt());
    }

    static void writeBoundingBox(PacketDataSerializer var0, StructureBoundingBox var1) {
        var0.writeInt(var1.minX());
        var0.writeInt(var1.minY());
        var0.writeInt(var1.minZ());
        var0.writeInt(var1.maxX());
        var0.writeInt(var1.maxY());
        var0.writeInt(var1.maxZ());
    }

    public record a(StructureBoundingBox boundingBox, boolean isStart) {
        public a(PacketDataSerializer var0) {
            this(StructuresDebugPayload.readBoundingBox(var0), var0.readBoolean());
        }

        public void write(PacketDataSerializer var0) {
            StructuresDebugPayload.writeBoundingBox(var0, this.boundingBox);
            var0.writeBoolean(this.isStart);
        }
    }
}

