/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkSection;

public class PacketPlayOutMultiBlockChange
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<PacketDataSerializer, PacketPlayOutMultiBlockChange> STREAM_CODEC = Packet.codec(PacketPlayOutMultiBlockChange::write, PacketPlayOutMultiBlockChange::new);
    private static final int POS_IN_SECTION_BITS = 12;
    private final SectionPosition sectionPos;
    private final short[] positions;
    private final IBlockData[] states;

    public PacketPlayOutMultiBlockChange(SectionPosition var0, ShortSet var1, ChunkSection var2) {
        this.sectionPos = var0;
        int var3 = var1.size();
        this.positions = new short[var3];
        this.states = new IBlockData[var3];
        int var4 = 0;
        ShortIterator shortIterator = var1.iterator();
        while (shortIterator.hasNext()) {
            short var6;
            this.positions[var4] = var6 = ((Short)shortIterator.next()).shortValue();
            this.states[var4] = var2.getBlockState(SectionPosition.sectionRelativeX(var6), SectionPosition.sectionRelativeY(var6), SectionPosition.sectionRelativeZ(var6));
            ++var4;
        }
    }

    private PacketPlayOutMultiBlockChange(PacketDataSerializer var0) {
        this.sectionPos = SectionPosition.of(var0.readLong());
        int var1 = var0.readVarInt();
        this.positions = new short[var1];
        this.states = new IBlockData[var1];
        for (int var2 = 0; var2 < var1; ++var2) {
            long var3 = var0.readVarLong();
            this.positions[var2] = (short)(var3 & 0xFFFL);
            this.states[var2] = Block.BLOCK_STATE_REGISTRY.byId((int)(var3 >>> 12));
        }
    }

    private void write(PacketDataSerializer var0) {
        var0.writeLong(this.sectionPos.asLong());
        var0.writeVarInt(this.positions.length);
        for (int var1 = 0; var1 < this.positions.length; ++var1) {
            var0.writeVarLong((long)Block.getId(this.states[var1]) << 12 | (long)this.positions[var1]);
        }
    }

    @Override
    public PacketType<PacketPlayOutMultiBlockChange> type() {
        return GamePacketTypes.CLIENTBOUND_SECTION_BLOCKS_UPDATE;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleChunkBlocksUpdate(this);
    }

    public void runUpdates(BiConsumer<BlockPosition, IBlockData> var0) {
        BlockPosition.MutableBlockPosition var1 = new BlockPosition.MutableBlockPosition();
        for (int var2 = 0; var2 < this.positions.length; ++var2) {
            short var3 = this.positions[var2];
            var1.set(this.sectionPos.relativeToBlockX(var3), this.sectionPos.relativeToBlockY(var3), this.sectionPos.relativeToBlockZ(var3));
            var0.accept(var1, this.states[var2]);
        }
    }
}

