/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.core.BlockPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;

public class PacketPlayOutWorldEvent
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<PacketDataSerializer, PacketPlayOutWorldEvent> STREAM_CODEC = Packet.codec(PacketPlayOutWorldEvent::write, PacketPlayOutWorldEvent::new);
    private final int type;
    private final BlockPosition pos;
    private final int data;
    private final boolean globalEvent;

    public PacketPlayOutWorldEvent(int var0, BlockPosition var1, int var2, boolean var3) {
        this.type = var0;
        this.pos = var1.immutable();
        this.data = var2;
        this.globalEvent = var3;
    }

    private PacketPlayOutWorldEvent(PacketDataSerializer var0) {
        this.type = var0.readInt();
        this.pos = var0.readBlockPos();
        this.data = var0.readInt();
        this.globalEvent = var0.readBoolean();
    }

    private void write(PacketDataSerializer var0) {
        var0.writeInt(this.type);
        var0.writeBlockPos(this.pos);
        var0.writeInt(this.data);
        var0.writeBoolean(this.globalEvent);
    }

    @Override
    public PacketType<PacketPlayOutWorldEvent> type() {
        return GamePacketTypes.CLIENTBOUND_LEVEL_EVENT;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleLevelEvent(this);
    }

    public boolean isGlobalEvent() {
        return this.globalEvent;
    }

    public int getType() {
        return this.type;
    }

    public int getData() {
        return this.data;
    }

    public BlockPosition getPos() {
        return this.pos;
    }
}

