/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.world.level.storage.SaveData;
import org.slf4j.Logger;

public class CommandReload {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void reloadPacks(Collection<String> var0, CommandListenerWrapper var12) {
        var12.getServer().reloadResources(var0).exceptionally(var1 -> {
            LOGGER.warn("Failed to execute reload", var1);
            var12.sendFailure(IChatBaseComponent.translatable("commands.reload.failure"));
            return null;
        });
    }

    private static Collection<String> discoverNewPacks(ResourcePackRepository var0, SaveData var1, Collection<String> var2) {
        var0.reload();
        ArrayList var3 = Lists.newArrayList(var2);
        List<String> var4 = var1.getDataConfiguration().dataPacks().getDisabled();
        for (String var6 : var0.getAvailableIds()) {
            if (var4.contains(var6) || var3.contains(var6)) continue;
            var3.add(var6);
        }
        return var3;
    }

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("reload").requires(net.minecraft.commands.CommandDispatcher.hasPermission(2))).executes(var0 -> {
            CommandListenerWrapper var1 = (CommandListenerWrapper)var0.getSource();
            MinecraftServer var2 = var1.getServer();
            ResourcePackRepository var3 = var2.getPackRepository();
            SaveData var4 = var2.getWorldData();
            Collection<String> var5 = var3.getSelectedIds();
            Collection<String> var6 = CommandReload.discoverNewPacks(var3, var4, var5);
            var1.sendSuccess(() -> IChatBaseComponent.translatable("commands.reload.success"), true);
            CommandReload.reloadPacks(var6, var1);
            return 0;
        }));
    }
}

