/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level.progress;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.slf4j.Logger;

public class WorldLoadListenerLogger
implements WorldLoadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final int maxCount;
    private int count;
    private long startTime;
    private long nextTickTime = Long.MAX_VALUE;

    private WorldLoadListenerLogger(int var0) {
        this.maxCount = var0;
    }

    public static WorldLoadListenerLogger createFromGameruleRadius(int var0) {
        return var0 > 0 ? WorldLoadListenerLogger.create(var0 + 1) : WorldLoadListenerLogger.createCompleted();
    }

    public static WorldLoadListenerLogger create(int var0) {
        int var1 = WorldLoadListener.calculateDiameter(var0);
        return new WorldLoadListenerLogger(var1 * var1);
    }

    public static WorldLoadListenerLogger createCompleted() {
        return new WorldLoadListenerLogger(0);
    }

    @Override
    public void updateSpawnPos(ChunkCoordIntPair var0) {
        this.startTime = this.nextTickTime = SystemUtils.getMillis();
    }

    @Override
    public void onStatusChange(ChunkCoordIntPair var0, @Nullable ChunkStatus var1) {
        if (var1 == ChunkStatus.FULL) {
            ++this.count;
        }
        int var2 = this.getProgress();
        if (SystemUtils.getMillis() > this.nextTickTime) {
            this.nextTickTime += 500L;
            LOGGER.info(IChatBaseComponent.translatable("menu.preparingSpawn", MathHelper.clamp(var2, 0, 100)).getString());
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        LOGGER.info("Time elapsed: {} ms", (Object)(SystemUtils.getMillis() - this.startTime));
        this.nextTickTime = Long.MAX_VALUE;
    }

    public int getProgress() {
        if (this.maxCount == 0) {
            return 100;
        }
        return MathHelper.floor((float)this.count * 100.0f / (float)this.maxCount);
    }
}

