/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.server.players.JsonListEntry;
import net.minecraft.util.ChatDeserializer;
import org.slf4j.Logger;

public abstract class JsonList<K, V extends JsonListEntry<K>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final File file;
    private final Map<String, V> map = Maps.newHashMap();

    public JsonList(File var0) {
        this.file = var0;
    }

    public File getFile() {
        return this.file;
    }

    public void add(V var0) {
        this.map.put(this.getKeyForUser(((JsonListEntry)var0).getUser()), var0);
        try {
            this.save();
        }
        catch (IOException var1) {
            LOGGER.warn("Could not save the list after adding a user.", (Throwable)var1);
        }
    }

    @Nullable
    public V get(K var0) {
        this.removeExpired();
        return (V)((JsonListEntry)this.map.get(this.getKeyForUser(var0)));
    }

    public void remove(K var0) {
        this.map.remove(this.getKeyForUser(var0));
        try {
            this.save();
        }
        catch (IOException var1) {
            LOGGER.warn("Could not save the list after removing a user.", (Throwable)var1);
        }
    }

    public void remove(JsonListEntry<K> var0) {
        this.remove(var0.getUser());
    }

    public String[] getUserList() {
        return this.map.keySet().toArray(new String[0]);
    }

    public boolean isEmpty() {
        return this.map.size() < 1;
    }

    protected String getKeyForUser(K var0) {
        return var0.toString();
    }

    protected boolean contains(K var0) {
        return this.map.containsKey(this.getKeyForUser(var0));
    }

    private void removeExpired() {
        ArrayList var0 = Lists.newArrayList();
        for (Object var2 : this.map.values()) {
            if (!((JsonListEntry)var2).hasExpired()) continue;
            var0.add(((JsonListEntry)var2).getUser());
        }
        for (Object var2 : var0) {
            this.map.remove(this.getKeyForUser(var2));
        }
    }

    protected abstract JsonListEntry<K> createEntry(JsonObject var1);

    public Collection<V> getEntries() {
        return this.map.values();
    }

    public void save() throws IOException {
        JsonArray var02 = new JsonArray();
        this.map.values().stream().map(var0 -> SystemUtils.make(new JsonObject(), var0::serialize)).forEach(arg_0 -> ((JsonArray)var02).add(arg_0));
        try (BufferedWriter var1 = Files.newWriter((File)this.file, (Charset)StandardCharsets.UTF_8);){
            GSON.toJson((JsonElement)var02, GSON.newJsonWriter((Writer)var1));
        }
    }

    public void load() throws IOException {
        if (!this.file.exists()) {
            return;
        }
        try (BufferedReader var0 = Files.newReader((File)this.file, (Charset)StandardCharsets.UTF_8);){
            this.map.clear();
            JsonArray var1 = (JsonArray)GSON.fromJson((Reader)var0, JsonArray.class);
            if (var1 == null) {
                return;
            }
            for (JsonElement var3 : var1) {
                JsonObject var4 = ChatDeserializer.convertToJsonObject(var3, "entry");
                JsonListEntry<K> var5 = this.createEntry(var4);
                if (var5.getUser() == null) continue;
                this.map.put(this.getKeyForUser(var5.getUser()), var5);
            }
        }
    }
}

