/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat.commands;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.chars.CharList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.parsing.packrat.Control;
import net.minecraft.util.parsing.packrat.DelayedException;
import net.minecraft.util.parsing.packrat.ParseState;
import net.minecraft.util.parsing.packrat.Scope;
import net.minecraft.util.parsing.packrat.SuggestionSupplier;
import net.minecraft.util.parsing.packrat.Term;

public interface StringReaderTerms {
    public static Term<StringReader> word(String var0) {
        return new b(var0);
    }

    public static Term<StringReader> character(final char var0) {
        return new a(CharList.of((char)var0)){

            @Override
            protected boolean isAccepted(char var02) {
                return var0 == var02;
            }
        };
    }

    public static Term<StringReader> characters(final char var0, final char var1) {
        return new a(CharList.of((char)var0, (char)var1)){

            @Override
            protected boolean isAccepted(char var02) {
                return var02 == var0 || var02 == var1;
            }
        };
    }

    public static StringReader createReader(String var0, int var1) {
        StringReader var2 = new StringReader(var0);
        var2.setCursor(var1);
        return var2;
    }

    public static final class b
    implements Term<StringReader> {
        private final String value;
        private final DelayedException<CommandSyntaxException> error;
        private final SuggestionSupplier<StringReader> suggestions;

        public b(String var0) {
            this.value = var0;
            this.error = DelayedException.create(CommandSyntaxException.BUILT_IN_EXCEPTIONS.literalIncorrect(), var0);
            this.suggestions = var1 -> Stream.of(var0);
        }

        @Override
        public boolean parse(ParseState<StringReader> var0, Scope var1, Control var2) {
            var0.input().skipWhitespace();
            int var3 = var0.mark();
            String var4 = var0.input().readUnquotedString();
            if (!var4.equals(this.value)) {
                var0.errorCollector().store(var3, this.suggestions, this.error);
                return false;
            }
            return true;
        }

        public String toString() {
            return "terminal[" + this.value + "]";
        }
    }

    public static abstract class a
    implements Term<StringReader> {
        private final DelayedException<CommandSyntaxException> error;
        private final SuggestionSupplier<StringReader> suggestions;

        public a(CharList var0) {
            String var12 = var0.intStream().mapToObj(Character::toString).collect(Collectors.joining("|"));
            this.error = DelayedException.create(CommandSyntaxException.BUILT_IN_EXCEPTIONS.literalIncorrect(), String.valueOf(var12));
            this.suggestions = var1 -> var0.intStream().mapToObj(Character::toString);
        }

        @Override
        public boolean parse(ParseState<StringReader> var0, Scope var1, Control var2) {
            var0.input().skipWhitespace();
            int var3 = var0.mark();
            if (!var0.input().canRead() || !this.isAccepted(var0.input().read())) {
                var0.errorCollector().store(var3, this.suggestions, this.error);
                return false;
            }
            return true;
        }

        protected abstract boolean isAccepted(char var1);
    }
}

