/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorInteractDoor;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.state.IBlockData;

public class BehaviorSleep
extends Behavior<EntityLiving> {
    public static final int COOLDOWN_AFTER_BEING_WOKEN = 100;
    private long nextOkStartTime;

    public BehaviorSleep() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.HOME, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.LAST_WOKEN, (Object)((Object)MemoryStatus.REGISTERED)));
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityLiving var1) {
        long var5;
        if (var1.isPassenger()) {
            return false;
        }
        BehaviorController<?> var2 = var1.getBrain();
        GlobalPos var3 = var2.getMemory(MemoryModuleType.HOME).get();
        if (var0.dimension() != var3.dimension()) {
            return false;
        }
        Optional<Long> var4 = var2.getMemory(MemoryModuleType.LAST_WOKEN);
        if (var4.isPresent() && (var5 = var0.getGameTime() - var4.get()) > 0L && var5 < 100L) {
            return false;
        }
        IBlockData var52 = var0.getBlockState(var3.pos());
        return var3.pos().closerToCenterThan(var1.position(), 2.0) && var52.is(TagsBlock.BEDS) && var52.getValue(BlockBed.OCCUPIED) == false;
    }

    @Override
    protected boolean canStillUse(WorldServer var0, EntityLiving var1, long var2) {
        Optional<GlobalPos> var4 = var1.getBrain().getMemory(MemoryModuleType.HOME);
        if (var4.isEmpty()) {
            return false;
        }
        BlockPosition var5 = var4.get().pos();
        return var1.getBrain().isActive(Activity.REST) && var1.getY() > (double)var5.getY() + 0.4 && var5.closerToCenterThan(var1.position(), 1.14);
    }

    @Override
    protected void start(WorldServer var0, EntityLiving var1, long var2) {
        if (var2 > this.nextOkStartTime) {
            BehaviorController<Collection<Object>> var4 = var1.getBrain();
            if (var4.hasMemoryValue(MemoryModuleType.DOORS_TO_CLOSE)) {
                Set<GlobalPos> var5 = var4.getMemory(MemoryModuleType.DOORS_TO_CLOSE).get();
                Optional<List<EntityLiving>> var6 = var4.hasMemoryValue(MemoryModuleType.NEAREST_LIVING_ENTITIES) ? var4.getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES) : Optional.empty();
                BehaviorInteractDoor.closeDoorsThatIHaveOpenedOrPassedThrough(var0, var1, null, null, var5, var6);
            }
            var1.startSleeping(var1.getBrain().getMemory(MemoryModuleType.HOME).get().pos());
        }
    }

    @Override
    protected boolean timedOut(long var0) {
        return false;
    }

    @Override
    protected void stop(WorldServer var0, EntityLiving var1, long var2) {
        if (var1.isSleeping()) {
            var1.stopSleeping();
            this.nextOkStartTime = var2 + 40L;
        }
    }
}

