/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.ICrossbow;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemCrossbow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ChargedProjectiles;

public class PathfinderGoalCrossbowAttack<T extends EntityMonster & ICrossbow>
extends PathfinderGoal {
    public static final UniformInt PATHFINDING_DELAY_RANGE = TimeRange.rangeOfSeconds(1, 2);
    private final T mob;
    private State crossbowState = State.UNCHARGED;
    private final double speedModifier;
    private final float attackRadiusSqr;
    private int seeTime;
    private int attackDelay;
    private int updatePathDelay;

    public PathfinderGoalCrossbowAttack(T var0, double var1, float var3) {
        this.mob = var0;
        this.speedModifier = var1;
        this.attackRadiusSqr = var3 * var3;
        this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.LOOK));
    }

    @Override
    public boolean canUse() {
        return this.isValidTarget() && this.isHoldingCrossbow();
    }

    private boolean isHoldingCrossbow() {
        return ((EntityLiving)this.mob).isHolding(Items.CROSSBOW);
    }

    @Override
    public boolean canContinueToUse() {
        return this.isValidTarget() && (this.canUse() || !((EntityInsentient)this.mob).getNavigation().isDone()) && this.isHoldingCrossbow();
    }

    private boolean isValidTarget() {
        return ((EntityInsentient)this.mob).getTarget() != null && ((EntityInsentient)this.mob).getTarget().isAlive();
    }

    @Override
    public void stop() {
        super.stop();
        ((EntityInsentient)this.mob).setAggressive(false);
        ((EntityInsentient)this.mob).setTarget(null);
        this.seeTime = 0;
        if (((EntityLiving)this.mob).isUsingItem()) {
            ((EntityLiving)this.mob).stopUsingItem();
            ((ICrossbow)this.mob).setChargingCrossbow(false);
            ((EntityLiving)this.mob).getUseItem().set(DataComponents.CHARGED_PROJECTILES, ChargedProjectiles.EMPTY);
        }
    }

    @Override
    public boolean requiresUpdateEveryTick() {
        return true;
    }

    @Override
    public void tick() {
        boolean var5;
        boolean var2;
        EntityLiving var0 = ((EntityInsentient)this.mob).getTarget();
        if (var0 == null) {
            return;
        }
        boolean var1 = ((EntityInsentient)this.mob).getSensing().hasLineOfSight(var0);
        boolean bl = var2 = this.seeTime > 0;
        if (var1 != var2) {
            this.seeTime = 0;
        }
        this.seeTime = var1 ? ++this.seeTime : --this.seeTime;
        double var3 = ((Entity)this.mob).distanceToSqr(var0);
        boolean bl2 = var5 = (var3 > (double)this.attackRadiusSqr || this.seeTime < 5) && this.attackDelay == 0;
        if (var5) {
            --this.updatePathDelay;
            if (this.updatePathDelay <= 0) {
                ((EntityInsentient)this.mob).getNavigation().moveTo(var0, this.canRun() ? this.speedModifier : this.speedModifier * 0.5);
                this.updatePathDelay = PATHFINDING_DELAY_RANGE.sample(((Entity)this.mob).getRandom());
            }
        } else {
            this.updatePathDelay = 0;
            ((EntityInsentient)this.mob).getNavigation().stop();
        }
        ((EntityInsentient)this.mob).getLookControl().setLookAt(var0, 30.0f, 30.0f);
        if (this.crossbowState == State.UNCHARGED) {
            if (!var5) {
                ((EntityLiving)this.mob).startUsingItem(ProjectileHelper.getWeaponHoldingHand(this.mob, Items.CROSSBOW));
                this.crossbowState = State.CHARGING;
                ((ICrossbow)this.mob).setChargingCrossbow(true);
            }
        } else if (this.crossbowState == State.CHARGING) {
            ItemStack var7;
            int var6;
            if (!((EntityLiving)this.mob).isUsingItem()) {
                this.crossbowState = State.UNCHARGED;
            }
            if ((var6 = ((EntityLiving)this.mob).getTicksUsingItem()) >= ItemCrossbow.getChargeDuration(var7 = ((EntityLiving)this.mob).getUseItem(), this.mob)) {
                ((EntityLiving)this.mob).releaseUsingItem();
                this.crossbowState = State.CHARGED;
                this.attackDelay = 20 + ((Entity)this.mob).getRandom().nextInt(20);
                ((ICrossbow)this.mob).setChargingCrossbow(false);
            }
        } else if (this.crossbowState == State.CHARGED) {
            --this.attackDelay;
            if (this.attackDelay == 0) {
                this.crossbowState = State.READY_TO_ATTACK;
            }
        } else if (this.crossbowState == State.READY_TO_ATTACK && var1) {
            ((IRangedEntity)this.mob).performRangedAttack(var0, 1.0f);
            this.crossbowState = State.UNCHARGED;
        }
    }

    private boolean canRun() {
        return this.crossbowState == State.UNCHARGED;
    }

    static final class State
    extends Enum<State> {
        public static final /* enum */ State UNCHARGED = new State();
        public static final /* enum */ State CHARGING = new State();
        public static final /* enum */ State CHARGED = new State();
        public static final /* enum */ State READY_TO_ATTACK = new State();
        private static final /* synthetic */ State[] e;

        public static State[] values() {
            return (State[])e.clone();
        }

        public static State valueOf(String var0) {
            return Enum.valueOf(State.class, var0);
        }

        private static /* synthetic */ State[] a() {
            return new State[]{UNCHARGED, CHARGING, CHARGED, READY_TO_ATTACK};
        }

        static {
            e = State.a();
        }
    }
}

