/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveTowardsRestriction;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntitySmallFireball;
import net.minecraft.world.level.World;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;

public class EntityBlaze
extends EntityMonster {
    private float allowedHeightOffset = 0.5f;
    private int nextHeightOffsetChangeTick;
    private static final DataWatcherObject<Byte> DATA_FLAGS_ID = DataWatcher.defineId(EntityBlaze.class, DataWatcherRegistry.BYTE);

    public EntityBlaze(EntityTypes<? extends EntityBlaze> var0, World var1) {
        super((EntityTypes<? extends EntityMonster>)var0, var1);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.LAVA, 8.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, 0.0f);
        this.xpReward = 10;
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(4, new PathfinderGoalBlazeFireball(this));
        this.goalSelector.addGoal(5, new PathfinderGoalMoveTowardsRestriction(this, 1.0));
        this.goalSelector.addGoal(7, new PathfinderGoalRandomStrollLand((EntityCreature)this, 1.0, 0.0f));
        this.goalSelector.addGoal(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.goalSelector.addGoal(8, new PathfinderGoalRandomLookaround(this));
        this.targetSelector.addGoal(1, new PathfinderGoalHurtByTarget(this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityMonster.createMonsterAttributes().add(GenericAttributes.ATTACK_DAMAGE, 6.0).add(GenericAttributes.MOVEMENT_SPEED, 0.23f).add(GenericAttributes.FOLLOW_RANGE, 48.0);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_FLAGS_ID, (byte)0);
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.BLAZE_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.BLAZE_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.BLAZE_DEATH;
    }

    @Override
    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    @Override
    public void aiStep() {
        if (!this.onGround() && this.getDeltaMovement().y < 0.0) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.6, 1.0));
        }
        if (this.level().isClientSide) {
            if (this.random.nextInt(24) == 0 && !this.isSilent()) {
                this.level().playLocalSound(this.getX() + 0.5, this.getY() + 0.5, this.getZ() + 0.5, SoundEffects.BLAZE_BURN, this.getSoundSource(), 1.0f + this.random.nextFloat(), this.random.nextFloat() * 0.7f + 0.3f, false);
            }
            for (int var0 = 0; var0 < 2; ++var0) {
                this.level().addParticle(Particles.LARGE_SMOKE, this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
            }
        }
        super.aiStep();
    }

    @Override
    public boolean isSensitiveToWater() {
        return true;
    }

    @Override
    protected void customServerAiStep(WorldServer var0) {
        EntityLiving var1;
        --this.nextHeightOffsetChangeTick;
        if (this.nextHeightOffsetChangeTick <= 0) {
            this.nextHeightOffsetChangeTick = 100;
            this.allowedHeightOffset = (float)this.random.triangle(0.5, 6.891);
        }
        if ((var1 = this.getTarget()) != null && var1.getEyeY() > this.getEyeY() + (double)this.allowedHeightOffset && this.canAttack(var1)) {
            Vec3D var2 = this.getDeltaMovement();
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, ((double)0.3f - var2.y) * (double)0.3f, 0.0));
            this.hasImpulse = true;
        }
        super.customServerAiStep(var0);
    }

    @Override
    public boolean isOnFire() {
        return this.isCharged();
    }

    private boolean isCharged() {
        return (this.entityData.get(DATA_FLAGS_ID) & 1) != 0;
    }

    void setCharged(boolean var0) {
        byte var1 = this.entityData.get(DATA_FLAGS_ID);
        var1 = var0 ? (byte)(var1 | 1) : (byte)(var1 & 0xFFFFFFFE);
        this.entityData.set(DATA_FLAGS_ID, var1);
    }

    static class PathfinderGoalBlazeFireball
    extends PathfinderGoal {
        private final EntityBlaze blaze;
        private int attackStep;
        private int attackTime;
        private int lastSeen;

        public PathfinderGoalBlazeFireball(EntityBlaze var0) {
            this.blaze = var0;
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.LOOK));
        }

        @Override
        public boolean canUse() {
            EntityLiving var0 = this.blaze.getTarget();
            return var0 != null && var0.isAlive() && this.blaze.canAttack(var0);
        }

        @Override
        public void start() {
            this.attackStep = 0;
        }

        @Override
        public void stop() {
            this.blaze.setCharged(false);
            this.lastSeen = 0;
        }

        @Override
        public boolean requiresUpdateEveryTick() {
            return true;
        }

        @Override
        public void tick() {
            --this.attackTime;
            EntityLiving var0 = this.blaze.getTarget();
            if (var0 == null) {
                return;
            }
            boolean var1 = this.blaze.getSensing().hasLineOfSight(var0);
            this.lastSeen = var1 ? 0 : ++this.lastSeen;
            double var2 = this.blaze.distanceToSqr(var0);
            if (var2 < 4.0) {
                if (!var1) {
                    return;
                }
                if (this.attackTime <= 0) {
                    this.attackTime = 20;
                    this.blaze.doHurtTarget(PathfinderGoalBlazeFireball.getServerLevel(this.blaze), var0);
                }
                this.blaze.getMoveControl().setWantedPosition(var0.getX(), var0.getY(), var0.getZ(), 1.0);
            } else if (var2 < this.getFollowDistance() * this.getFollowDistance() && var1) {
                double var4 = var0.getX() - this.blaze.getX();
                double var6 = var0.getY(0.5) - this.blaze.getY(0.5);
                double var8 = var0.getZ() - this.blaze.getZ();
                if (this.attackTime <= 0) {
                    ++this.attackStep;
                    if (this.attackStep == 1) {
                        this.attackTime = 60;
                        this.blaze.setCharged(true);
                    } else if (this.attackStep <= 4) {
                        this.attackTime = 6;
                    } else {
                        this.attackTime = 100;
                        this.attackStep = 0;
                        this.blaze.setCharged(false);
                    }
                    if (this.attackStep > 1) {
                        double var10 = Math.sqrt(Math.sqrt(var2)) * 0.5;
                        if (!this.blaze.isSilent()) {
                            this.blaze.level().levelEvent(null, 1018, this.blaze.blockPosition(), 0);
                        }
                        for (int var12 = 0; var12 < 1; ++var12) {
                            Vec3D var13 = new Vec3D(this.blaze.getRandom().triangle(var4, 2.297 * var10), var6, this.blaze.getRandom().triangle(var8, 2.297 * var10));
                            EntitySmallFireball var14 = new EntitySmallFireball(this.blaze.level(), this.blaze, var13.normalize());
                            var14.setPos(var14.getX(), this.blaze.getY(0.5) + 0.5, var14.getZ());
                            this.blaze.level().addFreshEntity(var14);
                        }
                    }
                }
                this.blaze.getLookControl().setLookAt(var0, 10.0f, 10.0f);
            } else if (this.lastSeen < 5) {
                this.blaze.getMoveControl().setWantedPosition(var0.getX(), var0.getY(), var0.getZ(), 1.0);
            }
            super.tick();
        }

        private double getFollowDistance() {
            return this.blaze.getAttributeValue(GenericAttributes.FOLLOW_RANGE);
        }
    }
}

