/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import net.minecraft.server.level.WorldServer;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public interface InventoryCarrier {
    public static final String TAG_INVENTORY = "Inventory";

    public InventorySubcontainer getInventory();

    public static void pickUpItem(WorldServer var0, EntityInsentient var1, InventoryCarrier var2, EntityItem var3) {
        ItemStack var4 = var3.getItem();
        if (var1.wantsToPickUp(var0, var4)) {
            InventorySubcontainer var5 = var2.getInventory();
            boolean var6 = var5.canAddItem(var4);
            if (!var6) {
                return;
            }
            var1.onItemPickup(var3);
            int var7 = var4.getCount();
            ItemStack var8 = var5.addItem(var4);
            var1.take(var3, var7 - var8.getCount());
            if (var8.isEmpty()) {
                var3.discard();
            } else {
                var4.setCount(var8.getCount());
            }
        }
    }

    default public void readInventoryFromTag(ValueInput var02) {
        var02.list(TAG_INVENTORY, ItemStack.CODEC).ifPresent(var0 -> this.getInventory().fromItemList((ValueInput.a<ItemStack>)var0));
    }

    default public void writeInventoryToTag(ValueOutput var0) {
        this.getInventory().storeAsItemList(var0.list(TAG_INVENTORY, ItemStack.CODEC));
    }
}

