/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;

public abstract class VehicleEntity
extends Entity {
    protected static final DataWatcherObject<Integer> DATA_ID_HURT = DataWatcher.defineId(VehicleEntity.class, DataWatcherRegistry.INT);
    protected static final DataWatcherObject<Integer> DATA_ID_HURTDIR = DataWatcher.defineId(VehicleEntity.class, DataWatcherRegistry.INT);
    protected static final DataWatcherObject<Float> DATA_ID_DAMAGE = DataWatcher.defineId(VehicleEntity.class, DataWatcherRegistry.FLOAT);

    public VehicleEntity(EntityTypes<?> var0, World var1) {
        super(var0, var1);
    }

    @Override
    public boolean hurtClient(DamageSource var0) {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        if (this.isRemoved()) {
            return true;
        }
        if (this.isInvulnerableToBase(var1)) {
            return false;
        }
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.markHurt();
        this.setDamage(this.getDamage() + var2 * 10.0f);
        this.gameEvent(GameEvent.ENTITY_DAMAGE, var1.getEntity());
        var6_4 = var1.getEntity();
        if (!(var6_4 instanceof EntityHuman)) ** GOTO lbl-1000
        var4 = (EntityHuman)var6_4;
        if (var4.getAbilities().instabuild) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = var3 = false;
        }
        if (var3 == false && this.getDamage() > 40.0f || this.shouldSourceDestroy(var1)) {
            this.destroy(var0, var1);
        } else if (var3) {
            this.discard();
        }
        return true;
    }

    boolean shouldSourceDestroy(DamageSource var0) {
        return false;
    }

    @Override
    public boolean ignoreExplosion(Explosion var0) {
        return var0.getIndirectSourceEntity() instanceof EntityInsentient && !var0.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
    }

    public void destroy(WorldServer var0, Item var1) {
        this.kill(var0);
        if (!var0.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            return;
        }
        ItemStack var2 = new ItemStack(var1);
        var2.set(DataComponents.CUSTOM_NAME, this.getCustomName());
        this.spawnAtLocation(var0, var2);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        var0.define(DATA_ID_HURT, 0);
        var0.define(DATA_ID_HURTDIR, 1);
        var0.define(DATA_ID_DAMAGE, Float.valueOf(0.0f));
    }

    public void setHurtTime(int var0) {
        this.entityData.set(DATA_ID_HURT, var0);
    }

    public void setHurtDir(int var0) {
        this.entityData.set(DATA_ID_HURTDIR, var0);
    }

    public void setDamage(float var0) {
        this.entityData.set(DATA_ID_DAMAGE, Float.valueOf(var0));
    }

    public float getDamage() {
        return this.entityData.get(DATA_ID_DAMAGE).floatValue();
    }

    public int getHurtTime() {
        return this.entityData.get(DATA_ID_HURT);
    }

    public int getHurtDir() {
        return this.entityData.get(DATA_ID_HURTDIR);
    }

    protected void destroy(WorldServer var0, DamageSource var1) {
        this.destroy(var0, this.getDropItem());
    }

    @Override
    public int getDimensionChangingDelay() {
        return 10;
    }

    protected abstract Item getDropItem();
}

