/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.InventoryCraftResult;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.IBlockData;

public abstract class ContainerAnvilAbstract
extends Container {
    private static final int INVENTORY_SLOTS_PER_ROW = 9;
    private static final int INVENTORY_ROWS = 3;
    private static final int INPUT_SLOT_START = 0;
    protected final ContainerAccess access;
    protected final EntityHuman player;
    protected final IInventory inputSlots;
    protected final InventoryCraftResult resultSlots = new InventoryCraftResult(){

        @Override
        public void setChanged() {
            ContainerAnvilAbstract.this.slotsChanged(this);
        }
    };
    private final int resultSlotIndex;

    protected boolean mayPickup(EntityHuman var0, boolean var1) {
        return true;
    }

    protected abstract void onTake(EntityHuman var1, ItemStack var2);

    protected abstract boolean isValidBlock(IBlockData var1);

    public ContainerAnvilAbstract(@Nullable Containers<?> var0, int var1, PlayerInventory var2, ContainerAccess var3, ItemCombinerMenuSlotDefinition var4) {
        super(var0, var1);
        this.access = var3;
        this.player = var2.player;
        this.inputSlots = this.createContainer(var4.getNumOfInputSlots());
        this.resultSlotIndex = var4.getResultSlotIndex();
        this.createInputSlots(var4);
        this.createResultSlot(var4);
        this.addStandardInventorySlots(var2, 8, 84);
    }

    private void createInputSlots(ItemCombinerMenuSlotDefinition var0) {
        for (final ItemCombinerMenuSlotDefinition.b var2 : var0.getSlots()) {
            this.addSlot(new Slot(this, this.inputSlots, var2.slotIndex(), var2.x(), var2.y()){

                @Override
                public boolean mayPlace(ItemStack var0) {
                    return var2.mayPlace().test(var0);
                }
            });
        }
    }

    private void createResultSlot(ItemCombinerMenuSlotDefinition var0) {
        this.addSlot(new Slot(this.resultSlots, var0.getResultSlot().slotIndex(), var0.getResultSlot().x(), var0.getResultSlot().y()){

            @Override
            public boolean mayPlace(ItemStack var0) {
                return false;
            }

            @Override
            public boolean mayPickup(EntityHuman var0) {
                return ContainerAnvilAbstract.this.mayPickup(var0, this.hasItem());
            }

            @Override
            public void onTake(EntityHuman var0, ItemStack var1) {
                ContainerAnvilAbstract.this.onTake(var0, var1);
            }
        });
    }

    public abstract void createResult();

    private InventorySubcontainer createContainer(int var0) {
        return new InventorySubcontainer(var0){

            @Override
            public void setChanged() {
                super.setChanged();
                ContainerAnvilAbstract.this.slotsChanged(this);
            }
        };
    }

    @Override
    public void slotsChanged(IInventory var0) {
        super.slotsChanged(var0);
        if (var0 == this.inputSlots) {
            this.createResult();
        }
    }

    @Override
    public void removed(EntityHuman var0) {
        super.removed(var0);
        this.access.execute((var1, var2) -> this.clearContainer(var0, this.inputSlots));
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return this.access.evaluate((var1, var2) -> {
            if (!this.isValidBlock(var1.getBlockState((BlockPosition)var2))) {
                return false;
            }
            return var0.canInteractWithBlock((BlockPosition)var2, 4.0);
        }, true);
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman var0, int var1) {
        ItemStack var2 = ItemStack.EMPTY;
        Slot var3 = (Slot)this.slots.get(var1);
        if (var3 != null && var3.hasItem()) {
            ItemStack var4 = var3.getItem();
            var2 = var4.copy();
            int var5 = this.getInventorySlotStart();
            int var6 = this.getUseRowEnd();
            if (var1 == this.getResultSlot()) {
                if (!this.moveItemStackTo(var4, var5, var6, true)) {
                    return ItemStack.EMPTY;
                }
                var3.onQuickCraft(var4, var2);
            } else if (var1 >= 0 && var1 < this.getResultSlot() ? !this.moveItemStackTo(var4, var5, var6, false) : (this.canMoveIntoInputSlots(var4) && var1 >= this.getInventorySlotStart() && var1 < this.getUseRowEnd() ? !this.moveItemStackTo(var4, 0, this.getResultSlot(), false) : (var1 >= this.getInventorySlotStart() && var1 < this.getInventorySlotEnd() ? !this.moveItemStackTo(var4, this.getUseRowStart(), this.getUseRowEnd(), false) : var1 >= this.getUseRowStart() && var1 < this.getUseRowEnd() && !this.moveItemStackTo(var4, this.getInventorySlotStart(), this.getInventorySlotEnd(), false)))) {
                return ItemStack.EMPTY;
            }
            if (var4.isEmpty()) {
                var3.setByPlayer(ItemStack.EMPTY);
            } else {
                var3.setChanged();
            }
            if (var4.getCount() == var2.getCount()) {
                return ItemStack.EMPTY;
            }
            var3.onTake(var0, var4);
        }
        return var2;
    }

    protected boolean canMoveIntoInputSlots(ItemStack var0) {
        return true;
    }

    public int getResultSlot() {
        return this.resultSlotIndex;
    }

    private int getInventorySlotStart() {
        return this.getResultSlot() + 1;
    }

    private int getInventorySlotEnd() {
        return this.getInventorySlotStart() + 27;
    }

    private int getUseRowStart() {
        return this.getInventorySlotEnd();
    }

    private int getUseRowEnd() {
        return this.getUseRowStart() + 9;
    }
}

