/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.level.World;

public class SpyglassItem
extends Item {
    public static final int USE_DURATION = 1200;
    public static final float ZOOM_FOV_MODIFIER = 0.1f;

    public SpyglassItem(Item.Info var0) {
        super(var0);
    }

    @Override
    public int getUseDuration(ItemStack var0, EntityLiving var1) {
        return 1200;
    }

    @Override
    public ItemUseAnimation getUseAnimation(ItemStack var0) {
        return ItemUseAnimation.SPYGLASS;
    }

    @Override
    public EnumInteractionResult use(World var0, EntityHuman var1, EnumHand var2) {
        var1.playSound(SoundEffects.SPYGLASS_USE, 1.0f, 1.0f);
        var1.awardStat(StatisticList.ITEM_USED.get(this));
        return ItemLiquidUtil.startUsingInstantly(var0, var1, var2);
    }

    @Override
    public ItemStack finishUsingItem(ItemStack var0, World var1, EntityLiving var2) {
        this.stopUsing(var2);
        return var0;
    }

    @Override
    public boolean releaseUsing(ItemStack var0, World var1, EntityLiving var2, int var3) {
        this.stopUsing(var2);
        return true;
    }

    private void stopUsing(EntityLiving var0) {
        var0.playSound(SoundEffects.SPYGLASS_STOP_USING, 1.0f, 1.0f);
    }
}

