/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapedCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.World;

public class ShapedRecipes
implements RecipeCrafting {
    final ShapedRecipePattern pattern;
    final ItemStack result;
    final String group;
    final CraftingBookCategory category;
    final boolean showNotification;
    @Nullable
    private PlacementInfo placementInfo;

    public ShapedRecipes(String var0, CraftingBookCategory var1, ShapedRecipePattern var2, ItemStack var3, boolean var4) {
        this.group = var0;
        this.category = var1;
        this.pattern = var2;
        this.result = var3;
        this.showNotification = var4;
    }

    public ShapedRecipes(String var0, CraftingBookCategory var1, ShapedRecipePattern var2, ItemStack var3) {
        this(var0, var1, var2, var3, true);
    }

    @Override
    public RecipeSerializer<? extends ShapedRecipes> getSerializer() {
        return RecipeSerializer.SHAPED_RECIPE;
    }

    @Override
    public String group() {
        return this.group;
    }

    @Override
    public CraftingBookCategory category() {
        return this.category;
    }

    @VisibleForTesting
    public List<Optional<RecipeItemStack>> getIngredients() {
        return this.pattern.ingredients();
    }

    @Override
    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.createFromOptionals(this.pattern.ingredients());
        }
        return this.placementInfo;
    }

    @Override
    public boolean showNotification() {
        return this.showNotification;
    }

    @Override
    public boolean matches(CraftingInput var0, World var1) {
        return this.pattern.matches(var0);
    }

    @Override
    public ItemStack assemble(CraftingInput var0, HolderLookup.a var1) {
        return this.result.copy();
    }

    public int getWidth() {
        return this.pattern.width();
    }

    public int getHeight() {
        return this.pattern.height();
    }

    @Override
    public List<RecipeDisplay> display() {
        return List.of(new ShapedCraftingRecipeDisplay(this.pattern.width(), this.pattern.height(), this.pattern.ingredients().stream().map(var0 -> var0.map(RecipeItemStack::display).orElse(SlotDisplay.c.INSTANCE)).toList(), new SlotDisplay.f(this.result), new SlotDisplay.d(Items.CRAFTING_TABLE)));
    }

    public static class Serializer
    implements RecipeSerializer<ShapedRecipes> {
        public static final MapCodec<ShapedRecipes> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(var0 -> var0.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(var0 -> var0.category), (App)ShapedRecipePattern.MAP_CODEC.forGetter(var0 -> var0.pattern), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(var0 -> var0.result), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)true).forGetter(var0 -> var0.showNotification)).apply((Applicative)var02, ShapedRecipes::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapedRecipes> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @Override
        public MapCodec<ShapedRecipes> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, ShapedRecipes> streamCodec() {
            return STREAM_CODEC;
        }

        private static ShapedRecipes fromNetwork(RegistryFriendlyByteBuf var0) {
            String var1 = var0.readUtf();
            CraftingBookCategory var2 = var0.readEnum(CraftingBookCategory.class);
            ShapedRecipePattern var3 = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode(var0);
            ItemStack var4 = (ItemStack)ItemStack.STREAM_CODEC.decode(var0);
            boolean var5 = var0.readBoolean();
            return new ShapedRecipes(var1, var2, var3, var4, var5);
        }

        private static void toNetwork(RegistryFriendlyByteBuf var0, ShapedRecipes var1) {
            var0.writeUtf(var1.group);
            var0.writeEnum(var1.category);
            ShapedRecipePattern.STREAM_CODEC.encode(var0, var1.pattern);
            ItemStack.STREAM_CODEC.encode(var0, var1.result);
            var0.writeBoolean(var1.showNotification);
        }
    }
}

