/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProvider;
import net.minecraft.world.phys.Vec3D;

public record ReplaceDisk(LevelBasedValue radius, LevelBasedValue height, BaseBlockPosition offset, Optional<BlockPredicate> predicate, WorldGenFeatureStateProvider blockState, Optional<Holder<GameEvent>> triggerGameEvent) implements EnchantmentEntityEffect
{
    public static final MapCodec<ReplaceDisk> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)LevelBasedValue.CODEC.fieldOf("radius").forGetter(ReplaceDisk::radius), (App)LevelBasedValue.CODEC.fieldOf("height").forGetter(ReplaceDisk::height), (App)BaseBlockPosition.CODEC.optionalFieldOf("offset", (Object)BaseBlockPosition.ZERO).forGetter(ReplaceDisk::offset), (App)BlockPredicate.CODEC.optionalFieldOf("predicate").forGetter(ReplaceDisk::predicate), (App)WorldGenFeatureStateProvider.CODEC.fieldOf("block_state").forGetter(ReplaceDisk::blockState), (App)GameEvent.CODEC.optionalFieldOf("trigger_game_event").forGetter(ReplaceDisk::triggerGameEvent)).apply((Applicative)var0, ReplaceDisk::new));

    @Override
    public void apply(WorldServer var0, int var1, EnchantedItemInUse var22, Entity var32, Vec3D var4) {
        BlockPosition var5 = BlockPosition.containing(var4).offset(this.offset);
        RandomSource var6 = var32.getRandom();
        int var7 = (int)this.radius.calculate(var1);
        int var8 = (int)this.height.calculate(var1);
        for (BlockPosition var10 : BlockPosition.betweenClosed(var5.offset(-var7, 0, -var7), var5.offset(var7, Math.min(var8 - 1, 0), var7))) {
            if (!(var10.distToCenterSqr(var4.x(), (double)var10.getY() + 0.5, var4.z()) < (double)MathHelper.square(var7)) || !this.predicate.map(var2 -> var2.test(var0, var10)).orElse(true).booleanValue() || !var0.setBlockAndUpdate(var10, this.blockState.getState(var6, var10))) continue;
            this.triggerGameEvent.ifPresent(var3 -> var0.gameEvent(var32, (Holder<GameEvent>)var3, var10));
        }
    }

    public MapCodec<ReplaceDisk> codec() {
        return CODEC;
    }
}

