/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.BlockPropertyJigsawOrientation;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeCache;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;

public class CrafterBlock
extends BlockTileEntity {
    public static final MapCodec<CrafterBlock> CODEC = CrafterBlock.simpleCodec(CrafterBlock::new);
    public static final BlockStateBoolean CRAFTING = BlockProperties.CRAFTING;
    public static final BlockStateBoolean TRIGGERED = BlockProperties.TRIGGERED;
    private static final BlockStateEnum<BlockPropertyJigsawOrientation> ORIENTATION = BlockProperties.ORIENTATION;
    private static final int MAX_CRAFTING_TICKS = 6;
    private static final int CRAFTING_TICK_DELAY = 4;
    private static final RecipeCache RECIPE_CACHE = new RecipeCache(10);
    private static final int CRAFTER_ADVANCEMENT_DIAMETER = 17;

    public CrafterBlock(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(ORIENTATION, BlockPropertyJigsawOrientation.NORTH_UP)).setValue(TRIGGERED, false)).setValue(CRAFTING, false));
    }

    protected MapCodec<CrafterBlock> codec() {
        return CODEC;
    }

    @Override
    protected boolean hasAnalogOutputSignal(IBlockData var0) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(IBlockData var0, World var1, BlockPosition var2) {
        TileEntity var3 = var1.getBlockEntity(var2);
        if (var3 instanceof CrafterBlockEntity) {
            CrafterBlockEntity var4 = (CrafterBlockEntity)var3;
            return var4.getRedstoneSignal();
        }
        return 0;
    }

    @Override
    protected void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, @Nullable Orientation var4, boolean var5) {
        boolean var6 = var1.hasNeighborSignal(var2);
        boolean var7 = var0.getValue(TRIGGERED);
        TileEntity var8 = var1.getBlockEntity(var2);
        if (var6 && !var7) {
            var1.scheduleTick(var2, this, 4);
            var1.setBlock(var2, (IBlockData)var0.setValue(TRIGGERED, true), 2);
            this.setBlockEntityTriggered(var8, true);
        } else if (!var6 && var7) {
            var1.setBlock(var2, (IBlockData)((IBlockData)var0.setValue(TRIGGERED, false)).setValue(CRAFTING, false), 2);
            this.setBlockEntityTriggered(var8, false);
        }
    }

    @Override
    protected void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        this.dispenseFrom(var0, var1, var2);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> getTicker(World var0, IBlockData var1, TileEntityTypes<T> var2) {
        return var0.isClientSide ? null : CrafterBlock.createTickerHelper(var2, TileEntityTypes.CRAFTER, CrafterBlockEntity::serverTick);
    }

    private void setBlockEntityTriggered(@Nullable TileEntity var0, boolean var1) {
        if (var0 instanceof CrafterBlockEntity) {
            CrafterBlockEntity var2 = (CrafterBlockEntity)var0;
            var2.setTriggered(var1);
        }
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        CrafterBlockEntity var2 = new CrafterBlockEntity(var0, var1);
        var2.setTriggered(var1.hasProperty(TRIGGERED) && var1.getValue(TRIGGERED) != false);
        return var2;
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        EnumDirection var1 = var0.getNearestLookingDirection().getOpposite();
        EnumDirection var2 = switch (var1) {
            default -> throw new MatchException(null, null);
            case EnumDirection.DOWN -> var0.getHorizontalDirection().getOpposite();
            case EnumDirection.UP -> var0.getHorizontalDirection();
            case EnumDirection.NORTH, EnumDirection.SOUTH, EnumDirection.WEST, EnumDirection.EAST -> EnumDirection.UP;
        };
        return (IBlockData)((IBlockData)this.defaultBlockState().setValue(ORIENTATION, BlockPropertyJigsawOrientation.fromFrontAndTop(var1, var2))).setValue(TRIGGERED, var0.getLevel().hasNeighborSignal(var0.getClickedPos()));
    }

    @Override
    public void setPlacedBy(World var0, BlockPosition var1, IBlockData var2, EntityLiving var3, ItemStack var4) {
        if (var2.getValue(TRIGGERED).booleanValue()) {
            var0.scheduleTick(var1, this, 4);
        }
    }

    @Override
    protected void affectNeighborsAfterRemoval(IBlockData var0, WorldServer var1, BlockPosition var2, boolean var3) {
        InventoryUtils.updateNeighboursAfterDestroy(var0, var1, var2);
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        TileEntity tileEntity;
        if (!var1.isClientSide && (tileEntity = var1.getBlockEntity(var2)) instanceof CrafterBlockEntity) {
            CrafterBlockEntity var5 = (CrafterBlockEntity)tileEntity;
            var3.openMenu(var5);
        }
        return EnumInteractionResult.SUCCESS;
    }

    protected void dispenseFrom(IBlockData var02, WorldServer var1, BlockPosition var2) {
        TileEntity tileEntity = var1.getBlockEntity(var2);
        if (!(tileEntity instanceof CrafterBlockEntity)) {
            return;
        }
        CrafterBlockEntity var3 = (CrafterBlockEntity)tileEntity;
        CraftingInput var4 = var3.asCraftInput();
        Optional<RecipeHolder<RecipeCrafting>> var5 = CrafterBlock.getPotentialResults(var1, var4);
        if (var5.isEmpty()) {
            var1.levelEvent(1050, var2, 0);
            return;
        }
        RecipeHolder<RecipeCrafting> var6 = var5.get();
        ItemStack var7 = var6.value().assemble(var4, var1.registryAccess());
        if (var7.isEmpty()) {
            var1.levelEvent(1050, var2, 0);
            return;
        }
        var3.setCraftingTicksRemaining(6);
        var1.setBlock(var2, (IBlockData)var02.setValue(CRAFTING, true), 2);
        var7.onCraftedBySystem(var1);
        this.dispenseItem(var1, var2, var3, var7, var02, var6);
        for (ItemStack var9 : var6.value().getRemainingItems(var4)) {
            if (var9.isEmpty()) continue;
            this.dispenseItem(var1, var2, var3, var9, var02, var6);
        }
        var3.getItems().forEach(var0 -> {
            if (var0.isEmpty()) {
                return;
            }
            var0.shrink(1);
        });
        var3.setChanged();
    }

    public static Optional<RecipeHolder<RecipeCrafting>> getPotentialResults(WorldServer var0, CraftingInput var1) {
        return RECIPE_CACHE.get(var0, var1);
    }

    private void dispenseItem(WorldServer var0, BlockPosition var1, CrafterBlockEntity var2, ItemStack var3, IBlockData var4, RecipeHolder<?> var5) {
        Object var9;
        Object var10;
        EnumDirection var6 = var4.getValue(ORIENTATION).front();
        IInventory var7 = TileEntityHopper.getContainerAt(var0, var1.relative(var6));
        ItemStack var8 = var3.copy();
        if (var7 != null && (var7 instanceof CrafterBlockEntity || var3.getCount() > var7.getMaxStackSize(var3))) {
            while (!var8.isEmpty() && ((ItemStack)(var10 = TileEntityHopper.addItem(var2, var7, (ItemStack)(var9 = var8.copyWithCount(1)), var6.getOpposite()))).isEmpty()) {
                var8.shrink(1);
            }
        } else if (var7 != null) {
            int var92;
            while (!var8.isEmpty() && (var92 = var8.getCount()) != (var8 = TileEntityHopper.addItem(var2, var7, var8, var6.getOpposite())).getCount()) {
            }
        }
        if (!var8.isEmpty()) {
            var9 = Vec3D.atCenterOf(var1);
            var10 = ((Vec3D)var9).relative(var6, 0.7);
            DispenseBehaviorItem.spawnItem(var0, var8, 6, var6, (IPosition)var10);
            for (EntityPlayer var12 : var0.getEntitiesOfClass(EntityPlayer.class, AxisAlignedBB.ofSize((Vec3D)var9, 17.0, 17.0, 17.0))) {
                CriterionTriggers.CRAFTER_RECIPE_CRAFTED.trigger(var12, var5.id(), var2.getItems());
            }
            var0.levelEvent(1049, var1, 0);
            var0.levelEvent(2010, var1, var6.get3DDataValue());
        }
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(ORIENTATION, var1.rotation().rotate(var0.getValue(ORIENTATION)));
    }

    @Override
    protected IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return (IBlockData)var0.setValue(ORIENTATION, var1.rotation().rotate(var0.getValue(ORIENTATION)));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(ORIENTATION, TRIGGERED, CRAFTING);
    }
}

