/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ProtoChunkTickList;
import net.minecraft.world.ticks.TickContainerAccess;
import org.slf4j.Logger;

public class ProtoChunk
extends IChunkAccess {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private volatile LevelLightEngine lightEngine;
    private volatile ChunkStatus status = ChunkStatus.EMPTY;
    private final List<NBTTagCompound> entities = Lists.newArrayList();
    @Nullable
    private CarvingMask carvingMask;
    @Nullable
    private BelowZeroRetrogen belowZeroRetrogen;
    private final ProtoChunkTickList<Block> blockTicks;
    private final ProtoChunkTickList<FluidType> fluidTicks;

    public ProtoChunk(ChunkCoordIntPair var0, ChunkConverter var1, LevelHeightAccessor var2, IRegistry<BiomeBase> var3, @Nullable BlendingData var4) {
        this(var0, var1, null, new ProtoChunkTickList<Block>(), new ProtoChunkTickList<FluidType>(), var2, var3, var4);
    }

    public ProtoChunk(ChunkCoordIntPair var0, ChunkConverter var1, @Nullable ChunkSection[] var2, ProtoChunkTickList<Block> var3, ProtoChunkTickList<FluidType> var4, LevelHeightAccessor var5, IRegistry<BiomeBase> var6, @Nullable BlendingData var7) {
        super(var0, var1, var5, var6, 0L, var2, var7);
        this.blockTicks = var3;
        this.fluidTicks = var4;
    }

    @Override
    public TickContainerAccess<Block> getBlockTicks() {
        return this.blockTicks;
    }

    @Override
    public TickContainerAccess<FluidType> getFluidTicks() {
        return this.fluidTicks;
    }

    @Override
    public IChunkAccess.b getTicksForSerialization(long var0) {
        return new IChunkAccess.b(this.blockTicks.pack(var0), this.fluidTicks.pack(var0));
    }

    @Override
    public IBlockData getBlockState(BlockPosition var0) {
        int var1 = var0.getY();
        if (this.isOutsideBuildHeight(var1)) {
            return Blocks.VOID_AIR.defaultBlockState();
        }
        ChunkSection var2 = this.getSection(this.getSectionIndex(var1));
        if (var2.hasOnlyAir()) {
            return Blocks.AIR.defaultBlockState();
        }
        return var2.getBlockState(var0.getX() & 0xF, var1 & 0xF, var0.getZ() & 0xF);
    }

    @Override
    public Fluid getFluidState(BlockPosition var0) {
        int var1 = var0.getY();
        if (this.isOutsideBuildHeight(var1)) {
            return FluidTypes.EMPTY.defaultFluidState();
        }
        ChunkSection var2 = this.getSection(this.getSectionIndex(var1));
        if (var2.hasOnlyAir()) {
            return FluidTypes.EMPTY.defaultFluidState();
        }
        return var2.getFluidState(var0.getX() & 0xF, var1 & 0xF, var0.getZ() & 0xF);
    }

    @Override
    @Nullable
    public IBlockData setBlockState(BlockPosition var0, IBlockData var1, int var2) {
        int var3 = var0.getX();
        int var4 = var0.getY();
        int var5 = var0.getZ();
        if (this.isOutsideBuildHeight(var4)) {
            return Blocks.VOID_AIR.defaultBlockState();
        }
        int var6 = this.getSectionIndex(var4);
        ChunkSection var7 = this.getSection(var6);
        boolean var8 = var7.hasOnlyAir();
        if (var8 && var1.is(Blocks.AIR)) {
            return var1;
        }
        int var9 = SectionPosition.sectionRelative(var3);
        int var10 = SectionPosition.sectionRelative(var4);
        int var11 = SectionPosition.sectionRelative(var5);
        IBlockData var12 = var7.setBlockState(var9, var10, var11, var1);
        if (this.status.isOrAfter(ChunkStatus.INITIALIZE_LIGHT)) {
            boolean var13 = var7.hasOnlyAir();
            if (var13 != var8) {
                this.lightEngine.updateSectionStatus(var0, var13);
            }
            if (LightEngine.hasDifferentLightProperties(var12, var1)) {
                this.skyLightSources.update(this, var9, var4, var11);
                this.lightEngine.checkBlock(var0);
            }
        }
        EnumSet<HeightMap.Type> var13 = this.getPersistedStatus().heightmapsAfter();
        EnumSet<HeightMap.Type> var14 = null;
        for (HeightMap.Type var16 : var13) {
            HeightMap var17 = (HeightMap)this.heightmaps.get(var16);
            if (var17 != null) continue;
            if (var14 == null) {
                var14 = EnumSet.noneOf(HeightMap.Type.class);
            }
            var14.add(var16);
        }
        if (var14 != null) {
            HeightMap.primeHeightmaps(this, var14);
        }
        for (HeightMap.Type var16 : var13) {
            ((HeightMap)this.heightmaps.get(var16)).update(var9, var4, var11, var1);
        }
        return var12;
    }

    @Override
    public void setBlockEntity(TileEntity var0) {
        this.pendingBlockEntities.remove(var0.getBlockPos());
        this.blockEntities.put(var0.getBlockPos(), var0);
    }

    @Override
    @Nullable
    public TileEntity getBlockEntity(BlockPosition var0) {
        return (TileEntity)this.blockEntities.get(var0);
    }

    public Map<BlockPosition, TileEntity> getBlockEntities() {
        return this.blockEntities;
    }

    public void addEntity(NBTTagCompound var0) {
        this.entities.add(var0);
    }

    @Override
    public void addEntity(Entity var0) {
        if (var0.isPassenger()) {
            return;
        }
        try (ProblemReporter.j var1 = new ProblemReporter.j(var0.problemPath(), LOGGER);){
            TagValueOutput var2 = TagValueOutput.createWithContext(var1, var0.registryAccess());
            var0.save(var2);
            this.addEntity(var2.buildResult());
        }
    }

    @Override
    public void setStartForStructure(Structure var0, StructureStart var1) {
        BelowZeroRetrogen var2 = this.getBelowZeroRetrogen();
        if (var2 != null && var1.isValid()) {
            StructureBoundingBox var3 = var1.getBoundingBox();
            LevelHeightAccessor var4 = this.getHeightAccessorForGeneration();
            if (var3.minY() < var4.getMinY() || var3.maxY() > var4.getMaxY()) {
                return;
            }
        }
        super.setStartForStructure(var0, var1);
    }

    public List<NBTTagCompound> getEntities() {
        return this.entities;
    }

    @Override
    public ChunkStatus getPersistedStatus() {
        return this.status;
    }

    public void setPersistedStatus(ChunkStatus var0) {
        this.status = var0;
        if (this.belowZeroRetrogen != null && var0.isOrAfter(this.belowZeroRetrogen.targetStatus())) {
            this.setBelowZeroRetrogen(null);
        }
        this.markUnsaved();
    }

    @Override
    public Holder<BiomeBase> getNoiseBiome(int var0, int var1, int var2) {
        if (this.getHighestGeneratedStatus().isOrAfter(ChunkStatus.BIOMES)) {
            return super.getNoiseBiome(var0, var1, var2);
        }
        throw new IllegalStateException("Asking for biomes before we have biomes");
    }

    public static short packOffsetCoordinates(BlockPosition var0) {
        int var1 = var0.getX();
        int var2 = var0.getY();
        int var3 = var0.getZ();
        int var4 = var1 & 0xF;
        int var5 = var2 & 0xF;
        int var6 = var3 & 0xF;
        return (short)(var4 | var5 << 4 | var6 << 8);
    }

    public static BlockPosition unpackOffsetCoordinates(short var0, int var1, ChunkCoordIntPair var2) {
        int var3 = SectionPosition.sectionToBlockCoord(var2.x, var0 & 0xF);
        int var4 = SectionPosition.sectionToBlockCoord(var1, var0 >>> 4 & 0xF);
        int var5 = SectionPosition.sectionToBlockCoord(var2.z, var0 >>> 8 & 0xF);
        return new BlockPosition(var3, var4, var5);
    }

    @Override
    public void markPosForPostprocessing(BlockPosition var0) {
        if (!this.isOutsideBuildHeight(var0)) {
            IChunkAccess.getOrCreateOffsetList(this.postProcessing, this.getSectionIndex(var0.getY())).add(ProtoChunk.packOffsetCoordinates(var0));
        }
    }

    @Override
    public void addPackedPostProcess(ShortList var0, int var1) {
        IChunkAccess.getOrCreateOffsetList(this.postProcessing, var1).addAll(var0);
    }

    public Map<BlockPosition, NBTTagCompound> getBlockEntityNbts() {
        return Collections.unmodifiableMap(this.pendingBlockEntities);
    }

    @Override
    @Nullable
    public NBTTagCompound getBlockEntityNbtForSaving(BlockPosition var0, HolderLookup.a var1) {
        TileEntity var2 = this.getBlockEntity(var0);
        if (var2 != null) {
            return var2.saveWithFullMetadata(var1);
        }
        return (NBTTagCompound)this.pendingBlockEntities.get(var0);
    }

    @Override
    public void removeBlockEntity(BlockPosition var0) {
        this.blockEntities.remove(var0);
        this.pendingBlockEntities.remove(var0);
    }

    @Nullable
    public CarvingMask getCarvingMask() {
        return this.carvingMask;
    }

    public CarvingMask getOrCreateCarvingMask() {
        if (this.carvingMask == null) {
            this.carvingMask = new CarvingMask(this.getHeight(), this.getMinY());
        }
        return this.carvingMask;
    }

    public void setCarvingMask(CarvingMask var0) {
        this.carvingMask = var0;
    }

    public void setLightEngine(LevelLightEngine var0) {
        this.lightEngine = var0;
    }

    public void setBelowZeroRetrogen(@Nullable BelowZeroRetrogen var0) {
        this.belowZeroRetrogen = var0;
    }

    @Override
    @Nullable
    public BelowZeroRetrogen getBelowZeroRetrogen() {
        return this.belowZeroRetrogen;
    }

    private static <T> LevelChunkTicks<T> unpackTicks(ProtoChunkTickList<T> var0) {
        return new LevelChunkTicks<T>(var0.scheduledTicks());
    }

    public LevelChunkTicks<Block> unpackBlockTicks() {
        return ProtoChunk.unpackTicks(this.blockTicks);
    }

    public LevelChunkTicks<FluidType> unpackFluidTicks() {
        return ProtoChunk.unpackTicks(this.fluidTicks);
    }

    @Override
    public LevelHeightAccessor getHeightAccessorForGeneration() {
        if (this.isUpgrading()) {
            return BelowZeroRetrogen.UPGRADE_HEIGHT_ACCESSOR;
        }
        return this;
    }
}

