/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.VarInt;
import net.minecraft.world.level.chunk.DataPalette;
import net.minecraft.world.level.chunk.DataPaletteExpandable;
import org.apache.commons.lang3.Validate;

public class SingleValuePalette<T>
implements DataPalette<T> {
    private final Registry<T> registry;
    @Nullable
    private T value;
    private final DataPaletteExpandable<T> resizeHandler;

    public SingleValuePalette(Registry<T> var0, DataPaletteExpandable<T> var1, List<T> var2) {
        this.registry = var0;
        this.resizeHandler = var1;
        if (var2.size() > 0) {
            Validate.isTrue((var2.size() <= 1 ? 1 : 0) != 0, (String)"Can't initialize SingleValuePalette with %d values.", (long)var2.size());
            this.value = var2.get(0);
        }
    }

    public static <A> DataPalette<A> create(int var0, Registry<A> var1, DataPaletteExpandable<A> var2, List<A> var3) {
        return new SingleValuePalette<A>(var1, var2, var3);
    }

    @Override
    public int idFor(T var0) {
        if (this.value == null || this.value == var0) {
            this.value = var0;
            return 0;
        }
        return this.resizeHandler.onResize(1, var0);
    }

    @Override
    public boolean maybeHas(Predicate<T> var0) {
        if (this.value == null) {
            throw new IllegalStateException("Use of an uninitialized palette");
        }
        return var0.test(this.value);
    }

    @Override
    public T valueFor(int var0) {
        if (this.value == null || var0 != 0) {
            throw new IllegalStateException("Missing Palette entry for id " + var0 + ".");
        }
        return this.value;
    }

    @Override
    public void read(PacketDataSerializer var0) {
        this.value = this.registry.byIdOrThrow(var0.readVarInt());
    }

    @Override
    public void write(PacketDataSerializer var0) {
        if (this.value == null) {
            throw new IllegalStateException("Use of an uninitialized palette");
        }
        var0.writeVarInt(this.registry.getId(this.value));
    }

    @Override
    public int getSerializedSize() {
        if (this.value == null) {
            throw new IllegalStateException("Use of an uninitialized palette");
        }
        return VarInt.getByteSize(this.registry.getId(this.value));
    }

    @Override
    public int getSize() {
        return 1;
    }

    @Override
    public DataPalette<T> copy(DataPaletteExpandable<T> var0) {
        if (this.value == null) {
            throw new IllegalStateException("Use of an uninitialized palette");
        }
        return this;
    }
}

