/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.DataBits;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SimpleBitStorage;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.IChunkAccess;
import org.slf4j.Logger;

public class HeightMap {
    private static final Logger LOGGER = LogUtils.getLogger();
    static final Predicate<IBlockData> NOT_AIR = var0 -> !var0.isAir();
    static final Predicate<IBlockData> MATERIAL_MOTION_BLOCKING = BlockBase.BlockData::blocksMotion;
    private final DataBits data;
    private final Predicate<IBlockData> isOpaque;
    private final IChunkAccess chunk;

    public HeightMap(IChunkAccess var0, Type var1) {
        this.isOpaque = var1.isOpaque();
        this.chunk = var0;
        int var2 = MathHelper.ceillog2(var0.getHeight() + 1);
        this.data = new SimpleBitStorage(var2, 256);
    }

    public static void primeHeightmaps(IChunkAccess var0, Set<Type> var1) {
        if (var1.isEmpty()) {
            return;
        }
        int var2 = var1.size();
        ObjectArrayList var3 = new ObjectArrayList(var2);
        ObjectListIterator var4 = var3.iterator();
        int var5 = var0.getHighestSectionPosition() + 16;
        BlockPosition.MutableBlockPosition var6 = new BlockPosition.MutableBlockPosition();
        for (int var7 = 0; var7 < 16; ++var7) {
            block1: for (int var8 = 0; var8 < 16; ++var8) {
                for (Type type : var1) {
                    var3.add((Object)var0.getOrCreateHeightmapUnprimed(type));
                }
                for (int var9 = var5 - 1; var9 >= var0.getMinY(); --var9) {
                    var6.set(var7, var9, var8);
                    IBlockData iBlockData = var0.getBlockState(var6);
                    if (iBlockData.is(Blocks.AIR)) continue;
                    while (var4.hasNext()) {
                        HeightMap var11 = (HeightMap)var4.next();
                        if (!var11.isOpaque.test(iBlockData)) continue;
                        var11.setHeight(var7, var8, var9 + 1);
                        var4.remove();
                    }
                    if (var3.isEmpty()) continue block1;
                    var4.back(var2);
                }
            }
        }
    }

    public boolean update(int var0, int var1, int var2, IBlockData var3) {
        int var4 = this.getFirstAvailable(var0, var2);
        if (var1 <= var4 - 2) {
            return false;
        }
        if (this.isOpaque.test(var3)) {
            if (var1 >= var4) {
                this.setHeight(var0, var2, var1 + 1);
                return true;
            }
        } else if (var4 - 1 == var1) {
            BlockPosition.MutableBlockPosition var5 = new BlockPosition.MutableBlockPosition();
            for (int var6 = var1 - 1; var6 >= this.chunk.getMinY(); --var6) {
                var5.set(var0, var6, var2);
                if (!this.isOpaque.test(this.chunk.getBlockState(var5))) continue;
                this.setHeight(var0, var2, var6 + 1);
                return true;
            }
            this.setHeight(var0, var2, this.chunk.getMinY());
            return true;
        }
        return false;
    }

    public int getFirstAvailable(int var0, int var1) {
        return this.getFirstAvailable(HeightMap.getIndex(var0, var1));
    }

    public int getHighestTaken(int var0, int var1) {
        return this.getFirstAvailable(HeightMap.getIndex(var0, var1)) - 1;
    }

    private int getFirstAvailable(int var0) {
        return this.data.get(var0) + this.chunk.getMinY();
    }

    private void setHeight(int var0, int var1, int var2) {
        this.data.set(HeightMap.getIndex(var0, var1), var2 - this.chunk.getMinY());
    }

    public void setRawData(IChunkAccess var0, Type var1, long[] var2) {
        long[] var3 = this.data.getRaw();
        if (var3.length == var2.length) {
            System.arraycopy(var2, 0, var3, 0, var2.length);
            return;
        }
        LOGGER.warn("Ignoring heightmap data for chunk " + String.valueOf(var0.getPos()) + ", size does not match; expected: " + var3.length + ", got: " + var2.length);
        HeightMap.primeHeightmaps(var0, EnumSet.of(var1));
    }

    public long[] getRawData() {
        return this.data.getRaw();
    }

    private static int getIndex(int var0, int var1) {
        return var0 + var1 * 16;
    }

    public static final class Type
    extends Enum<Type>
    implements INamable {
        public static final /* enum */ Type WORLD_SURFACE_WG = new Type(0, "WORLD_SURFACE_WG", Use.WORLDGEN, NOT_AIR);
        public static final /* enum */ Type WORLD_SURFACE = new Type(1, "WORLD_SURFACE", Use.CLIENT, NOT_AIR);
        public static final /* enum */ Type OCEAN_FLOOR_WG = new Type(2, "OCEAN_FLOOR_WG", Use.WORLDGEN, MATERIAL_MOTION_BLOCKING);
        public static final /* enum */ Type OCEAN_FLOOR = new Type(3, "OCEAN_FLOOR", Use.LIVE_WORLD, MATERIAL_MOTION_BLOCKING);
        public static final /* enum */ Type MOTION_BLOCKING = new Type(4, "MOTION_BLOCKING", Use.CLIENT, var0 -> var0.blocksMotion() || !var0.getFluidState().isEmpty());
        public static final /* enum */ Type MOTION_BLOCKING_NO_LEAVES = new Type(5, "MOTION_BLOCKING_NO_LEAVES", Use.CLIENT, var0 -> (var0.blocksMotion() || !var0.getFluidState().isEmpty()) && !(var0.getBlock() instanceof BlockLeaves));
        public static final Codec<Type> CODEC;
        private static final IntFunction<Type> BY_ID;
        public static final StreamCodec<ByteBuf, Type> STREAM_CODEC;
        private final int id;
        private final String serializationKey;
        private final Use usage;
        private final Predicate<IBlockData> isOpaque;
        private static final /* synthetic */ Type[] n;

        public static Type[] values() {
            return (Type[])n.clone();
        }

        public static Type valueOf(String var0) {
            return Enum.valueOf(Type.class, var0);
        }

        private Type(int var2, String var3, Use var4, Predicate var5) {
            this.id = var2;
            this.serializationKey = var3;
            this.usage = var4;
            this.isOpaque = var5;
        }

        public String getSerializationKey() {
            return this.serializationKey;
        }

        public boolean sendToClient() {
            return this.usage == Use.CLIENT;
        }

        public boolean keepAfterWorldgen() {
            return this.usage != Use.WORLDGEN;
        }

        public Predicate<IBlockData> isOpaque() {
            return this.isOpaque;
        }

        @Override
        public String getSerializedName() {
            return this.serializationKey;
        }

        private static /* synthetic */ Type[] f() {
            return new Type[]{WORLD_SURFACE_WG, WORLD_SURFACE, OCEAN_FLOOR_WG, OCEAN_FLOOR, MOTION_BLOCKING, MOTION_BLOCKING_NO_LEAVES};
        }

        static {
            n = Type.f();
            CODEC = INamable.fromEnum(Type::values);
            BY_ID = ByIdMap.continuous(var0 -> var0.id, Type.values(), ByIdMap.a.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, var0 -> var0.id);
        }
    }

    public static final class Use
    extends Enum<Use> {
        public static final /* enum */ Use WORLDGEN = new Use();
        public static final /* enum */ Use LIVE_WORLD = new Use();
        public static final /* enum */ Use CLIENT = new Use();
        private static final /* synthetic */ Use[] d;

        public static Use[] values() {
            return (Use[])d.clone();
        }

        public static Use valueOf(String var0) {
            return Enum.valueOf(Use.class, var0);
        }

        private static /* synthetic */ Use[] a() {
            return new Use[]{WORLDGEN, LIVE_WORLD, CLIENT};
        }

        static {
            d = Use.a();
        }
    }
}

