/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.BlockVine;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTree;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTrees;

public class WorldGenFeatureTreeVineLeaves
extends WorldGenFeatureTree {
    public static final MapCodec<WorldGenFeatureTreeVineLeaves> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(WorldGenFeatureTreeVineLeaves::new, var0 -> Float.valueOf(var0.probability));
    private final float probability;

    @Override
    protected WorldGenFeatureTrees<?> type() {
        return WorldGenFeatureTrees.LEAVE_VINE;
    }

    public WorldGenFeatureTreeVineLeaves(float var0) {
        this.probability = var0;
    }

    @Override
    public void place(WorldGenFeatureTree.a var0) {
        RandomSource var1 = var0.random();
        var0.leaves().forEach(var2 -> {
            BlockPosition var3;
            if (var1.nextFloat() < this.probability && var0.isAir(var3 = var2.west())) {
                WorldGenFeatureTreeVineLeaves.addHangingVine(var3, BlockVine.EAST, var0);
            }
            if (var1.nextFloat() < this.probability && var0.isAir(var3 = var2.east())) {
                WorldGenFeatureTreeVineLeaves.addHangingVine(var3, BlockVine.WEST, var0);
            }
            if (var1.nextFloat() < this.probability && var0.isAir(var3 = var2.north())) {
                WorldGenFeatureTreeVineLeaves.addHangingVine(var3, BlockVine.SOUTH, var0);
            }
            if (var1.nextFloat() < this.probability && var0.isAir(var3 = var2.south())) {
                WorldGenFeatureTreeVineLeaves.addHangingVine(var3, BlockVine.NORTH, var0);
            }
        });
    }

    private static void addHangingVine(BlockPosition var0, BlockStateBoolean var1, WorldGenFeatureTree.a var2) {
        var2.placeVine(var0, var1);
        var0 = var0.below();
        for (int var3 = 4; var2.isAir(var0) && var3 > 0; --var3) {
            var2.placeVine(var0, var1);
            var0 = var0.below();
        }
    }
}

