/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.levelgen.structure.PersistentIndexed;
import net.minecraft.world.level.storage.WorldPersistentData;

public class PersistentStructureLegacy {
    private static final Map<String, String> CURRENT_TO_LEGACY_MAP = SystemUtils.make(Maps.newHashMap(), var0 -> {
        var0.put("Village", "Village");
        var0.put("Mineshaft", "Mineshaft");
        var0.put("Mansion", "Mansion");
        var0.put("Igloo", "Temple");
        var0.put("Desert_Pyramid", "Temple");
        var0.put("Jungle_Pyramid", "Temple");
        var0.put("Swamp_Hut", "Temple");
        var0.put("Stronghold", "Stronghold");
        var0.put("Monument", "Monument");
        var0.put("Fortress", "Fortress");
        var0.put("EndCity", "EndCity");
    });
    private static final Map<String, String> LEGACY_TO_CURRENT_MAP = SystemUtils.make(Maps.newHashMap(), var0 -> {
        var0.put("Iglu", "Igloo");
        var0.put("TeDP", "Desert_Pyramid");
        var0.put("TeJP", "Jungle_Pyramid");
        var0.put("TeSH", "Swamp_Hut");
    });
    private static final Set<String> OLD_STRUCTURE_REGISTRY_KEYS = Set.of("pillager_outpost", "mineshaft", "mansion", "jungle_pyramid", "desert_pyramid", "igloo", "ruined_portal", "shipwreck", "swamp_hut", "stronghold", "monument", "ocean_ruin", "fortress", "endcity", "buried_treasure", "village", "nether_fossil", "bastion_remnant");
    private final boolean hasLegacyData;
    private final Map<String, Long2ObjectMap<NBTTagCompound>> dataMap = Maps.newHashMap();
    private final Map<String, PersistentIndexed> indexMap = Maps.newHashMap();
    private final List<String> legacyKeys;
    private final List<String> currentKeys;

    public PersistentStructureLegacy(@Nullable WorldPersistentData var0, List<String> var1, List<String> var2) {
        this.legacyKeys = var1;
        this.currentKeys = var2;
        this.populateCaches(var0);
        boolean var3 = false;
        for (String var5 : this.currentKeys) {
            var3 |= this.dataMap.get(var5) != null;
        }
        this.hasLegacyData = var3;
    }

    public void removeIndex(long var0) {
        for (String var3 : this.legacyKeys) {
            PersistentIndexed var4 = this.indexMap.get(var3);
            if (var4 == null || !var4.hasUnhandledIndex(var0)) continue;
            var4.removeIndex(var0);
        }
    }

    public NBTTagCompound updateFromLegacy(NBTTagCompound var0) {
        NBTTagCompound var1 = var0.getCompoundOrEmpty("Level");
        ChunkCoordIntPair var2 = new ChunkCoordIntPair(var1.getIntOr("xPos", 0), var1.getIntOr("zPos", 0));
        if (this.isUnhandledStructureStart(var2.x, var2.z)) {
            var0 = this.updateStructureStart(var0, var2);
        }
        NBTTagCompound var3 = var1.getCompoundOrEmpty("Structures");
        NBTTagCompound var4 = var3.getCompoundOrEmpty("References");
        for (String var6 : this.currentKeys) {
            boolean var7 = OLD_STRUCTURE_REGISTRY_KEYS.contains(var6.toLowerCase(Locale.ROOT));
            if (var4.getLongArray(var6).isPresent() || !var7) continue;
            int var8 = 8;
            LongArrayList var9 = new LongArrayList();
            for (int var10 = var2.x - 8; var10 <= var2.x + 8; ++var10) {
                for (int var11 = var2.z - 8; var11 <= var2.z + 8; ++var11) {
                    if (!this.hasLegacyStart(var10, var11, var6)) continue;
                    var9.add(ChunkCoordIntPair.asLong(var10, var11));
                }
            }
            var4.putLongArray(var6, var9.toLongArray());
        }
        var3.put("References", var4);
        var1.put("Structures", var3);
        var0.put("Level", var1);
        return var0;
    }

    private boolean hasLegacyStart(int var0, int var1, String var2) {
        if (!this.hasLegacyData) {
            return false;
        }
        return this.dataMap.get(var2) != null && this.indexMap.get(CURRENT_TO_LEGACY_MAP.get(var2)).hasStartIndex(ChunkCoordIntPair.asLong(var0, var1));
    }

    private boolean isUnhandledStructureStart(int var0, int var1) {
        if (!this.hasLegacyData) {
            return false;
        }
        for (String var3 : this.currentKeys) {
            if (this.dataMap.get(var3) == null || !this.indexMap.get(CURRENT_TO_LEGACY_MAP.get(var3)).hasUnhandledIndex(ChunkCoordIntPair.asLong(var0, var1))) continue;
            return true;
        }
        return false;
    }

    private NBTTagCompound updateStructureStart(NBTTagCompound var0, ChunkCoordIntPair var1) {
        NBTTagCompound var2 = var0.getCompoundOrEmpty("Level");
        NBTTagCompound var3 = var2.getCompoundOrEmpty("Structures");
        NBTTagCompound var4 = var3.getCompoundOrEmpty("Starts");
        for (String var6 : this.currentKeys) {
            NBTTagCompound var10;
            Long2ObjectMap<NBTTagCompound> var7 = this.dataMap.get(var6);
            if (var7 == null) continue;
            long var8 = var1.toLong();
            if (!this.indexMap.get(CURRENT_TO_LEGACY_MAP.get(var6)).hasUnhandledIndex(var8) || (var10 = (NBTTagCompound)var7.get(var8)) == null) continue;
            var4.put(var6, var10);
        }
        var3.put("Starts", var4);
        var2.put("Structures", var3);
        var0.put("Level", var2);
        return var0;
    }

    private void populateCaches(@Nullable WorldPersistentData var0) {
        if (var0 == null) {
            return;
        }
        for (String var22 : this.legacyKeys) {
            NBTTagCompound var3 = new NBTTagCompound();
            try {
                var3 = var0.readTagFromDisk(var22, DataFixTypes.SAVED_DATA_STRUCTURE_FEATURE_INDICES, 1493).getCompoundOrEmpty("data").getCompoundOrEmpty("Features");
                if (var3.isEmpty()) {
                    continue;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            var3.forEach((var02, var12) -> {
                if (!(var12 instanceof NBTTagCompound)) {
                    return;
                }
                NBTTagCompound var2 = (NBTTagCompound)var12;
                long var32 = ChunkCoordIntPair.asLong(var2.getIntOr("ChunkX", 0), var2.getIntOr("ChunkZ", 0));
                NBTTagList var5 = var2.getListOrEmpty("Children");
                if (!var5.isEmpty()) {
                    Optional<String> var6 = var5.getCompound(0).flatMap(var0 -> var0.getString("id"));
                    var6.map(LEGACY_TO_CURRENT_MAP::get).ifPresent(var1 -> var2.putString("id", (String)var1));
                }
                var2.getString("id").ifPresent(var3 -> this.dataMap.computeIfAbsent((String)var3, var0 -> new Long2ObjectOpenHashMap()).put(var32, (Object)var2));
            });
            String var4 = var22 + "_index";
            PersistentIndexed var5 = var0.computeIfAbsent(PersistentIndexed.type(var4));
            if (var5.getAll().isEmpty()) {
                PersistentIndexed var6 = new PersistentIndexed();
                this.indexMap.put(var22, var6);
                var3.forEach((var1, var2) -> {
                    if (var2 instanceof NBTTagCompound) {
                        NBTTagCompound var3 = (NBTTagCompound)var2;
                        var6.addIndex(ChunkCoordIntPair.asLong(var3.getIntOr("ChunkX", 0), var3.getIntOr("ChunkZ", 0)));
                    }
                });
                continue;
            }
            this.indexMap.put(var22, var5);
        }
    }

    public static PersistentStructureLegacy getLegacyStructureHandler(ResourceKey<World> var0, @Nullable WorldPersistentData var1) {
        if (var0 == World.OVERWORLD) {
            return new PersistentStructureLegacy(var1, (List<String>)ImmutableList.of((Object)"Monument", (Object)"Stronghold", (Object)"Village", (Object)"Mineshaft", (Object)"Temple", (Object)"Mansion"), (List<String>)ImmutableList.of((Object)"Village", (Object)"Mineshaft", (Object)"Mansion", (Object)"Igloo", (Object)"Desert_Pyramid", (Object)"Jungle_Pyramid", (Object)"Swamp_Hut", (Object)"Stronghold", (Object)"Monument"));
        }
        if (var0 == World.NETHER) {
            ImmutableList var2 = ImmutableList.of((Object)"Fortress");
            return new PersistentStructureLegacy(var1, (List<String>)var2, (List<String>)var2);
        }
        if (var0 == World.END) {
            ImmutableList var2 = ImmutableList.of((Object)"EndCity");
            return new PersistentStructureLegacy(var1, (List<String>)var2, (List<String>)var2);
        }
        throw new RuntimeException(String.format(Locale.ROOT, "Unknown dimension type : %s", var0));
    }
}

