/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryBlockID;
import net.minecraft.data.worldgen.WorldGenFeaturePieces;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.decoration.EntityPainting;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.BlockAccessAir;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockJigsaw;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IFluidContainer;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessor;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeBitSet;
import net.minecraft.world.phys.shapes.VoxelShapeDiscrete;
import org.slf4j.Logger;

public class DefinedStructure {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String PALETTE_TAG = "palette";
    public static final String PALETTE_LIST_TAG = "palettes";
    public static final String ENTITIES_TAG = "entities";
    public static final String BLOCKS_TAG = "blocks";
    public static final String BLOCK_TAG_POS = "pos";
    public static final String BLOCK_TAG_STATE = "state";
    public static final String BLOCK_TAG_NBT = "nbt";
    public static final String ENTITY_TAG_POS = "pos";
    public static final String ENTITY_TAG_BLOCKPOS = "blockPos";
    public static final String ENTITY_TAG_NBT = "nbt";
    public static final String SIZE_TAG = "size";
    public final List<b> palettes = Lists.newArrayList();
    public final List<EntityInfo> entityInfoList = Lists.newArrayList();
    private BaseBlockPosition size = BaseBlockPosition.ZERO;
    private String author = "?";

    public BaseBlockPosition getSize() {
        return this.size;
    }

    public void setAuthor(String var0) {
        this.author = var0;
    }

    public String getAuthor() {
        return this.author;
    }

    public void fillFromWorld(World var0, BlockPosition var1, BaseBlockPosition var2, boolean var3, List<Block> var4) {
        if (var2.getX() < 1 || var2.getY() < 1 || var2.getZ() < 1) {
            return;
        }
        BlockPosition var5 = var1.offset(var2).offset(-1, -1, -1);
        ArrayList var6 = Lists.newArrayList();
        ArrayList var7 = Lists.newArrayList();
        ArrayList var8 = Lists.newArrayList();
        BlockPosition var9 = new BlockPosition(Math.min(var1.getX(), var5.getX()), Math.min(var1.getY(), var5.getY()), Math.min(var1.getZ(), var5.getZ()));
        BlockPosition var10 = new BlockPosition(Math.max(var1.getX(), var5.getX()), Math.max(var1.getY(), var5.getY()), Math.max(var1.getZ(), var5.getZ()));
        this.size = var2;
        try (ProblemReporter.j var11 = new ProblemReporter.j(LOGGER);){
            for (BlockPosition var13 : BlockPosition.betweenClosed(var9, var10)) {
                BlockInfo var17;
                BlockPosition var14 = var13.subtract(var9);
                IBlockData var15 = var0.getBlockState(var13);
                if (var4.stream().anyMatch(var15::is)) continue;
                TileEntity var16 = var0.getBlockEntity(var13);
                if (var16 != null) {
                    TagValueOutput var18 = TagValueOutput.createWithContext(var11, var0.registryAccess());
                    var16.saveWithId(var18);
                    var17 = new BlockInfo(var14, var15, var18.buildResult());
                } else {
                    var17 = new BlockInfo(var14, var15, null);
                }
                DefinedStructure.addToLists(var17, var6, var7, var8);
            }
            List<BlockInfo> var12 = DefinedStructure.buildInfoList(var6, var7, var8);
            this.palettes.clear();
            this.palettes.add(new b(var12));
            if (var3) {
                this.fillEntityList(var0, var9, var10, var11);
            } else {
                this.entityInfoList.clear();
            }
        }
    }

    private static void addToLists(BlockInfo var0, List<BlockInfo> var1, List<BlockInfo> var2, List<BlockInfo> var3) {
        if (var0.nbt != null) {
            var2.add(var0);
        } else if (!var0.state.getBlock().hasDynamicShape() && var0.state.isCollisionShapeFullBlock(BlockAccessAir.INSTANCE, BlockPosition.ZERO)) {
            var1.add(var0);
        } else {
            var3.add(var0);
        }
    }

    private static List<BlockInfo> buildInfoList(List<BlockInfo> var02, List<BlockInfo> var1, List<BlockInfo> var2) {
        Comparator<BlockInfo> var3 = Comparator.comparingInt(var0 -> var0.pos.getY()).thenComparingInt(var0 -> var0.pos.getX()).thenComparingInt(var0 -> var0.pos.getZ());
        var02.sort(var3);
        var2.sort(var3);
        var1.sort(var3);
        ArrayList var4 = Lists.newArrayList();
        var4.addAll(var02);
        var4.addAll(var2);
        var4.addAll(var1);
        return var4;
    }

    private void fillEntityList(World var02, BlockPosition var1, BlockPosition var2, ProblemReporter var3) {
        List<Entity> var4 = var02.getEntitiesOfClass(Entity.class, AxisAlignedBB.encapsulatingFullBlocks(var1, var2), var0 -> !(var0 instanceof EntityHuman));
        this.entityInfoList.clear();
        for (Entity var6 : var4) {
            BlockPosition var9;
            Vec3D var7 = new Vec3D(var6.getX() - (double)var1.getX(), var6.getY() - (double)var1.getY(), var6.getZ() - (double)var1.getZ());
            TagValueOutput var8 = TagValueOutput.createWithContext(var3.forChild(var6.problemPath()), var6.registryAccess());
            var6.save(var8);
            if (var6 instanceof EntityPainting) {
                EntityPainting var10 = (EntityPainting)var6;
                var9 = var10.getPos().subtract(var1);
            } else {
                var9 = BlockPosition.containing(var7);
            }
            this.entityInfoList.add(new EntityInfo(var7, var9, var8.buildResult().copy()));
        }
    }

    public List<BlockInfo> filterBlocks(BlockPosition var0, DefinedStructureInfo var1, Block var2) {
        return this.filterBlocks(var0, var1, var2, true);
    }

    public List<a> getJigsaws(BlockPosition var0, EnumBlockRotation var1) {
        if (this.palettes.isEmpty()) {
            return new ArrayList<a>();
        }
        DefinedStructureInfo var2 = new DefinedStructureInfo().setRotation(var1);
        List<a> var3 = var2.getRandomPalette(this.palettes, var0).jigsaws();
        ArrayList<a> var4 = new ArrayList<a>(var3.size());
        for (a var6 : var3) {
            BlockInfo var7 = var6.info;
            var4.add(var6.withInfo(new BlockInfo(DefinedStructure.calculateRelativePosition(var2, var7.pos()).offset(var0), var7.state.rotate(var2.getRotation()), var7.nbt)));
        }
        return var4;
    }

    public ObjectArrayList<BlockInfo> filterBlocks(BlockPosition var0, DefinedStructureInfo var1, Block var2, boolean var3) {
        ObjectArrayList var4 = new ObjectArrayList();
        StructureBoundingBox var5 = var1.getBoundingBox();
        if (this.palettes.isEmpty()) {
            return var4;
        }
        for (BlockInfo var7 : var1.getRandomPalette(this.palettes, var0).blocks(var2)) {
            BlockPosition var8;
            BlockPosition blockPosition = var8 = var3 ? DefinedStructure.calculateRelativePosition(var1, var7.pos).offset(var0) : var7.pos;
            if (var5 != null && !var5.isInside(var8)) continue;
            var4.add((Object)new BlockInfo(var8, var7.state.rotate(var1.getRotation()), var7.nbt));
        }
        return var4;
    }

    public BlockPosition calculateConnectedPosition(DefinedStructureInfo var0, BlockPosition var1, DefinedStructureInfo var2, BlockPosition var3) {
        BlockPosition var4 = DefinedStructure.calculateRelativePosition(var0, var1);
        BlockPosition var5 = DefinedStructure.calculateRelativePosition(var2, var3);
        return var4.subtract(var5);
    }

    public static BlockPosition calculateRelativePosition(DefinedStructureInfo var0, BlockPosition var1) {
        return DefinedStructure.transform(var1, var0.getMirror(), var0.getRotation(), var0.getRotationPivot());
    }

    public boolean placeInWorld(WorldAccess var0, BlockPosition var1, BlockPosition var2, DefinedStructureInfo var3, RandomSource var4, int var5) {
        if (this.palettes.isEmpty()) {
            return false;
        }
        List<BlockInfo> var6 = var3.getRandomPalette(this.palettes, var1).blocks();
        if (var6.isEmpty() && (var3.isIgnoreEntities() || this.entityInfoList.isEmpty()) || this.size.getX() < 1 || this.size.getY() < 1 || this.size.getZ() < 1) {
            return false;
        }
        StructureBoundingBox var7 = var3.getBoundingBox();
        ArrayList var8 = Lists.newArrayListWithCapacity((int)(var3.shouldApplyWaterlogging() ? var6.size() : 0));
        ArrayList var9 = Lists.newArrayListWithCapacity((int)(var3.shouldApplyWaterlogging() ? var6.size() : 0));
        ArrayList var10 = Lists.newArrayListWithCapacity((int)var6.size());
        int var11 = Integer.MAX_VALUE;
        int var12 = Integer.MAX_VALUE;
        int var13 = Integer.MAX_VALUE;
        int var14 = Integer.MIN_VALUE;
        int var15 = Integer.MIN_VALUE;
        int var16 = Integer.MIN_VALUE;
        List<BlockInfo> var17 = DefinedStructure.processBlockInfos(var0, var1, var2, var3, var6);
        try (ProblemReporter.j var18 = new ProblemReporter.j(LOGGER);){
            Fluid var26;
            Object var25;
            IBlockDataHolder var23;
            Object var22;
            Object var21;
            for (BlockInfo blockInfo : var17) {
                TileEntity var24;
                var21 = blockInfo.pos;
                if (var7 != null && !var7.isInside((BaseBlockPosition)var21)) continue;
                var22 = var3.shouldApplyWaterlogging() ? var0.getFluidState((BlockPosition)var21) : null;
                var23 = blockInfo.state.mirror(var3.getMirror()).rotate(var3.getRotation());
                if (blockInfo.nbt != null) {
                    var0.setBlock((BlockPosition)var21, Blocks.BARRIER.defaultBlockState(), 820);
                }
                if (!var0.setBlock((BlockPosition)var21, (IBlockData)var23, var5)) continue;
                var11 = Math.min(var11, ((BaseBlockPosition)var21).getX());
                var12 = Math.min(var12, ((BaseBlockPosition)var21).getY());
                var13 = Math.min(var13, ((BaseBlockPosition)var21).getZ());
                var14 = Math.max(var14, ((BaseBlockPosition)var21).getX());
                var15 = Math.max(var15, ((BaseBlockPosition)var21).getY());
                var16 = Math.max(var16, ((BaseBlockPosition)var21).getZ());
                var10.add(Pair.of((Object)var21, (Object)blockInfo.nbt));
                if (blockInfo.nbt != null && (var24 = var0.getBlockEntity((BlockPosition)var21)) != null) {
                    if (var24 instanceof RandomizableContainer) {
                        blockInfo.nbt.putLong("LootTableSeed", var4.nextLong());
                    }
                    var24.loadWithComponents(TagValueInput.create(var18.forChild(var24.problemPath()), (HolderLookup.a)var0.registryAccess(), blockInfo.nbt));
                }
                if (var22 == null) continue;
                if (((BlockBase.BlockData)var23).getFluidState().isSource()) {
                    var9.add(var21);
                    continue;
                }
                if (!(((BlockBase.BlockData)var23).getBlock() instanceof IFluidContainer)) continue;
                ((IFluidContainer)((Object)((BlockBase.BlockData)var23).getBlock())).placeLiquid(var0, (BlockPosition)var21, (IBlockData)var23, (Fluid)var22);
                if (((Fluid)var22).isSource()) continue;
                var8.add(var21);
            }
            boolean var19 = true;
            EnumDirection[] enumDirectionArray = new EnumDirection[]{EnumDirection.UP, EnumDirection.NORTH, EnumDirection.EAST, EnumDirection.SOUTH, EnumDirection.WEST};
            while (var19 && !var8.isEmpty()) {
                var19 = false;
                var21 = var8.iterator();
                while (var21.hasNext()) {
                    IBlockData var24;
                    var22 = (BlockPosition)var21.next();
                    var23 = var0.getFluidState((BlockPosition)var22);
                    for (int var242 = 0; var242 < enumDirectionArray.length && !((Fluid)var23).isSource(); ++var242) {
                        var25 = ((BlockPosition)var22).relative(enumDirectionArray[var242]);
                        var26 = var0.getFluidState((BlockPosition)var25);
                        if (!var26.isSource() || var9.contains(var25)) continue;
                        var23 = var26;
                    }
                    if (!((Fluid)var23).isSource() || !((var25 = (var24 = var0.getBlockState((BlockPosition)var22)).getBlock()) instanceof IFluidContainer)) continue;
                    ((IFluidContainer)var25).placeLiquid(var0, (BlockPosition)var22, var24, (Fluid)var23);
                    var19 = true;
                    var21.remove();
                }
            }
            if (var11 <= var14) {
                if (!var3.getKnownShape()) {
                    var21 = new VoxelShapeBitSet(var14 - var11 + 1, var15 - var12 + 1, var16 - var13 + 1);
                    int var222 = var11;
                    int var232 = var12;
                    int var24 = var13;
                    var25 = var10.iterator();
                    while (var25.hasNext()) {
                        var26 = (Pair)var25.next();
                        BlockPosition var27 = (BlockPosition)var26.getFirst();
                        ((VoxelShapeDiscrete)var21).fill(var27.getX() - var222, var27.getY() - var232, var27.getZ() - var24);
                    }
                    DefinedStructure.updateShapeAtEdge(var0, var5, (VoxelShapeDiscrete)var21, var222, var232, var24);
                }
                for (Pair var223 : var10) {
                    TileEntity var24;
                    BlockPosition var233 = (BlockPosition)var223.getFirst();
                    if (!var3.getKnownShape()) {
                        IBlockData var243 = var0.getBlockState(var233);
                        if (var243 != (var25 = Block.updateFromNeighbourShapes(var243, var0, var233))) {
                            var0.setBlock(var233, (IBlockData)var25, var5 & 0xFFFFFFFE | 0x10);
                        }
                        var0.updateNeighborsAt(var233, ((BlockBase.BlockData)var25).getBlock());
                    }
                    if (var223.getSecond() == null || (var24 = var0.getBlockEntity(var233)) == null) continue;
                    var24.setChanged();
                }
            }
            if (!var3.isIgnoreEntities()) {
                this.placeEntities(var0, var1, var3.getMirror(), var3.getRotation(), var3.getRotationPivot(), var7, var3.shouldFinalizeEntities(), var18);
            }
        }
        return true;
    }

    public static void updateShapeAtEdge(GeneratorAccess var0, int var1, VoxelShapeDiscrete var2, BlockPosition var3) {
        DefinedStructure.updateShapeAtEdge(var0, var1, var2, var3.getX(), var3.getY(), var3.getZ());
    }

    public static void updateShapeAtEdge(GeneratorAccess var0, int var1, VoxelShapeDiscrete var2, int var3, int var4, int var5) {
        BlockPosition.MutableBlockPosition var6 = new BlockPosition.MutableBlockPosition();
        BlockPosition.MutableBlockPosition var72 = new BlockPosition.MutableBlockPosition();
        var2.forAllFaces((var7, var8, var9, var10) -> {
            IBlockData var14;
            var6.set(var3 + var8, var4 + var9, var5 + var10);
            var72.setWithOffset((BaseBlockPosition)var6, var7);
            IBlockData var11 = var0.getBlockState(var6);
            IBlockData var12 = var0.getBlockState(var72);
            IBlockData var13 = var11.updateShape(var0, var0, var6, var7, var72, var12, var0.getRandom());
            if (var11 != var13) {
                var0.setBlock(var6, var13, var1 & 0xFFFFFFFE);
            }
            if (var12 != (var14 = var12.updateShape(var0, var0, var72, var7.getOpposite(), var6, var13, var0.getRandom()))) {
                var0.setBlock(var72, var14, var1 & 0xFFFFFFFE);
            }
        });
    }

    public static List<BlockInfo> processBlockInfos(WorldAccess var0, BlockPosition var1, BlockPosition var2, DefinedStructureInfo var3, List<BlockInfo> var4) {
        ArrayList<BlockInfo> var5 = new ArrayList<BlockInfo>();
        List<BlockInfo> var6 = new ArrayList<BlockInfo>();
        for (BlockInfo blockInfo : var4) {
            BlockPosition var9 = DefinedStructure.calculateRelativePosition(var3, blockInfo.pos).offset(var1);
            BlockInfo var10 = new BlockInfo(var9, blockInfo.state, blockInfo.nbt != null ? blockInfo.nbt.copy() : null);
            Iterator<DefinedStructureProcessor> var11 = var3.getProcessors().iterator();
            while (var10 != null && var11.hasNext()) {
                var10 = var11.next().processBlock(var0, var1, var2, blockInfo, var10, var3);
            }
            if (var10 == null) continue;
            var6.add(var10);
            var5.add(blockInfo);
        }
        for (DefinedStructureProcessor definedStructureProcessor : var3.getProcessors()) {
            var6 = definedStructureProcessor.finalizeProcessing(var0, var1, var2, var5, var6, var3);
        }
        return var6;
    }

    private void placeEntities(WorldAccess var0, BlockPosition var1, EnumBlockMirror var2, EnumBlockRotation var3, BlockPosition var4, @Nullable StructureBoundingBox var52, boolean var6, ProblemReporter var7) {
        for (EntityInfo var9 : this.entityInfoList) {
            BlockPosition var10 = DefinedStructure.transform(var9.blockPos, var2, var3, var4).offset(var1);
            if (var52 != null && !var52.isInside(var10)) continue;
            NBTTagCompound var11 = var9.nbt.copy();
            Vec3D var12 = DefinedStructure.transform(var9.pos, var2, var3, var4);
            Vec3D var13 = var12.add(var1.getX(), var1.getY(), var1.getZ());
            NBTTagList var14 = new NBTTagList();
            var14.add(NBTTagDouble.valueOf(var13.x));
            var14.add(NBTTagDouble.valueOf(var13.y));
            var14.add(NBTTagDouble.valueOf(var13.z));
            var11.put("Pos", var14);
            var11.remove("UUID");
            DefinedStructure.createEntityIgnoreException(var7, var0, var11).ifPresent(var5 -> {
                float var6 = var5.rotate(var3);
                var5.snapTo(var2.x, var2.y, var2.z, var6 += var5.mirror(var2) - var5.getYRot(), var5.getXRot());
                if (var6 && var5 instanceof EntityInsentient) {
                    ((EntityInsentient)var5).finalizeSpawn(var0, var0.getCurrentDifficultyAt(BlockPosition.containing(var13)), EntitySpawnReason.STRUCTURE, null);
                }
                var0.addFreshEntityWithPassengers((Entity)var5);
            });
        }
    }

    private static Optional<Entity> createEntityIgnoreException(ProblemReporter var0, WorldAccess var1, NBTTagCompound var2) {
        try {
            return EntityTypes.create(TagValueInput.create(var0, (HolderLookup.a)var1.registryAccess(), var2), var1.getLevel(), EntitySpawnReason.STRUCTURE);
        }
        catch (Exception var3) {
            return Optional.empty();
        }
    }

    public BaseBlockPosition getSize(EnumBlockRotation var0) {
        switch (var0) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                return new BaseBlockPosition(this.size.getZ(), this.size.getY(), this.size.getX());
            }
        }
        return this.size;
    }

    public static BlockPosition transform(BlockPosition var0, EnumBlockMirror var1, EnumBlockRotation var2, BlockPosition var3) {
        int var4 = var0.getX();
        int var5 = var0.getY();
        int var6 = var0.getZ();
        boolean var7 = true;
        switch (var1) {
            case LEFT_RIGHT: {
                var6 = -var6;
                break;
            }
            case FRONT_BACK: {
                var4 = -var4;
                break;
            }
            default: {
                var7 = false;
            }
        }
        int var8 = var3.getX();
        int var9 = var3.getZ();
        switch (var2) {
            case CLOCKWISE_180: {
                return new BlockPosition(var8 + var8 - var4, var5, var9 + var9 - var6);
            }
            case COUNTERCLOCKWISE_90: {
                return new BlockPosition(var8 - var9 + var6, var5, var8 + var9 - var4);
            }
            case CLOCKWISE_90: {
                return new BlockPosition(var8 + var9 - var6, var5, var9 - var8 + var4);
            }
        }
        return var7 ? new BlockPosition(var4, var5, var6) : var0;
    }

    public static Vec3D transform(Vec3D var0, EnumBlockMirror var1, EnumBlockRotation var2, BlockPosition var3) {
        double var4 = var0.x;
        double var6 = var0.y;
        double var8 = var0.z;
        boolean var10 = true;
        switch (var1) {
            case LEFT_RIGHT: {
                var8 = 1.0 - var8;
                break;
            }
            case FRONT_BACK: {
                var4 = 1.0 - var4;
                break;
            }
            default: {
                var10 = false;
            }
        }
        int var11 = var3.getX();
        int var12 = var3.getZ();
        switch (var2) {
            case CLOCKWISE_180: {
                return new Vec3D((double)(var11 + var11 + 1) - var4, var6, (double)(var12 + var12 + 1) - var8);
            }
            case COUNTERCLOCKWISE_90: {
                return new Vec3D((double)(var11 - var12) + var8, var6, (double)(var11 + var12 + 1) - var4);
            }
            case CLOCKWISE_90: {
                return new Vec3D((double)(var11 + var12 + 1) - var8, var6, (double)(var12 - var11) + var4);
            }
        }
        return var10 ? new Vec3D(var4, var6, var8) : var0;
    }

    public BlockPosition getZeroPositionWithTransform(BlockPosition var0, EnumBlockMirror var1, EnumBlockRotation var2) {
        return DefinedStructure.getZeroPositionWithTransform(var0, var1, var2, this.getSize().getX(), this.getSize().getZ());
    }

    public static BlockPosition getZeroPositionWithTransform(BlockPosition var0, EnumBlockMirror var1, EnumBlockRotation var2, int var3, int var4) {
        int var5 = var1 == EnumBlockMirror.FRONT_BACK ? --var3 : 0;
        int var6 = var1 == EnumBlockMirror.LEFT_RIGHT ? --var4 : 0;
        BlockPosition var7 = var0;
        switch (var2) {
            case NONE: {
                var7 = var0.offset(var5, 0, var6);
                break;
            }
            case CLOCKWISE_90: {
                var7 = var0.offset(var4 - var6, 0, var5);
                break;
            }
            case CLOCKWISE_180: {
                var7 = var0.offset(var3 - var5, 0, var4 - var6);
                break;
            }
            case COUNTERCLOCKWISE_90: {
                var7 = var0.offset(var6, 0, var3 - var5);
            }
        }
        return var7;
    }

    public StructureBoundingBox getBoundingBox(DefinedStructureInfo var0, BlockPosition var1) {
        return this.getBoundingBox(var1, var0.getRotation(), var0.getRotationPivot(), var0.getMirror());
    }

    public StructureBoundingBox getBoundingBox(BlockPosition var0, EnumBlockRotation var1, BlockPosition var2, EnumBlockMirror var3) {
        return DefinedStructure.getBoundingBox(var0, var1, var2, var3, this.size);
    }

    @VisibleForTesting
    protected static StructureBoundingBox getBoundingBox(BlockPosition var0, EnumBlockRotation var1, BlockPosition var2, EnumBlockMirror var3, BaseBlockPosition var4) {
        BaseBlockPosition var5 = var4.offset(-1, -1, -1);
        BlockPosition var6 = DefinedStructure.transform(BlockPosition.ZERO, var3, var1, var2);
        BlockPosition var7 = DefinedStructure.transform(BlockPosition.ZERO.offset(var5), var3, var1, var2);
        return StructureBoundingBox.fromCorners(var6, var7).move(var0);
    }

    /*
     * WARNING - void declaration
     */
    public NBTTagCompound save(NBTTagCompound var0) {
        Object var4;
        AbstractList var1;
        if (this.palettes.isEmpty()) {
            var0.put(BLOCKS_TAG, new NBTTagList());
            var0.put(PALETTE_TAG, new NBTTagList());
        } else {
            Object var10;
            void var4_5;
            var1 = Lists.newArrayList();
            c var2 = new c();
            var1.add(var2);
            boolean bl = true;
            while (var4_5 < this.palettes.size()) {
                var1.add(new c());
                ++var4_5;
            }
            NBTTagList nBTTagList = new NBTTagList();
            var4 = this.palettes.get(0).blocks();
            for (int var5 = 0; var5 < var4.size(); ++var5) {
                BlockInfo var6 = (BlockInfo)var4.get(var5);
                Object var7 = new NBTTagCompound();
                ((NBTTagCompound)var7).put("pos", this.newIntegerList(var6.pos.getX(), var6.pos.getY(), var6.pos.getZ()));
                int var8 = var2.idFor(var6.state);
                ((NBTTagCompound)var7).putInt(BLOCK_TAG_STATE, var8);
                if (var6.nbt != null) {
                    ((NBTTagCompound)var7).put("nbt", var6.nbt);
                }
                nBTTagList.add(var7);
                for (int var9 = 1; var9 < this.palettes.size(); ++var9) {
                    var10 = (c)var1.get(var9);
                    ((c)var10).addMapping(this.palettes.get((int)var9).blocks().get((int)var5).state, var8);
                }
            }
            var0.put(BLOCKS_TAG, nBTTagList);
            if (var1.size() == 1) {
                var5 = new NBTTagList();
                for (Object var7 : var2) {
                    var5.add(GameProfileSerializer.writeBlockState((IBlockData)var7));
                }
                var0.put(PALETTE_TAG, var5);
            } else {
                var5 = new NBTTagList();
                for (Object var7 : var1) {
                    NBTTagList var8 = new NBTTagList();
                    Iterator<IBlockData> iterator = ((c)var7).iterator();
                    while (iterator.hasNext()) {
                        var10 = iterator.next();
                        var8.add(GameProfileSerializer.writeBlockState((IBlockData)var10));
                    }
                    var5.add(var8);
                }
                var0.put(PALETTE_LIST_TAG, var5);
            }
        }
        var1 = new NBTTagList();
        for (EntityInfo entityInfo : this.entityInfoList) {
            var4 = new NBTTagCompound();
            ((NBTTagCompound)var4).put("pos", this.newDoubleList(entityInfo.pos.x, entityInfo.pos.y, entityInfo.pos.z));
            ((NBTTagCompound)var4).put(ENTITY_TAG_BLOCKPOS, this.newIntegerList(entityInfo.blockPos.getX(), entityInfo.blockPos.getY(), entityInfo.blockPos.getZ()));
            if (entityInfo.nbt != null) {
                ((NBTTagCompound)var4).put("nbt", entityInfo.nbt);
            }
            var1.add(var4);
        }
        var0.put(ENTITIES_TAG, (NBTBase)((Object)var1));
        var0.put(SIZE_TAG, this.newIntegerList(this.size.getX(), this.size.getY(), this.size.getZ()));
        return GameProfileSerializer.addCurrentDataVersion(var0);
    }

    public void load(HolderGetter<Block> var02, NBTTagCompound var1) {
        this.palettes.clear();
        this.entityInfoList.clear();
        NBTTagList var2 = var1.getListOrEmpty(SIZE_TAG);
        this.size = new BaseBlockPosition(var2.getIntOr(0, 0), var2.getIntOr(1, 0), var2.getIntOr(2, 0));
        NBTTagList var3 = var1.getListOrEmpty(BLOCKS_TAG);
        Optional<NBTTagList> var4 = var1.getList(PALETTE_LIST_TAG);
        if (var4.isPresent()) {
            for (int var5 = 0; var5 < var4.get().size(); ++var5) {
                this.loadPalette(var02, var4.get().getListOrEmpty(var5), var3);
            }
        } else {
            this.loadPalette(var02, var1.getListOrEmpty(PALETTE_TAG), var3);
        }
        var1.getListOrEmpty(ENTITIES_TAG).compoundStream().forEach(var0 -> {
            NBTTagList var1 = var0.getListOrEmpty("pos");
            Vec3D var22 = new Vec3D(var1.getDoubleOr(0, 0.0), var1.getDoubleOr(1, 0.0), var1.getDoubleOr(2, 0.0));
            NBTTagList var3 = var0.getListOrEmpty(ENTITY_TAG_BLOCKPOS);
            BlockPosition var4 = new BlockPosition(var3.getIntOr(0, 0), var3.getIntOr(1, 0), var3.getIntOr(2, 0));
            var0.getCompound("nbt").ifPresent(var2 -> this.entityInfoList.add(new EntityInfo(var22, var4, (NBTTagCompound)var2)));
        });
    }

    private void loadPalette(HolderGetter<Block> var0, NBTTagList var1, NBTTagList var2) {
        c var3 = new c();
        for (int var42 = 0; var42 < var1.size(); ++var42) {
            var3.addMapping(GameProfileSerializer.readBlockState(var0, var1.getCompoundOrEmpty(var42)), var42);
        }
        ArrayList var43 = Lists.newArrayList();
        ArrayList var5 = Lists.newArrayList();
        ArrayList var6 = Lists.newArrayList();
        var2.compoundStream().forEach(var4 -> {
            NBTTagList var5 = var4.getListOrEmpty("pos");
            BlockPosition var6 = new BlockPosition(var5.getIntOr(0, 0), var5.getIntOr(1, 0), var5.getIntOr(2, 0));
            IBlockData var7 = var3.stateFor(var4.getIntOr(BLOCK_TAG_STATE, 0));
            NBTTagCompound var8 = var4.getCompound("nbt").orElse(null);
            BlockInfo var9 = new BlockInfo(var6, var7, var8);
            DefinedStructure.addToLists(var9, var43, var5, var6);
        });
        List<BlockInfo> var7 = DefinedStructure.buildInfoList(var43, var5, var6);
        this.palettes.add(new b(var7));
    }

    private NBTTagList newIntegerList(int ... var0) {
        NBTTagList var1 = new NBTTagList();
        for (int var5 : var0) {
            var1.add(NBTTagInt.valueOf(var5));
        }
        return var1;
    }

    private NBTTagList newDoubleList(double ... var0) {
        NBTTagList var1 = new NBTTagList();
        for (double var5 : var0) {
            var1.add(NBTTagDouble.valueOf(var5));
        }
        return var1;
    }

    public static TileEntityJigsaw.JointType getJointType(NBTTagCompound var0, IBlockData var1) {
        return var0.read("joint", TileEntityJigsaw.JointType.CODEC).orElseGet(() -> DefinedStructure.getDefaultJointType(var1));
    }

    public static TileEntityJigsaw.JointType getDefaultJointType(IBlockData var0) {
        return BlockJigsaw.getFrontFacing(var0).getAxis().isHorizontal() ? TileEntityJigsaw.JointType.ALIGNED : TileEntityJigsaw.JointType.ROLLABLE;
    }

    public static final class BlockInfo
    extends Record {
        final BlockPosition pos;
        final IBlockData state;
        @Nullable
        final NBTTagCompound nbt;

        public BlockInfo(BlockPosition var0, IBlockData var1, @Nullable NBTTagCompound var2) {
            this.pos = var0;
            this.state = var1;
            this.nbt = var2;
        }

        @Override
        public String toString() {
            return String.format(Locale.ROOT, "<StructureBlockInfo | %s | %s | %s>", this.pos, this.state, this.nbt);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BlockInfo.class, "pos;state;nbt", "pos", "state", "nbt"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BlockInfo.class, "pos;state;nbt", "pos", "state", "nbt"}, this, var0);
        }

        public BlockPosition pos() {
            return this.pos;
        }

        public IBlockData state() {
            return this.state;
        }

        @Nullable
        public NBTTagCompound nbt() {
            return this.nbt;
        }
    }

    public static final class b {
        private final List<BlockInfo> blocks;
        private final Map<Block, List<BlockInfo>> cache = Maps.newHashMap();
        @Nullable
        private List<a> cachedJigsaws;

        b(List<BlockInfo> var0) {
            this.blocks = var0;
        }

        public List<a> jigsaws() {
            if (this.cachedJigsaws == null) {
                this.cachedJigsaws = this.blocks(Blocks.JIGSAW).stream().map(a::of).toList();
            }
            return this.cachedJigsaws;
        }

        public List<BlockInfo> blocks() {
            return this.blocks;
        }

        public List<BlockInfo> blocks(Block var02) {
            return this.cache.computeIfAbsent(var02, var0 -> this.blocks.stream().filter(var1 -> var1.state.is((Block)var0)).collect(Collectors.toList()));
        }
    }

    public static class EntityInfo {
        public final Vec3D pos;
        public final BlockPosition blockPos;
        public final NBTTagCompound nbt;

        public EntityInfo(Vec3D var0, BlockPosition var1, NBTTagCompound var2) {
            this.pos = var0;
            this.blockPos = var1;
            this.nbt = var2;
        }
    }

    public static final class a
    extends Record {
        final BlockInfo info;
        private final TileEntityJigsaw.JointType jointType;
        private final MinecraftKey name;
        private final ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> pool;
        private final MinecraftKey target;
        private final int placementPriority;
        private final int selectionPriority;

        public a(BlockInfo var0, TileEntityJigsaw.JointType var1, MinecraftKey var2, ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> var3, MinecraftKey var4, int var5, int var6) {
            this.info = var0;
            this.jointType = var1;
            this.name = var2;
            this.pool = var3;
            this.target = var4;
            this.placementPriority = var5;
            this.selectionPriority = var6;
        }

        public static a of(BlockInfo var0) {
            NBTTagCompound var1 = Objects.requireNonNull(var0.nbt(), () -> String.valueOf(var0) + " nbt was null");
            return new a(var0, DefinedStructure.getJointType(var1, var0.state()), var1.read("name", MinecraftKey.CODEC).orElse(TileEntityJigsaw.EMPTY_ID), var1.read("pool", TileEntityJigsaw.POOL_CODEC).orElse(WorldGenFeaturePieces.EMPTY), var1.read("target", MinecraftKey.CODEC).orElse(TileEntityJigsaw.EMPTY_ID), var1.getIntOr("placement_priority", 0), var1.getIntOr("selection_priority", 0));
        }

        @Override
        public String toString() {
            return String.format(Locale.ROOT, "<JigsawBlockInfo | %s | %s | name: %s | pool: %s | target: %s | placement: %d | selection: %d | %s>", this.info.pos, this.info.state, this.name, this.pool.location(), this.target, this.placementPriority, this.selectionPriority, this.info.nbt);
        }

        public a withInfo(BlockInfo var0) {
            return new a(var0, this.jointType, this.name, this.pool, this.target, this.placementPriority, this.selectionPriority);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "info;jointType;name;pool;target;placementPriority;selectionPriority", "info", "jointType", "name", "pool", "target", "placementPriority", "selectionPriority"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "info;jointType;name;pool;target;placementPriority;selectionPriority", "info", "jointType", "name", "pool", "target", "placementPriority", "selectionPriority"}, this, var0);
        }

        public BlockInfo info() {
            return this.info;
        }

        public TileEntityJigsaw.JointType jointType() {
            return this.jointType;
        }

        public MinecraftKey name() {
            return this.name;
        }

        public ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> pool() {
            return this.pool;
        }

        public MinecraftKey target() {
            return this.target;
        }

        public int placementPriority() {
            return this.placementPriority;
        }

        public int selectionPriority() {
            return this.selectionPriority;
        }
    }

    static class c
    implements Iterable<IBlockData> {
        public static final IBlockData DEFAULT_BLOCK_STATE = Blocks.AIR.defaultBlockState();
        private final RegistryBlockID<IBlockData> ids = new RegistryBlockID(16);
        private int lastId;

        c() {
        }

        public int idFor(IBlockData var0) {
            int var1 = this.ids.getId(var0);
            if (var1 == -1) {
                var1 = this.lastId++;
                this.ids.addMapping(var0, var1);
            }
            return var1;
        }

        @Nullable
        public IBlockData stateFor(int var0) {
            IBlockData var1 = this.ids.byId(var0);
            return var1 == null ? DEFAULT_BLOCK_STATE : var1;
        }

        @Override
        public Iterator<IBlockData> iterator() {
            return this.ids.iterator();
        }

        public void addMapping(IBlockData var0, int var1) {
            this.ids.addMapping(var0, var1);
        }
    }
}

