/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import com.google.common.annotations.VisibleForTesting;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.SectionPosition;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.lighting.LightEngineStorageBlock;

public final class LightEngineBlock
extends LightEngine<LightEngineStorageBlock.a, LightEngineStorageBlock> {
    private final BlockPosition.MutableBlockPosition mutablePos = new BlockPosition.MutableBlockPosition();

    public LightEngineBlock(ILightAccess var0) {
        this(var0, new LightEngineStorageBlock(var0));
    }

    @VisibleForTesting
    public LightEngineBlock(ILightAccess var0, LightEngineStorageBlock var1) {
        super(var0, var1);
    }

    @Override
    protected void checkNode(long var0) {
        int var6;
        long var2 = SectionPosition.blockToSection(var0);
        if (!((LightEngineStorageBlock)this.storage).storingLightForSection(var2)) {
            return;
        }
        IBlockData var4 = this.getState(this.mutablePos.set(var0));
        int var5 = this.getEmission(var0, var4);
        if (var5 < (var6 = ((LightEngineStorageBlock)this.storage).getStoredLevel(var0))) {
            ((LightEngineStorageBlock)this.storage).setStoredLevel(var0, 0);
            this.enqueueDecrease(var0, LightEngine.a.decreaseAllDirections(var6));
        } else {
            this.enqueueDecrease(var0, PULL_LIGHT_IN_ENTRY);
        }
        if (var5 > 0) {
            this.enqueueIncrease(var0, LightEngine.a.increaseLightFromEmission(var5, LightEngineBlock.isEmptyShape(var4)));
        }
    }

    @Override
    protected void propagateIncrease(long var0, long var2, int var4) {
        IBlockData var5 = null;
        for (EnumDirection var9 : PROPAGATION_DIRECTIONS) {
            int var12;
            int var13;
            long var10;
            if (!LightEngine.a.shouldPropagateInDirection(var2, var9) || !((LightEngineStorageBlock)this.storage).storingLightForSection(SectionPosition.blockToSection(var10 = BlockPosition.offset(var0, var9))) || (var13 = var4 - 1) <= (var12 = ((LightEngineStorageBlock)this.storage).getStoredLevel(var10))) continue;
            this.mutablePos.set(var10);
            IBlockData var14 = this.getState(this.mutablePos);
            int var15 = var4 - this.getOpacity(var14);
            if (var15 <= var12) continue;
            if (var5 == null) {
                IBlockData iBlockData = var5 = LightEngine.a.isFromEmptyShape(var2) ? Blocks.AIR.defaultBlockState() : this.getState(this.mutablePos.set(var0));
            }
            if (this.shapeOccludes(var5, var14, var9)) continue;
            ((LightEngineStorageBlock)this.storage).setStoredLevel(var10, var15);
            if (var15 <= 1) continue;
            this.enqueueIncrease(var10, LightEngine.a.increaseSkipOneDirection(var15, LightEngineBlock.isEmptyShape(var14), var9.getOpposite()));
        }
    }

    @Override
    protected void propagateDecrease(long var0, long var2) {
        int var4 = LightEngine.a.getFromLevel(var2);
        for (EnumDirection var8 : PROPAGATION_DIRECTIONS) {
            int var11;
            long var9;
            if (!LightEngine.a.shouldPropagateInDirection(var2, var8) || !((LightEngineStorageBlock)this.storage).storingLightForSection(SectionPosition.blockToSection(var9 = BlockPosition.offset(var0, var8))) || (var11 = ((LightEngineStorageBlock)this.storage).getStoredLevel(var9)) == 0) continue;
            if (var11 <= var4 - 1) {
                IBlockData var12 = this.getState(this.mutablePos.set(var9));
                int var13 = this.getEmission(var9, var12);
                ((LightEngineStorageBlock)this.storage).setStoredLevel(var9, 0);
                if (var13 < var11) {
                    this.enqueueDecrease(var9, LightEngine.a.decreaseSkipOneDirection(var11, var8.getOpposite()));
                }
                if (var13 <= 0) continue;
                this.enqueueIncrease(var9, LightEngine.a.increaseLightFromEmission(var13, LightEngineBlock.isEmptyShape(var12)));
                continue;
            }
            this.enqueueIncrease(var9, LightEngine.a.increaseOnlyOneDirection(var11, false, var8.getOpposite()));
        }
    }

    private int getEmission(long var0, IBlockData var2) {
        int var3 = var2.getLightEmission();
        if (var3 > 0 && ((LightEngineStorageBlock)this.storage).lightOnInSection(SectionPosition.blockToSection(var0))) {
            return var3;
        }
        return 0;
    }

    @Override
    public void propagateLightSources(ChunkCoordIntPair var02) {
        this.setLightEnabled(var02, true);
        LightChunk var12 = this.chunkSource.getChunkForLighting(var02.x, var02.z);
        if (var12 != null) {
            var12.findBlockLightSources((var0, var1) -> {
                int var2 = var1.getLightEmission();
                this.enqueueIncrease(var0.asLong(), LightEngine.a.increaseLightFromEmission(var2, LightEngineBlock.isEmptyShape(var1)));
            });
        }
    }
}

