/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.material;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.block.BlockIce;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IFluidContainer;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;

public abstract class FluidTypeFlowing
extends FluidType {
    public static final BlockStateBoolean FALLING = BlockProperties.FALLING;
    public static final BlockStateInteger LEVEL = BlockProperties.LEVEL_FLOWING;
    private static final int CACHE_SIZE = 200;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<a>> OCCLUSION_CACHE = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<a> var0 = new Object2ByteLinkedOpenHashMap<a>(200){

            protected void rehash(int var0) {
            }
        };
        var0.defaultReturnValue((byte)127);
        return var0;
    });
    private final Map<Fluid, VoxelShape> shapes = Maps.newIdentityHashMap();

    @Override
    protected void createFluidStateDefinition(BlockStateList.a<FluidType, Fluid> var0) {
        var0.add(FALLING);
    }

    @Override
    public Vec3D getFlow(IBlockAccess var0, BlockPosition var1, Fluid var2) {
        double var3 = 0.0;
        double var5 = 0.0;
        BlockPosition.MutableBlockPosition var7 = new BlockPosition.MutableBlockPosition();
        for (EnumDirection var9 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            var7.setWithOffset((BaseBlockPosition)var1, var9);
            Object var10 = var0.getFluidState(var7);
            if (!this.affectsFlow((Fluid)var10)) continue;
            float var11 = ((Fluid)var10).getOwnHeight();
            float var12 = 0.0f;
            if (var11 == 0.0f) {
                BaseBlockPosition var13;
                Fluid var14;
                if (!var0.getBlockState(var7).blocksMotion() && this.affectsFlow(var14 = var0.getFluidState((BlockPosition)(var13 = var7.below()))) && (var11 = var14.getOwnHeight()) > 0.0f) {
                    var12 = var2.getOwnHeight() - (var11 - 0.8888889f);
                }
            } else if (var11 > 0.0f) {
                var12 = var2.getOwnHeight() - var11;
            }
            if (var12 == 0.0f) continue;
            var3 += (double)((float)var9.getStepX() * var12);
            var5 += (double)((float)var9.getStepZ() * var12);
        }
        Vec3D var8 = new Vec3D(var3, 0.0, var5);
        if (var2.getValue(FALLING).booleanValue()) {
            for (Object var10 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
                var7.setWithOffset((BaseBlockPosition)var1, (EnumDirection)var10);
                if (!this.isSolidFace(var0, var7, (EnumDirection)var10) && !this.isSolidFace(var0, (BlockPosition)var7.above(), (EnumDirection)var10)) continue;
                var8 = var8.normalize().add(0.0, -6.0, 0.0);
                break;
            }
        }
        return var8.normalize();
    }

    private boolean affectsFlow(Fluid var0) {
        return var0.isEmpty() || var0.getType().isSame(this);
    }

    protected boolean isSolidFace(IBlockAccess var0, BlockPosition var1, EnumDirection var2) {
        IBlockData var3 = var0.getBlockState(var1);
        Fluid var4 = var0.getFluidState(var1);
        if (var4.getType().isSame(this)) {
            return false;
        }
        if (var2 == EnumDirection.UP) {
            return true;
        }
        if (var3.getBlock() instanceof BlockIce) {
            return false;
        }
        return var3.isFaceSturdy(var0, var1, var2);
    }

    protected void spread(WorldServer var0, BlockPosition var1, IBlockData var2, Fluid var3) {
        Fluid var7;
        FluidType var8;
        Fluid var6;
        IBlockData var5;
        if (var3.isEmpty()) {
            return;
        }
        BlockPosition var4 = var1.below();
        if (this.canMaybePassThrough(var0, var1, var2, EnumDirection.DOWN, var4, var5 = var0.getBlockState(var4), var6 = var5.getFluidState()) && var6.canBeReplacedWith(var0, var4, var8 = (var7 = this.getNewLiquid(var0, var4, var5)).getType(), EnumDirection.DOWN) && FluidTypeFlowing.canHoldSpecificFluid(var0, var4, var5, var8)) {
            this.spreadTo(var0, var4, var5, EnumDirection.DOWN, var7);
            if (this.sourceNeighborCount(var0, var1) >= 3) {
                this.spreadToSides(var0, var1, var3, var2);
            }
            return;
        }
        if (var3.isSource() || !this.isWaterHole(var0, var1, var2, var4, var5)) {
            this.spreadToSides(var0, var1, var3, var2);
        }
    }

    private void spreadToSides(WorldServer var0, BlockPosition var1, Fluid var2, IBlockData var3) {
        int var4 = var2.getAmount() - this.getDropOff(var0);
        if (var2.getValue(FALLING).booleanValue()) {
            var4 = 7;
        }
        if (var4 <= 0) {
            return;
        }
        Map<EnumDirection, Fluid> var5 = this.getSpread(var0, var1, var3);
        for (Map.Entry<EnumDirection, Fluid> var7 : var5.entrySet()) {
            EnumDirection var8 = var7.getKey();
            Fluid var9 = var7.getValue();
            BlockPosition var10 = var1.relative(var8);
            this.spreadTo(var0, var10, var0.getBlockState(var10), var8, var9);
        }
    }

    protected Fluid getNewLiquid(WorldServer var0, BlockPosition var1, IBlockData var2) {
        Object var6;
        Object var8;
        Object var72;
        int var3 = 0;
        int var4 = 0;
        BlockPosition.MutableBlockPosition var5 = new BlockPosition.MutableBlockPosition();
        for (Object var72 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            var8 = var5.setWithOffset((BaseBlockPosition)var1, (EnumDirection)var72);
            IBlockData var9 = var0.getBlockState((BlockPosition)var8);
            Fluid var10 = var9.getFluidState();
            if (!var10.getType().isSame(this) || !FluidTypeFlowing.canPassThroughWall((EnumDirection)var72, var0, var1, var2, (BlockPosition)var8, var9)) continue;
            if (var10.isSource()) {
                ++var4;
            }
            var3 = Math.max(var3, var10.getAmount());
        }
        if (var4 >= 2 && this.canConvertToSource(var0)) {
            var6 = var0.getBlockState(var5.setWithOffset((BaseBlockPosition)var1, EnumDirection.DOWN));
            var72 = ((BlockBase.BlockData)var6).getFluidState();
            if (((BlockBase.BlockData)var6).isSolid() || this.isSourceBlockOfThisType((Fluid)var72)) {
                return this.getSource(false);
            }
        }
        if (!((Fluid)(var8 = ((BlockBase.BlockData)(var72 = var0.getBlockState((BlockPosition)(var6 = var5.setWithOffset((BaseBlockPosition)var1, EnumDirection.UP))))).getFluidState())).isEmpty() && ((Fluid)var8).getType().isSame(this) && FluidTypeFlowing.canPassThroughWall(EnumDirection.UP, var0, var1, var2, (BlockPosition)var6, (IBlockData)var72)) {
            return this.getFlowing(8, true);
        }
        int var9 = var3 - this.getDropOff(var0);
        if (var9 <= 0) {
            return FluidTypes.EMPTY.defaultFluidState();
        }
        return this.getFlowing(var9, false);
    }

    private static boolean canPassThroughWall(EnumDirection var0, IBlockAccess var1, BlockPosition var2, IBlockData var3, BlockPosition var4, IBlockData var5) {
        int var10;
        a var9;
        VoxelShape var6 = var5.getCollisionShape(var1, var4);
        if (var6 == VoxelShapes.block()) {
            return false;
        }
        VoxelShape var7 = var3.getCollisionShape(var1, var2);
        if (var7 == VoxelShapes.block()) {
            return false;
        }
        if (var7 == VoxelShapes.empty() && var6 == VoxelShapes.empty()) {
            return true;
        }
        Object2ByteLinkedOpenHashMap<a> var8 = var3.getBlock().hasDynamicShape() || var5.getBlock().hasDynamicShape() ? null : OCCLUSION_CACHE.get();
        if (var8 != null) {
            var9 = new a(var3, var5, var0);
            var10 = var8.getAndMoveToFirst((Object)var9);
            if (var10 != 127) {
                return var10 != 0;
            }
        } else {
            var9 = null;
        }
        int n2 = var10 = !VoxelShapes.mergedFaceOccludes(var7, var6, var0) ? 1 : 0;
        if (var8 != null) {
            if (var8.size() == 200) {
                var8.removeLastByte();
            }
            var8.putAndMoveToFirst((Object)var9, (byte)(var10 != 0 ? 1 : 0));
        }
        return var10 != 0;
    }

    public abstract FluidType getFlowing();

    public Fluid getFlowing(int var0, boolean var1) {
        return (Fluid)((Fluid)this.getFlowing().defaultFluidState().setValue(LEVEL, var0)).setValue(FALLING, var1);
    }

    public abstract FluidType getSource();

    public Fluid getSource(boolean var0) {
        return (Fluid)this.getSource().defaultFluidState().setValue(FALLING, var0);
    }

    protected abstract boolean canConvertToSource(WorldServer var1);

    protected void spreadTo(GeneratorAccess var0, BlockPosition var1, IBlockData var2, EnumDirection var3, Fluid var4) {
        Block block = var2.getBlock();
        if (block instanceof IFluidContainer) {
            IFluidContainer var5 = (IFluidContainer)((Object)block);
            var5.placeLiquid(var0, var1, var2, var4);
        } else {
            if (!var2.isAir()) {
                this.beforeDestroyingBlock(var0, var1, var2);
            }
            var0.setBlock(var1, var4.createLegacyBlock(), 3);
        }
    }

    protected abstract void beforeDestroyingBlock(GeneratorAccess var1, BlockPosition var2, IBlockData var3);

    protected int getSlopeDistance(IWorldReader var0, BlockPosition var1, int var2, EnumDirection var3, IBlockData var4, b var5) {
        int var6 = 1000;
        for (EnumDirection var8 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            int var12;
            if (var8 == var3) continue;
            BlockPosition var9 = var1.relative(var8);
            IBlockData var10 = var5.getBlockState(var9);
            Fluid var11 = var10.getFluidState();
            if (!this.canPassThrough(var0, this.getFlowing(), var1, var4, var8, var9, var10, var11)) continue;
            if (var5.isHole(var9)) {
                return var2;
            }
            if (var2 >= this.getSlopeFindDistance(var0) || (var12 = this.getSlopeDistance(var0, var9, var2 + 1, var8.getOpposite(), var10, var5)) >= var6) continue;
            var6 = var12;
        }
        return var6;
    }

    boolean isWaterHole(IBlockAccess var0, BlockPosition var1, IBlockData var2, BlockPosition var3, IBlockData var4) {
        if (!FluidTypeFlowing.canPassThroughWall(EnumDirection.DOWN, var0, var1, var2, var3, var4)) {
            return false;
        }
        if (var4.getFluidState().getType().isSame(this)) {
            return true;
        }
        return FluidTypeFlowing.canHoldFluid(var0, var3, var4, this.getFlowing());
    }

    private boolean canPassThrough(IBlockAccess var0, FluidType var1, BlockPosition var2, IBlockData var3, EnumDirection var4, BlockPosition var5, IBlockData var6, Fluid var7) {
        return this.canMaybePassThrough(var0, var2, var3, var4, var5, var6, var7) && FluidTypeFlowing.canHoldSpecificFluid(var0, var5, var6, var1);
    }

    private boolean canMaybePassThrough(IBlockAccess var0, BlockPosition var1, IBlockData var2, EnumDirection var3, BlockPosition var4, IBlockData var5, Fluid var6) {
        return !this.isSourceBlockOfThisType(var6) && FluidTypeFlowing.canHoldAnyFluid(var5) && FluidTypeFlowing.canPassThroughWall(var3, var0, var1, var2, var4, var5);
    }

    private boolean isSourceBlockOfThisType(Fluid var0) {
        return var0.getType().isSame(this) && var0.isSource();
    }

    protected abstract int getSlopeFindDistance(IWorldReader var1);

    private int sourceNeighborCount(IWorldReader var0, BlockPosition var1) {
        int var2 = 0;
        for (EnumDirection var4 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockPosition var5 = var1.relative(var4);
            Fluid var6 = var0.getFluidState(var5);
            if (!this.isSourceBlockOfThisType(var6)) continue;
            ++var2;
        }
        return var2;
    }

    protected Map<EnumDirection, Fluid> getSpread(WorldServer var0, BlockPosition var1, IBlockData var2) {
        int var3 = 1000;
        EnumMap var4 = Maps.newEnumMap(EnumDirection.class);
        b var5 = null;
        for (EnumDirection var7 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            int var12;
            Fluid var11;
            Fluid var10;
            IBlockData var9;
            BlockPosition var8;
            if (!this.canMaybePassThrough(var0, var1, var2, var7, var8 = var1.relative(var7), var9 = var0.getBlockState(var8), var10 = var9.getFluidState()) || !FluidTypeFlowing.canHoldSpecificFluid(var0, var8, var9, (var11 = this.getNewLiquid(var0, var8, var9)).getType())) continue;
            if (var5 == null) {
                var5 = new b(var0, var1);
            }
            if ((var12 = var5.isHole(var8) ? 0 : this.getSlopeDistance(var0, var8, 1, var7.getOpposite(), var9, var5)) < var3) {
                var4.clear();
            }
            if (var12 > var3) continue;
            if (var10.canBeReplacedWith(var0, var8, var11.getType(), var7)) {
                var4.put(var7, var11);
            }
            var3 = var12;
        }
        return var4;
    }

    private static boolean canHoldAnyFluid(IBlockData var0) {
        Block var1 = var0.getBlock();
        if (var1 instanceof IFluidContainer) {
            return true;
        }
        if (var0.blocksMotion()) {
            return false;
        }
        return !(var1 instanceof BlockDoor) && !var0.is(TagsBlock.SIGNS) && !var0.is(Blocks.LADDER) && !var0.is(Blocks.SUGAR_CANE) && !var0.is(Blocks.BUBBLE_COLUMN) && !var0.is(Blocks.NETHER_PORTAL) && !var0.is(Blocks.END_PORTAL) && !var0.is(Blocks.END_GATEWAY) && !var0.is(Blocks.STRUCTURE_VOID);
    }

    private static boolean canHoldFluid(IBlockAccess var0, BlockPosition var1, IBlockData var2, FluidType var3) {
        return FluidTypeFlowing.canHoldAnyFluid(var2) && FluidTypeFlowing.canHoldSpecificFluid(var0, var1, var2, var3);
    }

    private static boolean canHoldSpecificFluid(IBlockAccess var0, BlockPosition var1, IBlockData var2, FluidType var3) {
        Block var4 = var2.getBlock();
        if (var4 instanceof IFluidContainer) {
            IFluidContainer var5 = (IFluidContainer)((Object)var4);
            return var5.canPlaceLiquid(null, var0, var1, var2, var3);
        }
        return true;
    }

    protected abstract int getDropOff(IWorldReader var1);

    protected int getSpreadDelay(World var0, BlockPosition var1, Fluid var2, Fluid var3) {
        return this.getTickDelay(var0);
    }

    @Override
    public void tick(WorldServer var0, BlockPosition var1, IBlockData var2, Fluid var3) {
        if (!var3.isSource()) {
            Fluid var4 = this.getNewLiquid(var0, var1, var0.getBlockState(var1));
            int var5 = this.getSpreadDelay(var0, var1, var3, var4);
            if (var4.isEmpty()) {
                var3 = var4;
                var2 = Blocks.AIR.defaultBlockState();
                var0.setBlock(var1, var2, 3);
            } else if (var4 != var3) {
                var3 = var4;
                var2 = var3.createLegacyBlock();
                var0.setBlock(var1, var2, 3);
                var0.scheduleTick(var1, var3.getType(), var5);
            }
        }
        this.spread(var0, var1, var2, var3);
    }

    protected static int getLegacyLevel(Fluid var0) {
        if (var0.isSource()) {
            return 0;
        }
        return 8 - Math.min(var0.getAmount(), 8) + (var0.getValue(FALLING) != false ? 8 : 0);
    }

    private static boolean hasSameAbove(Fluid var0, IBlockAccess var1, BlockPosition var2) {
        return var0.getType().isSame(var1.getFluidState(var2.above()).getType());
    }

    @Override
    public float getHeight(Fluid var0, IBlockAccess var1, BlockPosition var2) {
        if (FluidTypeFlowing.hasSameAbove(var0, var1, var2)) {
            return 1.0f;
        }
        return var0.getOwnHeight();
    }

    @Override
    public float getOwnHeight(Fluid var0) {
        return (float)var0.getAmount() / 9.0f;
    }

    @Override
    public abstract int getAmount(Fluid var1);

    @Override
    public VoxelShape getShape(Fluid var0, IBlockAccess var1, BlockPosition var22) {
        if (var0.getAmount() == 9 && FluidTypeFlowing.hasSameAbove(var0, var1, var22)) {
            return VoxelShapes.block();
        }
        return this.shapes.computeIfAbsent(var0, var2 -> VoxelShapes.box(0.0, 0.0, 0.0, 1.0, var2.getHeight(var1, var22), 1.0));
    }

    record a(IBlockData first, IBlockData second, EnumDirection direction) {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object var0) {
            if (!(var0 instanceof a)) return false;
            a var1 = (a)var0;
            if (this.first != var1.first) return false;
            if (this.second != var1.second) return false;
            if (this.direction != var1.direction) return false;
            return true;
        }

        @Override
        public int hashCode() {
            int var0 = System.identityHashCode(this.first);
            var0 = 31 * var0 + System.identityHashCode(this.second);
            var0 = 31 * var0 + this.direction.hashCode();
            return var0;
        }
    }

    protected class b {
        private final IBlockAccess level;
        private final BlockPosition origin;
        private final Short2ObjectMap<IBlockData> stateCache = new Short2ObjectOpenHashMap();
        private final Short2BooleanMap holeCache = new Short2BooleanOpenHashMap();

        b(IBlockAccess var1, BlockPosition var2) {
            this.level = var1;
            this.origin = var2;
        }

        public IBlockData getBlockState(BlockPosition var0) {
            return this.getBlockState(var0, this.getCacheKey(var0));
        }

        private IBlockData getBlockState(BlockPosition var0, short var12) {
            return (IBlockData)this.stateCache.computeIfAbsent(var12, var1 -> this.level.getBlockState(var0));
        }

        public boolean isHole(BlockPosition var0) {
            return this.holeCache.computeIfAbsent(this.getCacheKey(var0), var1 -> {
                IBlockData var2 = this.getBlockState(var0, var1);
                BlockPosition var3 = var0.below();
                IBlockData var4 = this.level.getBlockState(var3);
                return FluidTypeFlowing.this.isWaterHole(this.level, var0, var2, var3, var4);
            });
        }

        private short getCacheKey(BlockPosition var0) {
            int var1 = var0.getX() - this.origin.getX();
            int var2 = var0.getZ() - this.origin.getZ();
            return (short)((var1 + 128 & 0xFF) << 8 | var2 + 128 & 0xFF);
        }
    }
}

