/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.CrashReportCallable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.state.IBlockData;

public class CrashReportSystemDetails {
    private final String title;
    private final List<CrashReportDetail> entries = Lists.newArrayList();
    private StackTraceElement[] stackTrace = new StackTraceElement[0];

    public CrashReportSystemDetails(String var0) {
        this.title = var0;
    }

    public static String formatLocation(double var0, double var2, double var4) {
        return String.format(Locale.ROOT, "%.2f,%.2f,%.2f", var0, var2, var4);
    }

    public static String formatLocation(LevelHeightAccessor var0, double var1, double var3, double var5) {
        return String.format(Locale.ROOT, "%.2f,%.2f,%.2f - %s", var1, var3, var5, CrashReportSystemDetails.formatLocation(var0, BlockPosition.containing(var1, var3, var5)));
    }

    public static String formatLocation(LevelHeightAccessor var0, BlockPosition var1) {
        return CrashReportSystemDetails.formatLocation(var0, var1.getX(), var1.getY(), var1.getZ());
    }

    public static String formatLocation(LevelHeightAccessor var0, int var1, int var2, int var3) {
        int var16;
        int var15;
        int var14;
        int var13;
        int var12;
        int var11;
        int var10;
        int var9;
        int var8;
        int var7;
        int var6;
        StringBuilder var4 = new StringBuilder();
        try {
            var4.append(String.format(Locale.ROOT, "World: (%d,%d,%d)", var1, var2, var3));
        }
        catch (Throwable var5) {
            var4.append("(Error finding world loc)");
        }
        var4.append(", ");
        try {
            int var5 = SectionPosition.blockToSectionCoord(var1);
            var6 = SectionPosition.blockToSectionCoord(var2);
            var7 = SectionPosition.blockToSectionCoord(var3);
            var8 = var1 & 0xF;
            var9 = var2 & 0xF;
            var10 = var3 & 0xF;
            var11 = SectionPosition.sectionToBlockCoord(var5);
            var12 = var0.getMinY();
            var13 = SectionPosition.sectionToBlockCoord(var7);
            var14 = SectionPosition.sectionToBlockCoord(var5 + 1) - 1;
            var15 = var0.getMaxY();
            var16 = SectionPosition.sectionToBlockCoord(var7 + 1) - 1;
            var4.append(String.format(Locale.ROOT, "Section: (at %d,%d,%d in %d,%d,%d; chunk contains blocks %d,%d,%d to %d,%d,%d)", var8, var9, var10, var5, var6, var7, var11, var12, var13, var14, var15, var16));
        }
        catch (Throwable var5) {
            var4.append("(Error finding chunk loc)");
        }
        var4.append(", ");
        try {
            int var5 = var1 >> 9;
            var6 = var3 >> 9;
            var7 = var5 << 5;
            var8 = var6 << 5;
            var9 = (var5 + 1 << 5) - 1;
            var10 = (var6 + 1 << 5) - 1;
            var11 = var5 << 9;
            var12 = var0.getMinY();
            var13 = var6 << 9;
            var14 = (var5 + 1 << 9) - 1;
            var15 = var0.getMaxY();
            var16 = (var6 + 1 << 9) - 1;
            var4.append(String.format(Locale.ROOT, "Region: (%d,%d; contains chunks %d,%d to %d,%d, blocks %d,%d,%d to %d,%d,%d)", var5, var6, var7, var8, var9, var10, var11, var12, var13, var14, var15, var16));
        }
        catch (Throwable var5) {
            var4.append("(Error finding world loc)");
        }
        return var4.toString();
    }

    public CrashReportSystemDetails setDetail(String var0, CrashReportCallable<String> var1) {
        try {
            this.setDetail(var0, var1.call());
        }
        catch (Throwable var2) {
            this.setDetailError(var0, var2);
        }
        return this;
    }

    public CrashReportSystemDetails setDetail(String var0, Object var1) {
        this.entries.add(new CrashReportDetail(var0, var1));
        return this;
    }

    public void setDetailError(String var0, Throwable var1) {
        this.setDetail(var0, var1);
    }

    public int fillInStackTrace(int var0) {
        StackTraceElement[] var1 = Thread.currentThread().getStackTrace();
        if (var1.length <= 0) {
            return 0;
        }
        this.stackTrace = new StackTraceElement[var1.length - 3 - var0];
        System.arraycopy(var1, 3 + var0, this.stackTrace, 0, this.stackTrace.length);
        return this.stackTrace.length;
    }

    public boolean validateStackTrace(StackTraceElement var0, StackTraceElement var1) {
        if (this.stackTrace.length == 0 || var0 == null) {
            return false;
        }
        StackTraceElement var2 = this.stackTrace[0];
        if (!(var2.isNativeMethod() == var0.isNativeMethod() && var2.getClassName().equals(var0.getClassName()) && var2.getFileName().equals(var0.getFileName()) && var2.getMethodName().equals(var0.getMethodName()))) {
            return false;
        }
        if (var1 != null != this.stackTrace.length > 1) {
            return false;
        }
        if (var1 != null && !this.stackTrace[1].equals(var1)) {
            return false;
        }
        this.stackTrace[0] = var0;
        return true;
    }

    public void trimStacktrace(int var0) {
        StackTraceElement[] var1 = new StackTraceElement[this.stackTrace.length - var0];
        System.arraycopy(this.stackTrace, 0, var1, 0, var1.length);
        this.stackTrace = var1;
    }

    public void getDetails(StringBuilder var0) {
        var0.append("-- ").append(this.title).append(" --\n");
        var0.append("Details:");
        for (CrashReportDetail var2 : this.entries) {
            var0.append("\n\t");
            var0.append(var2.getKey());
            var0.append(": ");
            var0.append(var2.getValue());
        }
        if (this.stackTrace != null && this.stackTrace.length > 0) {
            var0.append("\nStacktrace:");
            for (StackTraceElement var4 : this.stackTrace) {
                var0.append("\n\tat ");
                var0.append(var4);
            }
        }
    }

    public StackTraceElement[] getStacktrace() {
        return this.stackTrace;
    }

    public static void populateBlockDetails(CrashReportSystemDetails var0, LevelHeightAccessor var1, BlockPosition var2, IBlockData var3) {
        var0.setDetail("Block", var3::toString);
        CrashReportSystemDetails.populateBlockLocationDetails(var0, var1, var2);
    }

    public static CrashReportSystemDetails populateBlockLocationDetails(CrashReportSystemDetails var0, LevelHeightAccessor var1, BlockPosition var2) {
        return var0.setDetail("Block location", () -> CrashReportSystemDetails.formatLocation(var1, var2));
    }

    static class CrashReportDetail {
        private final String key;
        private final String value;

        public CrashReportDetail(String var0, @Nullable Object var1) {
            this.key = var0;
            if (var1 == null) {
                this.value = "~~NULL~~";
            } else if (var1 instanceof Throwable) {
                Throwable var2 = (Throwable)var1;
                this.value = "~~ERROR~~ " + var2.getClass().getSimpleName() + ": " + var2.getMessage();
            } else {
                this.value = var1.toString();
            }
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

