/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.blocks;

import com.mojang.logging.LogUtils;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import org.slf4j.Logger;

public class ArgumentTileLocation
implements Predicate<ShapeDetectorBlock> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final IBlockData state;
    private final Set<IBlockState<?>> properties;
    @Nullable
    private final NBTTagCompound tag;

    public ArgumentTileLocation(IBlockData var0, Set<IBlockState<?>> var1, @Nullable NBTTagCompound var2) {
        this.state = var0;
        this.properties = var1;
        this.tag = var2;
    }

    public IBlockData getState() {
        return this.state;
    }

    public Set<IBlockState<?>> getDefinedProperties() {
        return this.properties;
    }

    @Override
    public boolean test(ShapeDetectorBlock var0) {
        IBlockData var1 = var0.getState();
        if (!var1.is(this.state.getBlock())) {
            return false;
        }
        for (IBlockState<?> var3 : this.properties) {
            if (var1.getValue(var3) == this.state.getValue(var3)) continue;
            return false;
        }
        if (this.tag != null) {
            TileEntity var2 = var0.getEntity();
            return var2 != null && GameProfileSerializer.compareNbt(this.tag, var2.saveWithFullMetadata(var0.getLevel().registryAccess()), true);
        }
        return true;
    }

    public boolean test(WorldServer var0, BlockPosition var1) {
        return this.test(new ShapeDetectorBlock(var0, var1, false));
    }

    public boolean place(WorldServer var0, BlockPosition var1, int var2) {
        TileEntity var5;
        IBlockData var3;
        IBlockData iBlockData = var3 = (var2 & 0x10) != 0 ? this.state : Block.updateFromNeighbourShapes(this.state, var0, var1);
        if (var3.isAir()) {
            var3 = this.state;
        }
        var3 = this.overwriteWithDefinedProperties(var3);
        boolean var4 = false;
        if (var0.setBlock(var1, var3, var2)) {
            var4 = true;
        }
        if (this.tag != null && (var5 = var0.getBlockEntity(var1)) != null) {
            try (ProblemReporter.j var6 = new ProblemReporter.j(LOGGER);){
                IRegistryCustom var7 = var0.registryAccess();
                ProblemReporter var8 = var6.forChild(var5.problemPath());
                TagValueOutput var9 = TagValueOutput.createWithContext(var8.forChild(() -> "(before)"), var7);
                var5.saveWithoutMetadata(var9);
                NBTTagCompound var10 = var9.buildResult();
                var5.loadWithComponents(TagValueInput.create((ProblemReporter)var6, (HolderLookup.a)var7, this.tag));
                TagValueOutput var11 = TagValueOutput.createWithContext(var8.forChild(() -> "(after)"), var7);
                var5.saveWithoutMetadata(var11);
                NBTTagCompound var12 = var11.buildResult();
                if (!var12.equals(var10)) {
                    var4 = true;
                    var5.setChanged();
                    var0.getChunkSource().blockChanged(var1);
                }
            }
        }
        return var4;
    }

    private IBlockData overwriteWithDefinedProperties(IBlockData var0) {
        if (var0 == this.state) {
            return var0;
        }
        for (IBlockState<?> var2 : this.properties) {
            var0 = ArgumentTileLocation.copyProperty(var0, this.state, var2);
        }
        return var0;
    }

    private static <T extends Comparable<T>> IBlockData copyProperty(IBlockData var0, IBlockData var1, IBlockState<T> var2) {
        return (IBlockData)var0.trySetValue(var2, var1.getValue(var2));
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((ShapeDetectorBlock)object);
    }
}

