/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.selector;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class EntitySelector {
    public static final int INFINITE = Integer.MAX_VALUE;
    public static final BiConsumer<Vec3D, List<? extends Entity>> ORDER_ARBITRARY = (var0, var1) -> {};
    private static final EntityTypeTest<Entity, ?> ANY_TYPE = new EntityTypeTest<Entity, Entity>(){

        @Override
        public Entity tryCast(Entity var0) {
            return var0;
        }

        @Override
        public Class<? extends Entity> getBaseClass() {
            return Entity.class;
        }
    };
    private final int maxResults;
    private final boolean includesEntities;
    private final boolean worldLimited;
    private final List<Predicate<Entity>> contextFreePredicates;
    @Nullable
    private final CriterionConditionValue.DoubleRange range;
    private final Function<Vec3D, Vec3D> position;
    @Nullable
    private final AxisAlignedBB aabb;
    private final BiConsumer<Vec3D, List<? extends Entity>> order;
    private final boolean currentEntity;
    @Nullable
    private final String playerName;
    @Nullable
    private final UUID entityUUID;
    private final EntityTypeTest<Entity, ?> type;
    private final boolean usesSelector;

    public EntitySelector(int var0, boolean var1, boolean var2, List<Predicate<Entity>> var3, @Nullable CriterionConditionValue.DoubleRange var4, Function<Vec3D, Vec3D> var5, @Nullable AxisAlignedBB var6, BiConsumer<Vec3D, List<? extends Entity>> var7, boolean var8, @Nullable String var9, @Nullable UUID var10, @Nullable EntityTypes<?> var11, boolean var12) {
        this.maxResults = var0;
        this.includesEntities = var1;
        this.worldLimited = var2;
        this.contextFreePredicates = var3;
        this.range = var4;
        this.position = var5;
        this.aabb = var6;
        this.order = var7;
        this.currentEntity = var8;
        this.playerName = var9;
        this.entityUUID = var10;
        this.type = var11 == null ? ANY_TYPE : var11;
        this.usesSelector = var12;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public boolean includesEntities() {
        return this.includesEntities;
    }

    public boolean isSelfSelector() {
        return this.currentEntity;
    }

    public boolean isWorldLimited() {
        return this.worldLimited;
    }

    public boolean usesSelector() {
        return this.usesSelector;
    }

    private void checkPermissions(CommandListenerWrapper var0) throws CommandSyntaxException {
        if (this.usesSelector && !var0.allowsSelectors()) {
            throw ArgumentEntity.ERROR_SELECTORS_NOT_ALLOWED.create();
        }
    }

    public Entity findSingleEntity(CommandListenerWrapper var0) throws CommandSyntaxException {
        this.checkPermissions(var0);
        List<? extends Entity> var1 = this.findEntities(var0);
        if (var1.isEmpty()) {
            throw ArgumentEntity.NO_ENTITIES_FOUND.create();
        }
        if (var1.size() > 1) {
            throw ArgumentEntity.ERROR_NOT_SINGLE_ENTITY.create();
        }
        return var1.get(0);
    }

    public List<? extends Entity> findEntities(CommandListenerWrapper var0) throws CommandSyntaxException {
        this.checkPermissions(var0);
        if (!this.includesEntities) {
            return this.findPlayers(var0);
        }
        if (this.playerName != null) {
            EntityPlayer var1 = var0.getServer().getPlayerList().getPlayerByName(this.playerName);
            if (var1 == null) {
                return List.of();
            }
            return List.of(var1);
        }
        if (this.entityUUID != null) {
            for (WorldServer var2 : var0.getServer().getAllLevels()) {
                Entity var3 = var2.getEntity(this.entityUUID);
                if (var3 == null) continue;
                if (!var3.getType().isEnabled(var0.enabledFeatures())) break;
                return List.of(var3);
            }
            return List.of();
        }
        Vec3D var1 = this.position.apply(var0.getPosition());
        AxisAlignedBB var2 = this.getAbsoluteAabb(var1);
        if (this.currentEntity) {
            Predicate<Entity> var3 = this.getPredicate(var1, var2, null);
            if (var0.getEntity() != null && var3.test(var0.getEntity())) {
                return List.of(var0.getEntity());
            }
            return List.of();
        }
        Predicate<Entity> var3 = this.getPredicate(var1, var2, var0.enabledFeatures());
        ObjectArrayList var4 = new ObjectArrayList();
        if (this.isWorldLimited()) {
            this.addEntities((List<Entity>)var4, var0.getLevel(), var2, var3);
        } else {
            for (WorldServer var6 : var0.getServer().getAllLevels()) {
                this.addEntities((List<Entity>)var4, var6, var2, var3);
            }
        }
        return this.sortAndLimit(var1, (List)var4);
    }

    private void addEntities(List<Entity> var0, WorldServer var1, @Nullable AxisAlignedBB var2, Predicate<Entity> var3) {
        int var4 = this.getResultLimit();
        if (var0.size() >= var4) {
            return;
        }
        if (var2 != null) {
            var1.getEntities(this.type, var2, var3, var0, var4);
        } else {
            var1.getEntities(this.type, var3, var0, var4);
        }
    }

    private int getResultLimit() {
        return this.order == ORDER_ARBITRARY ? this.maxResults : Integer.MAX_VALUE;
    }

    public EntityPlayer findSinglePlayer(CommandListenerWrapper var0) throws CommandSyntaxException {
        this.checkPermissions(var0);
        List<EntityPlayer> var1 = this.findPlayers(var0);
        if (var1.size() != 1) {
            throw ArgumentEntity.NO_PLAYERS_FOUND.create();
        }
        return var1.get(0);
    }

    public List<EntityPlayer> findPlayers(CommandListenerWrapper var0) throws CommandSyntaxException {
        Object var4;
        this.checkPermissions(var0);
        if (this.playerName != null) {
            EntityPlayer var1 = var0.getServer().getPlayerList().getPlayerByName(this.playerName);
            if (var1 == null) {
                return List.of();
            }
            return List.of(var1);
        }
        if (this.entityUUID != null) {
            EntityPlayer var1 = var0.getServer().getPlayerList().getPlayer(this.entityUUID);
            if (var1 == null) {
                return List.of();
            }
            return List.of(var1);
        }
        Vec3D var1 = this.position.apply(var0.getPosition());
        AxisAlignedBB var2 = this.getAbsoluteAabb(var1);
        Predicate<Entity> var3 = this.getPredicate(var1, var2, null);
        if (this.currentEntity) {
            EntityPlayer var42;
            Entity entity = var0.getEntity();
            if (entity instanceof EntityPlayer && var3.test(var42 = (EntityPlayer)entity)) {
                return List.of(var42);
            }
            return List.of();
        }
        int var5 = this.getResultLimit();
        if (this.isWorldLimited()) {
            var4 = var0.getLevel().getPlayers(var3, var5);
        } else {
            var4 = new ObjectArrayList();
            for (EntityPlayer var7 : var0.getServer().getPlayerList().getPlayers()) {
                if (!var3.test(var7)) continue;
                var4.add(var7);
                if (var4.size() < var5) continue;
                return var4;
            }
        }
        return this.sortAndLimit(var1, (List)var4);
    }

    @Nullable
    private AxisAlignedBB getAbsoluteAabb(Vec3D var0) {
        return this.aabb != null ? this.aabb.move(var0) : null;
    }

    private Predicate<Entity> getPredicate(Vec3D var0, @Nullable AxisAlignedBB var12, @Nullable FeatureFlagSet var2) {
        ObjectArrayList var7;
        boolean var5;
        boolean var4;
        boolean var3 = var2 != null;
        int var6 = (var3 ? 1 : 0) + ((var4 = var12 != null) ? 1 : 0) + ((var5 = this.range != null) ? 1 : 0);
        if (var6 == 0) {
            var7 = this.contextFreePredicates;
        } else {
            ObjectArrayList var8 = new ObjectArrayList(this.contextFreePredicates.size() + var6);
            var8.addAll(this.contextFreePredicates);
            if (var3) {
                var8.add(var1 -> var1.getType().isEnabled(var2));
            }
            if (var4) {
                var8.add(var1 -> var12.intersects(var1.getBoundingBox()));
            }
            if (var5) {
                var8.add(var1 -> this.range.matchesSqr(var1.distanceToSqr(var0)));
            }
            var7 = var8;
        }
        return SystemUtils.allOf(var7);
    }

    private <T extends Entity> List<T> sortAndLimit(Vec3D var0, List<T> var1) {
        if (var1.size() > 1) {
            this.order.accept(var0, var1);
        }
        return var1.subList(0, Math.min(this.maxResults, var1.size()));
    }

    public static IChatBaseComponent joinNames(List<? extends Entity> var0) {
        return ChatComponentUtils.formatList(var0, Entity::getDisplayName);
    }
}

