/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.execution;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.execution.ChainModifiers;
import net.minecraft.commands.execution.ExecutionControl;
import net.minecraft.commands.execution.TraceCallbacks;

public interface CustomCommandExecutor<T> {
    public void run(T var1, ContextChain<T> var2, ChainModifiers var3, ExecutionControl<T> var4);

    public static abstract class b<T extends ExecutionCommandSource<T>>
    implements CustomCommandExecutor<T> {
        @Override
        public final void run(T var0, ContextChain<T> var1, ChainModifiers var2, ExecutionControl<T> var3) {
            try {
                this.runGuarded(var0, var1, var2, var3);
            }
            catch (CommandSyntaxException var4) {
                this.onError(var4, var0, var2, var3.tracer());
                var0.callback().onFailure();
            }
        }

        protected void onError(CommandSyntaxException var0, T var1, ChainModifiers var2, @Nullable TraceCallbacks var3) {
            var1.handleError(var0, var2.isForked(), var3);
        }

        protected abstract void runGuarded(T var1, ContextChain<T> var2, ChainModifiers var3, ExecutionControl<T> var4) throws CommandSyntaxException;
    }

    public static interface a<T>
    extends Command<T>,
    CustomCommandExecutor<T> {
        default public int run(CommandContext<T> var0) throws CommandSyntaxException {
            throw new UnsupportedOperationException("This function should not run");
        }
    }
}

