/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.IntFunction;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;

public record ChatDecoration(String translationKey, List<a> parameters, ChatModifier style) {
    public static final Codec<ChatDecoration> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.STRING.fieldOf("translation_key").forGetter(ChatDecoration::translationKey), (App)a.CODEC.listOf().fieldOf("parameters").forGetter(ChatDecoration::parameters), (App)ChatModifier.ChatModifierSerializer.CODEC.optionalFieldOf("style", (Object)ChatModifier.EMPTY).forGetter(ChatDecoration::style)).apply((Applicative)var0, ChatDecoration::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ChatDecoration> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.STRING_UTF8, ChatDecoration::translationKey, a.STREAM_CODEC.apply(ByteBufCodecs.list()), ChatDecoration::parameters, ChatModifier.ChatModifierSerializer.TRUSTED_STREAM_CODEC, ChatDecoration::style, ChatDecoration::new);

    public static ChatDecoration withSender(String var0) {
        return new ChatDecoration(var0, List.of(a.SENDER, a.CONTENT), ChatModifier.EMPTY);
    }

    public static ChatDecoration incomingDirectMessage(String var0) {
        ChatModifier var1 = ChatModifier.EMPTY.withColor(EnumChatFormat.GRAY).withItalic(true);
        return new ChatDecoration(var0, List.of(a.SENDER, a.CONTENT), var1);
    }

    public static ChatDecoration outgoingDirectMessage(String var0) {
        ChatModifier var1 = ChatModifier.EMPTY.withColor(EnumChatFormat.GRAY).withItalic(true);
        return new ChatDecoration(var0, List.of(a.TARGET, a.CONTENT), var1);
    }

    public static ChatDecoration teamMessage(String var0) {
        return new ChatDecoration(var0, List.of(a.TARGET, a.SENDER, a.CONTENT), ChatModifier.EMPTY);
    }

    public IChatBaseComponent decorate(IChatBaseComponent var0, ChatMessageType.a var1) {
        Object[] var2 = this.resolveParameters(var0, var1);
        return IChatBaseComponent.translatable(this.translationKey, var2).withStyle(this.style);
    }

    private IChatBaseComponent[] resolveParameters(IChatBaseComponent var0, ChatMessageType.a var1) {
        IChatBaseComponent[] var2 = new IChatBaseComponent[this.parameters.size()];
        for (int var3 = 0; var3 < var2.length; ++var3) {
            a var4 = this.parameters.get(var3);
            var2[var3] = var4.select(var0, var1);
        }
        return var2;
    }

    public static final class net.minecraft.network.chat.ChatDecoration$a
    extends Enum<net.minecraft.network.chat.ChatDecoration$a>
    implements INamable {
        public static final /* enum */ net.minecraft.network.chat.ChatDecoration$a SENDER = new net.minecraft.network.chat.ChatDecoration$a(0, "sender", (var0, var1) -> var1.name());
        public static final /* enum */ net.minecraft.network.chat.ChatDecoration$a TARGET = new net.minecraft.network.chat.ChatDecoration$a(1, "target", (var0, var1) -> var1.targetName().orElse(CommonComponents.EMPTY));
        public static final /* enum */ net.minecraft.network.chat.ChatDecoration$a CONTENT = new net.minecraft.network.chat.ChatDecoration$a(2, "content", (var0, var1) -> var0);
        private static final IntFunction<net.minecraft.network.chat.ChatDecoration$a> BY_ID;
        public static final Codec<net.minecraft.network.chat.ChatDecoration$a> CODEC;
        public static final StreamCodec<ByteBuf, net.minecraft.network.chat.ChatDecoration$a> STREAM_CODEC;
        private final int id;
        private final String name;
        private final a selector;
        private static final /* synthetic */ net.minecraft.network.chat.ChatDecoration$a[] j;

        public static net.minecraft.network.chat.ChatDecoration$a[] values() {
            return (net.minecraft.network.chat.ChatDecoration$a[])j.clone();
        }

        public static net.minecraft.network.chat.ChatDecoration$a valueOf(String var0) {
            return Enum.valueOf(net.minecraft.network.chat.ChatDecoration$a.class, var0);
        }

        private net.minecraft.network.chat.ChatDecoration$a(int var2, String var3, a var4) {
            this.id = var2;
            this.name = var3;
            this.selector = var4;
        }

        public IChatBaseComponent select(IChatBaseComponent var0, ChatMessageType.a var1) {
            return this.selector.select(var0, var1);
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private static /* synthetic */ net.minecraft.network.chat.ChatDecoration$a[] a() {
            return new net.minecraft.network.chat.ChatDecoration$a[]{SENDER, TARGET, CONTENT};
        }

        static {
            j = net.minecraft.network.chat.ChatDecoration$a.a();
            BY_ID = ByIdMap.continuous(var0 -> var0.id, net.minecraft.network.chat.ChatDecoration$a.values(), ByIdMap.a.ZERO);
            CODEC = INamable.fromEnum(net.minecraft.network.chat.ChatDecoration$a::values);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, var0 -> var0.id);
        }

        public static interface a {
            public IChatBaseComponent select(IChatBaseComponent var1, ChatMessageType.a var2);
        }
    }
}

