/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.Locale;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.ClientboundTickingStatePacket;
import net.minecraft.network.protocol.game.ClientboundTickingStepPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.TimeRange;
import net.minecraft.world.TickRateManager;

public class ServerTickRateManager
extends TickRateManager {
    private long remainingSprintTicks = 0L;
    private long sprintTickStartTime = 0L;
    private long sprintTimeSpend = 0L;
    private long scheduledCurrentSprintTicks = 0L;
    private boolean previousIsFrozen = false;
    private final MinecraftServer server;

    public ServerTickRateManager(MinecraftServer var0) {
        this.server = var0;
    }

    public boolean isSprinting() {
        return this.scheduledCurrentSprintTicks > 0L;
    }

    @Override
    public void setFrozen(boolean var0) {
        super.setFrozen(var0);
        this.updateStateToClients();
    }

    private void updateStateToClients() {
        this.server.getPlayerList().broadcastAll(ClientboundTickingStatePacket.from(this));
    }

    private void updateStepTicks() {
        this.server.getPlayerList().broadcastAll(ClientboundTickingStepPacket.from(this));
    }

    public boolean stepGameIfPaused(int var0) {
        if (!this.isFrozen()) {
            return false;
        }
        this.frozenTicksToRun = var0;
        this.updateStepTicks();
        return true;
    }

    public boolean stopStepping() {
        if (this.frozenTicksToRun > 0) {
            this.frozenTicksToRun = 0;
            this.updateStepTicks();
            return true;
        }
        return false;
    }

    public boolean stopSprinting() {
        if (this.remainingSprintTicks > 0L) {
            this.finishTickSprint();
            return true;
        }
        return false;
    }

    public boolean requestGameToSprint(int var0) {
        boolean var1 = this.remainingSprintTicks > 0L;
        this.sprintTimeSpend = 0L;
        this.scheduledCurrentSprintTicks = var0;
        this.remainingSprintTicks = var0;
        this.previousIsFrozen = this.isFrozen();
        this.setFrozen(false);
        return var1;
    }

    private void finishTickSprint() {
        long var0 = this.scheduledCurrentSprintTicks - this.remainingSprintTicks;
        double var2 = Math.max(1.0, (double)this.sprintTimeSpend) / (double)TimeRange.NANOSECONDS_PER_MILLISECOND;
        int var4 = (int)((double)(TimeRange.MILLISECONDS_PER_SECOND * var0) / var2);
        String var5 = String.format(Locale.ROOT, "%.2f", var0 == 0L ? (double)this.millisecondsPerTick() : var2 / (double)var0);
        this.scheduledCurrentSprintTicks = 0L;
        this.sprintTimeSpend = 0L;
        this.server.createCommandSourceStack().sendSuccess(() -> IChatBaseComponent.translatable("commands.tick.sprint.report", var4, var5), true);
        this.remainingSprintTicks = 0L;
        this.setFrozen(this.previousIsFrozen);
        this.server.onTickRateChanged();
    }

    public boolean checkShouldSprintThisTick() {
        if (!this.runGameElements) {
            return false;
        }
        if (this.remainingSprintTicks > 0L) {
            this.sprintTickStartTime = System.nanoTime();
            --this.remainingSprintTicks;
            return true;
        }
        this.finishTickSprint();
        return false;
    }

    public void endTickWork() {
        this.sprintTimeSpend += System.nanoTime() - this.sprintTickStartTime;
    }

    @Override
    public void setTickRate(float var0) {
        super.setTickRate(var0);
        this.server.onTickRateChanged();
        this.updateStateToClients();
    }

    public void updateJoiningPlayer(EntityPlayer var0) {
        var0.connection.send(ClientboundTickingStatePacket.from(this));
        var0.connection.send(ClientboundTickingStepPacket.from(this));
    }
}

