/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.blocks.ArgumentBlockPredicate;
import net.minecraft.commands.arguments.blocks.ArgumentTile;
import net.minecraft.commands.arguments.blocks.ArgumentTileLocation;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.commands.InCommandFunction;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;

public class CommandFill {
    private static final Dynamic2CommandExceptionType ERROR_AREA_TOO_LARGE = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.translatableEscape("commands.fill.toobig", var0, var1));
    static final ArgumentTileLocation HOLLOW_CORE = new ArgumentTileLocation(Blocks.AIR.defaultBlockState(), Collections.emptySet(), null);
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.fill.failed"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var03, CommandBuildContext var1) {
        var03.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("fill").requires(net.minecraft.commands.CommandDispatcher.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.argument("from", ArgumentPosition.blockPos()).then(net.minecraft.commands.CommandDispatcher.argument("to", ArgumentPosition.blockPos()).then(CommandFill.wrapWithMode(var1, net.minecraft.commands.CommandDispatcher.argument("block", ArgumentTile.block(var1)), var0 -> ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "from"), var0 -> ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "to"), var0 -> ArgumentTile.getBlock((CommandContext<CommandListenerWrapper>)var0, "block"), var0 -> null).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("replace").executes(var0 -> CommandFill.fillBlocks((CommandListenerWrapper)var0.getSource(), StructureBoundingBox.fromCorners(ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "from"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "to")), ArgumentTile.getBlock((CommandContext<CommandListenerWrapper>)var0, "block"), Mode.REPLACE, null, false))).then(CommandFill.wrapWithMode(var1, net.minecraft.commands.CommandDispatcher.argument("filter", ArgumentBlockPredicate.blockPredicate(var1)), var0 -> ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "from"), var0 -> ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "to"), var0 -> ArgumentTile.getBlock((CommandContext<CommandListenerWrapper>)var0, "block"), var0 -> ArgumentBlockPredicate.getBlockPredicate((CommandContext<CommandListenerWrapper>)var0, "filter")))).then(net.minecraft.commands.CommandDispatcher.literal("keep").executes(var02 -> CommandFill.fillBlocks((CommandListenerWrapper)var02.getSource(), StructureBoundingBox.fromCorners(ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var02, "from"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var02, "to")), ArgumentTile.getBlock((CommandContext<CommandListenerWrapper>)var02, "block"), Mode.REPLACE, var0 -> var0.getLevel().isEmptyBlock(var0.getPos()), false)))))));
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> wrapWithMode(CommandBuildContext var0, ArgumentBuilder<CommandListenerWrapper, ?> var1, InCommandFunction<CommandContext<CommandListenerWrapper>, BlockPosition> var2, InCommandFunction<CommandContext<CommandListenerWrapper>, BlockPosition> var3, InCommandFunction<CommandContext<CommandListenerWrapper>, ArgumentTileLocation> var42, e<CommandContext<CommandListenerWrapper>, Predicate<ShapeDetectorBlock>> var5) {
        return var1.executes(var4 -> CommandFill.fillBlocks((CommandListenerWrapper)var4.getSource(), StructureBoundingBox.fromCorners((BaseBlockPosition)var2.apply(var4), (BaseBlockPosition)var3.apply(var4)), (ArgumentTileLocation)var42.apply(var4), Mode.REPLACE, (Predicate)var5.apply(var4), false)).then(net.minecraft.commands.CommandDispatcher.literal("outline").executes(var4 -> CommandFill.fillBlocks((CommandListenerWrapper)var4.getSource(), StructureBoundingBox.fromCorners((BaseBlockPosition)var2.apply(var4), (BaseBlockPosition)var3.apply(var4)), (ArgumentTileLocation)var42.apply(var4), Mode.OUTLINE, (Predicate)var5.apply(var4), false))).then(net.minecraft.commands.CommandDispatcher.literal("hollow").executes(var4 -> CommandFill.fillBlocks((CommandListenerWrapper)var4.getSource(), StructureBoundingBox.fromCorners((BaseBlockPosition)var2.apply(var4), (BaseBlockPosition)var3.apply(var4)), (ArgumentTileLocation)var42.apply(var4), Mode.HOLLOW, (Predicate)var5.apply(var4), false))).then(net.minecraft.commands.CommandDispatcher.literal("destroy").executes(var4 -> CommandFill.fillBlocks((CommandListenerWrapper)var4.getSource(), StructureBoundingBox.fromCorners((BaseBlockPosition)var2.apply(var4), (BaseBlockPosition)var3.apply(var4)), (ArgumentTileLocation)var42.apply(var4), Mode.DESTROY, (Predicate)var5.apply(var4), false))).then(net.minecraft.commands.CommandDispatcher.literal("strict").executes(var4 -> CommandFill.fillBlocks((CommandListenerWrapper)var4.getSource(), StructureBoundingBox.fromCorners((BaseBlockPosition)var2.apply(var4), (BaseBlockPosition)var3.apply(var4)), (ArgumentTileLocation)var42.apply(var4), Mode.REPLACE, (Predicate)var5.apply(var4), true)));
    }

    private static int fillBlocks(CommandListenerWrapper var0, StructureBoundingBox var1, ArgumentTileLocation var2, Mode var3, @Nullable Predicate<ShapeDetectorBlock> var4, boolean var5) throws CommandSyntaxException {
        final class A
        extends Record {
            final BlockPosition pos;
            final IBlockData oldState;

            A(BlockPosition var0, IBlockData var1) {
                this.pos = var0;
                this.oldState = var1;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{A.class, "pos;oldState", "pos", "oldState"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{A.class, "pos;oldState", "pos", "oldState"}, this);
            }

            @Override
            public final boolean equals(Object var0) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{A.class, "pos;oldState", "pos", "oldState"}, this, var0);
            }

            public BlockPosition pos() {
                return this.pos;
            }

            public IBlockData oldState() {
                return this.oldState;
            }
        }
        int var7;
        int var6 = var1.getXSpan() * var1.getYSpan() * var1.getZSpan();
        if (var6 > (var7 = var0.getLevel().getGameRules().getInt(GameRules.RULE_COMMAND_MODIFICATION_BLOCK_LIMIT))) {
            throw ERROR_AREA_TOO_LARGE.create((Object)var7, (Object)var6);
        }
        ArrayList var8 = Lists.newArrayList();
        WorldServer var9 = var0.getLevel();
        if (var9.isDebug()) {
            throw ERROR_FAILED.create();
        }
        int var10 = 0;
        for (BlockPosition blockPosition : BlockPosition.betweenClosed(var1.minX(), var1.minY(), var1.minZ(), var1.maxX(), var1.maxY(), var1.maxZ())) {
            ArgumentTileLocation var15;
            if (var4 != null && !var4.test(new ShapeDetectorBlock(var9, blockPosition, true))) continue;
            IBlockData var13 = var9.getBlockState(blockPosition);
            boolean var14 = false;
            if (var3.affector.affect(var9, blockPosition)) {
                var14 = true;
            }
            if ((var15 = var3.filter.filter(var1, blockPosition, var2, var9)) == null) {
                if (!var14) continue;
                ++var10;
                continue;
            }
            if (!var15.place(var9, blockPosition, 2 | (var5 ? 816 : 256))) {
                if (!var14) continue;
                ++var10;
                continue;
            }
            if (!var5) {
                var8.add(new A(blockPosition.immutable(), var13));
            }
            ++var10;
        }
        for (A a2 : var8) {
            var9.updateNeighboursOnBlockSet(a2.pos, a2.oldState);
        }
        if (var10 == 0) {
            throw ERROR_FAILED.create();
        }
        int var11 = var10;
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.fill.success", var11), true);
        return var10;
    }

    @FunctionalInterface
    static interface e<T, R> {
        @Nullable
        public R apply(T var1) throws CommandSyntaxException;
    }

    static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode REPLACE = new Mode(b.NOOP, c.NOOP);
        public static final /* enum */ Mode OUTLINE = new Mode(b.NOOP, (var0, var1, var2, var3) -> {
            if (var1.getX() == var0.minX() || var1.getX() == var0.maxX() || var1.getY() == var0.minY() || var1.getY() == var0.maxY() || var1.getZ() == var0.minZ() || var1.getZ() == var0.maxZ()) {
                return var2;
            }
            return null;
        });
        public static final /* enum */ Mode HOLLOW = new Mode(b.NOOP, (var0, var1, var2, var3) -> {
            if (var1.getX() == var0.minX() || var1.getX() == var0.maxX() || var1.getY() == var0.minY() || var1.getY() == var0.maxY() || var1.getZ() == var0.minZ() || var1.getZ() == var0.maxZ()) {
                return var2;
            }
            return HOLLOW_CORE;
        });
        public static final /* enum */ Mode DESTROY = new Mode((var0, var1) -> var0.destroyBlock(var1, true), c.NOOP);
        public final c filter;
        public final b affector;
        private static final /* synthetic */ Mode[] g;

        public static Mode[] values() {
            return (Mode[])g.clone();
        }

        public static Mode valueOf(String var0) {
            return Enum.valueOf(Mode.class, var0);
        }

        private Mode(b var2, c var3) {
            this.affector = var2;
            this.filter = var3;
        }

        private static /* synthetic */ Mode[] a() {
            return new Mode[]{REPLACE, OUTLINE, HOLLOW, DESTROY};
        }

        static {
            g = Mode.a();
        }
    }

    @FunctionalInterface
    public static interface b {
        public static final b NOOP = (var0, var1) -> false;

        public boolean affect(WorldServer var1, BlockPosition var2);
    }

    @FunctionalInterface
    public static interface c {
        public static final c NOOP = (var0, var1, var2, var3) -> var2;

        @Nullable
        public ArgumentTileLocation filter(StructureBoundingBox var1, BlockPosition var2, ArgumentTileLocation var3, WorldServer var4);
    }
}

