/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.ReadTimeoutException;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.jsonrpc.IncomingRpcMethod;
import net.minecraft.server.jsonrpc.JsonRPCErrors;
import net.minecraft.server.jsonrpc.JsonRPCUtils;
import net.minecraft.server.jsonrpc.JsonRpcLogger;
import net.minecraft.server.jsonrpc.ManagementServer;
import net.minecraft.server.jsonrpc.OutgoingRpcMethod;
import net.minecraft.server.jsonrpc.PendingRpcRequest;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.jsonrpc.methods.EncodeJsonRpcException;
import net.minecraft.server.jsonrpc.methods.InvalidParameterJsonRpcException;
import net.minecraft.server.jsonrpc.methods.InvalidRequestJsonRpcException;
import net.minecraft.server.jsonrpc.methods.MethodNotFoundJsonRpcException;
import net.minecraft.server.jsonrpc.methods.RemoteRpcErrorException;
import net.minecraft.util.ChatDeserializer;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;

public class Connection
extends SimpleChannelInboundHandler<JsonElement> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final AtomicInteger CONNECTION_ID_COUNTER = new AtomicInteger(0);
    private final JsonRpcLogger jsonRpcLogger;
    private final ClientInfo clientInfo;
    private final ManagementServer managementServer;
    private final Channel channel;
    private final MinecraftApi minecraftApi;
    private final AtomicInteger transactionId = new AtomicInteger();
    private final Int2ObjectMap<PendingRpcRequest<?>> pendingRequests = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectOpenHashMap());

    public Connection(Channel var0, ManagementServer var1, MinecraftApi var2, JsonRpcLogger var3) {
        this.clientInfo = ClientInfo.of(CONNECTION_ID_COUNTER.incrementAndGet());
        this.managementServer = var1;
        this.minecraftApi = var2;
        this.channel = var0;
        this.jsonRpcLogger = var3;
    }

    public void tick() {
        long var0 = SystemUtils.getMillis();
        this.pendingRequests.int2ObjectEntrySet().removeIf(var2 -> {
            boolean var3 = ((PendingRpcRequest)var2.getValue()).timedOut(var0);
            if (var3) {
                ((PendingRpcRequest)var2.getValue()).resultFuture().completeExceptionally((Throwable)new ReadTimeoutException("RPC method " + String.valueOf(((PendingRpcRequest)var2.getValue()).method().key().location()) + " timed out waiting for response"));
            }
            return var3;
        });
    }

    public void channelActive(ChannelHandlerContext var0) throws Exception {
        this.jsonRpcLogger.log(this.clientInfo, "Management connection opened for {}", this.channel.remoteAddress());
        super.channelActive(var0);
        this.managementServer.onConnected(this);
    }

    public void channelInactive(ChannelHandlerContext var0) throws Exception {
        this.jsonRpcLogger.log(this.clientInfo, "Management connection closed for {}", this.channel.remoteAddress());
        super.channelInactive(var0);
        this.managementServer.onDisconnected(this);
    }

    public void exceptionCaught(ChannelHandlerContext var0, Throwable var1) throws Exception {
        if (var1.getCause() instanceof JsonParseException) {
            this.channel.writeAndFlush((Object)JsonRPCErrors.PARSE_ERROR.createWithUnknownId(var1.getMessage()));
            return;
        }
        super.exceptionCaught(var0, var1);
        this.channel.close().awaitUninterruptibly();
    }

    protected void channelRead0(ChannelHandlerContext var0, JsonElement var1) {
        if (var1.isJsonObject()) {
            JsonObject var2 = this.handleJsonObject(var1.getAsJsonObject());
            if (var2 != null) {
                this.channel.writeAndFlush((Object)var2);
            }
        } else if (var1.isJsonArray()) {
            this.channel.writeAndFlush((Object)this.handleBatchRequest(var1.getAsJsonArray().asList()));
        } else {
            this.channel.writeAndFlush((Object)JsonRPCErrors.INVALID_REQUEST.createWithUnknownId(null));
        }
    }

    private JsonArray handleBatchRequest(List<JsonElement> var02) {
        JsonArray var1 = new JsonArray();
        var02.stream().map(var0 -> this.handleJsonObject(var0.getAsJsonObject())).filter(Objects::nonNull).forEach(arg_0 -> ((JsonArray)var1).add(arg_0));
        return var1;
    }

    public void sendNotification(Holder.c<? extends OutgoingRpcMethod<Void, ?>> var0) {
        this.sendRequest(var0, null, false);
    }

    public <Params> void sendNotification(Holder.c<? extends OutgoingRpcMethod<Params, ?>> var0, Params var1) {
        this.sendRequest(var0, var1, false);
    }

    public <Result> CompletableFuture<Result> sendRequest(Holder.c<? extends OutgoingRpcMethod<Void, Result>> var0) {
        return this.sendRequest(var0, null, true);
    }

    public <Params, Result> CompletableFuture<Result> sendRequest(Holder.c<? extends OutgoingRpcMethod<Params, Result>> var0, Params var1) {
        return this.sendRequest(var0, var1, true);
    }

    @Nullable
    @Contract(value="_,_,false->null;_,_,true->!null")
    private <Params, Result> CompletableFuture<Result> sendRequest(Holder.c<? extends OutgoingRpcMethod<Params, ? extends Result>> var0, @Nullable Params var1, boolean var2) {
        List<JsonElement> var3;
        List<JsonElement> list = var3 = var1 != null ? List.of(Objects.requireNonNull(var0.value().encodeParams(var1))) : List.of();
        if (var2) {
            CompletableFuture var4 = new CompletableFuture();
            int var5 = this.transactionId.incrementAndGet();
            long var6 = SystemUtils.timeSource.get(TimeUnit.MILLISECONDS);
            this.pendingRequests.put(var5, new PendingRpcRequest(var0, var4, var6 + 5000L));
            this.channel.writeAndFlush((Object)JsonRPCUtils.createRequest(var5, var0.key().location(), var3));
            return var4;
        }
        this.channel.writeAndFlush((Object)JsonRPCUtils.createRequest(null, var0.key().location(), var3));
        return null;
    }

    @Nullable
    @VisibleForTesting
    JsonObject handleJsonObject(JsonObject var0) {
        try {
            JsonElement var1 = JsonRPCUtils.getRequestId(var0);
            String var2 = JsonRPCUtils.getMethodName(var0);
            JsonElement var3 = JsonRPCUtils.getResult(var0);
            JsonElement var4 = JsonRPCUtils.getParams(var0);
            JsonObject var5 = JsonRPCUtils.getError(var0);
            if (var2 != null && var3 == null && var5 == null) {
                if (var1 != null && !Connection.isValidRequestId(var1)) {
                    return JsonRPCErrors.INVALID_REQUEST.createWithUnknownId("Invalid request id - only String, Number and NULL supported");
                }
                return this.handleIncomingRequest(var1, var2, var4);
            }
            if (var2 == null && var3 != null && var5 == null && var1 != null) {
                if (Connection.isValidResponseId(var1)) {
                    this.handleRequestResponse(var1.getAsInt(), var3);
                } else {
                    LOGGER.warn("Received respose {} with id {} we did not request", (Object)var3, (Object)var1);
                }
                return null;
            }
            if (var2 == null && var3 == null && var5 != null) {
                return this.handleError(var1, var5);
            }
            return JsonRPCErrors.INVALID_REQUEST.createWithoutData((JsonElement)Objects.requireNonNullElse(var1, JsonNull.INSTANCE));
        }
        catch (Exception var1) {
            LOGGER.error("Error while handling rpc request", (Throwable)var1);
            return JsonRPCErrors.INTERNAL_ERROR.createWithUnknownId("Unknown error handling request - check server logs for stack trace");
        }
    }

    private static boolean isValidRequestId(JsonElement var0) {
        return var0.isJsonNull() || ChatDeserializer.isNumberValue(var0) || ChatDeserializer.isStringValue(var0);
    }

    private static boolean isValidResponseId(JsonElement var0) {
        return ChatDeserializer.isNumberValue(var0);
    }

    @Nullable
    private JsonObject handleIncomingRequest(@Nullable JsonElement var0, String var1, @Nullable JsonElement var2) {
        boolean var3 = var0 != null;
        try {
            JsonElement var4 = this.dispatchIncomingRequest(var1, var2);
            if (var4 == null || !var3) {
                return null;
            }
            return JsonRPCUtils.createSuccessResult(var0, var4);
        }
        catch (InvalidParameterJsonRpcException var4) {
            LOGGER.debug("Invalid parameter invocation {}: {}, {}", new Object[]{var1, var2, var4.getMessage()});
            return var3 ? JsonRPCErrors.INVALID_PARAMS.create(var0, var4.getMessage()) : null;
        }
        catch (EncodeJsonRpcException var4) {
            LOGGER.error("Failed to encode json rpc response {}: {}", (Object)var1, (Object)var4.getMessage());
            return var3 ? JsonRPCErrors.INTERNAL_ERROR.create(var0, var4.getMessage()) : null;
        }
        catch (InvalidRequestJsonRpcException var4) {
            return var3 ? JsonRPCErrors.INVALID_REQUEST.create(var0, var4.getMessage()) : null;
        }
        catch (MethodNotFoundJsonRpcException var4) {
            return var3 ? JsonRPCErrors.METHOD_NOT_FOUND.create(var0, var4.getMessage()) : null;
        }
        catch (Exception var4) {
            LOGGER.error("Error while dispatching rpc method {}", (Object)var1, (Object)var4);
            return var3 ? JsonRPCErrors.INTERNAL_ERROR.createWithoutData(var0) : null;
        }
    }

    @Nullable
    public JsonElement dispatchIncomingRequest(String var0, @Nullable JsonElement var1) {
        MinecraftKey var2 = MinecraftKey.tryParse(var0);
        if (var2 == null) {
            throw new InvalidRequestJsonRpcException("Failed to parse method value: " + var0);
        }
        Optional<IncomingRpcMethod> var3 = BuiltInRegistries.INCOMING_RPC_METHOD.getOptional(var2);
        if (var3.isEmpty()) {
            throw new MethodNotFoundJsonRpcException("Method not found: " + var0);
        }
        if (var3.get().attributes().runOnMainThread()) {
            try {
                return this.minecraftApi.submit(() -> ((IncomingRpcMethod)var3.get()).apply(this.minecraftApi, var1, this.clientInfo)).join();
            }
            catch (CompletionException var4) {
                Throwable throwable = var4.getCause();
                if (throwable instanceof RuntimeException) {
                    RuntimeException var5 = (RuntimeException)throwable;
                    throw var5;
                }
                throw var4;
            }
        }
        return var3.get().apply(this.minecraftApi, var1, this.clientInfo);
    }

    private void handleRequestResponse(int var0, JsonElement var1) {
        PendingRpcRequest var2 = (PendingRpcRequest)this.pendingRequests.remove(var0);
        if (var2 == null) {
            LOGGER.warn("Received unknown response (id: {}): {}", (Object)var0, (Object)var1);
        } else {
            var2.accept(var1);
        }
    }

    @Nullable
    private JsonObject handleError(@Nullable JsonElement var0, JsonObject var1) {
        PendingRpcRequest var2;
        if (var0 != null && Connection.isValidResponseId(var0) && (var2 = (PendingRpcRequest)this.pendingRequests.remove(var0.getAsInt())) != null) {
            var2.resultFuture().completeExceptionally(new RemoteRpcErrorException(var0, var1));
        }
        LOGGER.error("Received error (id: {}): {}", (Object)var0, (Object)var1);
        return null;
    }

    protected /* synthetic */ void channelRead0(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        this.channelRead0(channelHandlerContext, (JsonElement)object);
    }
}

