/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.internalapi;

import java.util.Collection;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.jsonrpc.JsonRpcLogger;
import net.minecraft.server.jsonrpc.internalapi.MinecraftAllowListService;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.WhiteListEntry;

public class MinecraftAllowListServiceImpl
implements MinecraftAllowListService {
    private final DedicatedServer server;
    private final JsonRpcLogger jsonrpcLogger;

    public MinecraftAllowListServiceImpl(DedicatedServer var0, JsonRpcLogger var1) {
        this.server = var0;
        this.jsonrpcLogger = var1;
    }

    @Override
    public Collection<WhiteListEntry> getEntries() {
        return this.server.getPlayerList().getWhiteList().getEntries();
    }

    @Override
    public boolean add(WhiteListEntry var0, ClientInfo var1) {
        this.jsonrpcLogger.log(var1, "Add player '{}' to allowlist", var0.getUser());
        return this.server.getPlayerList().getWhiteList().add(var0);
    }

    @Override
    public void clear(ClientInfo var0) {
        this.jsonrpcLogger.log(var0, "Clear allowlist", new Object[0]);
        this.server.getPlayerList().getWhiteList().clear();
    }

    @Override
    public void remove(NameAndId var0, ClientInfo var1) {
        this.jsonrpcLogger.log(var1, "Remove player '{}' from allowlist", var0);
        this.server.getPlayerList().getWhiteList().remove(var0);
    }

    @Override
    public void kickUnlistedPlayers(ClientInfo var0) {
        this.jsonrpcLogger.log(var0, "Kick unlisted players", new Object[0]);
        this.server.kickUnlistedPlayers();
    }
}

