/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.metadata.pack.PackFormat;
import net.minecraft.util.InclusiveRange;

public record OverlayMetadataSection(List<a> overlays) {
    private static final Pattern DIR_VALIDATOR = Pattern.compile("[-_a-zA-Z0-9.]+");
    public static final MetadataSectionType<OverlayMetadataSection> CLIENT_TYPE = new MetadataSectionType<OverlayMetadataSection>("overlays", OverlayMetadataSection.codecForPackType(EnumResourcePackType.CLIENT_RESOURCES));
    public static final MetadataSectionType<OverlayMetadataSection> SERVER_TYPE = new MetadataSectionType<OverlayMetadataSection>("overlays", OverlayMetadataSection.codecForPackType(EnumResourcePackType.SERVER_DATA));

    private static DataResult<String> validateOverlayDir(String var0) {
        if (!DIR_VALIDATOR.matcher(var0).matches()) {
            return DataResult.error(() -> var0 + " is not accepted directory name");
        }
        return DataResult.success((Object)var0);
    }

    @VisibleForTesting
    public static Codec<OverlayMetadataSection> codecForPackType(EnumResourcePackType var0) {
        return RecordCodecBuilder.create(var1 -> var1.group((App)a.listCodecForPackType(var0).fieldOf("entries").forGetter(OverlayMetadataSection::overlays)).apply((Applicative)var1, OverlayMetadataSection::new));
    }

    public static MetadataSectionType<OverlayMetadataSection> forPackType(EnumResourcePackType var0) {
        return switch (var0) {
            default -> throw new MatchException(null, null);
            case EnumResourcePackType.CLIENT_RESOURCES -> CLIENT_TYPE;
            case EnumResourcePackType.SERVER_DATA -> SERVER_TYPE;
        };
    }

    public List<String> overlaysForVersion(PackFormat var0) {
        return this.overlays.stream().filter(var1 -> var1.isApplicable(var0)).map(a::overlay).toList();
    }

    public record net.minecraft.server.packs.OverlayMetadataSection$a(InclusiveRange<PackFormat> format, String overlay) {
        static Codec<List<net.minecraft.server.packs.OverlayMetadataSection$a>> listCodecForPackType(EnumResourcePackType var0) {
            int var1 = PackFormat.lastPreMinorVersion(var0);
            return a.CODEC.listOf().flatXmap(var12 -> PackFormat.validateHolderList(var12, var1, (var0, var1) -> new net.minecraft.server.packs.OverlayMetadataSection$a((InclusiveRange<PackFormat>)var1, var0.overlay())), var12 -> DataResult.success(var12.stream().map(var1 -> new a(PackFormat.a.fromRange(var1.format(), var1), var1.overlay())).toList()));
        }

        public boolean isApplicable(PackFormat var0) {
            return this.format.isValueInRange(var0);
        }

        record a(PackFormat.a format, String overlay) implements PackFormat.b
        {
            static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)PackFormat.a.OVERLAY_CODEC.forGetter(a::format), (App)Codec.STRING.validate(OverlayMetadataSection::validateOverlayDir).fieldOf("directory").forGetter(a::overlay)).apply((Applicative)var0, a::new));

            @Override
            public String toString() {
                return this.overlay;
            }
        }
    }
}

