/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackSource;
import net.minecraft.world.flag.FeatureFlagSet;

public class ResourcePackRepository {
    private final Set<ResourcePackSource> sources;
    private Map<String, ResourcePackLoader> available = ImmutableMap.of();
    private List<ResourcePackLoader> selected = ImmutableList.of();

    public ResourcePackRepository(ResourcePackSource ... var0) {
        this.sources = ImmutableSet.copyOf((Object[])var0);
    }

    public static String displayPackList(Collection<ResourcePackLoader> var02) {
        return var02.stream().map(var0 -> var0.getId() + (var0.getCompatibility().isCompatible() ? "" : " (incompatible)")).collect(Collectors.joining(", "));
    }

    public void reload() {
        List var0 = (List)this.selected.stream().map(ResourcePackLoader::getId).collect(ImmutableList.toImmutableList());
        this.available = this.discoverAvailable();
        this.selected = this.rebuildSelected(var0);
    }

    private Map<String, ResourcePackLoader> discoverAvailable() {
        TreeMap var0 = Maps.newTreeMap();
        for (ResourcePackSource var2 : this.sources) {
            var2.loadPacks(var1 -> var0.put(var1.getId(), var1));
        }
        return ImmutableMap.copyOf((Map)var0);
    }

    public boolean isAbleToClearAnyPack() {
        List<ResourcePackLoader> var0 = this.rebuildSelected(List.of());
        return !this.selected.equals(var0);
    }

    public void setSelected(Collection<String> var0) {
        this.selected = this.rebuildSelected(var0);
    }

    public boolean addPack(String var0) {
        ResourcePackLoader var1 = this.available.get(var0);
        if (var1 != null && !this.selected.contains(var1)) {
            ArrayList var2 = Lists.newArrayList(this.selected);
            var2.add(var1);
            this.selected = var2;
            return true;
        }
        return false;
    }

    public boolean removePack(String var0) {
        ResourcePackLoader var1 = this.available.get(var0);
        if (var1 != null && this.selected.contains(var1)) {
            ArrayList var2 = Lists.newArrayList(this.selected);
            var2.remove(var1);
            this.selected = var2;
            return true;
        }
        return false;
    }

    private List<ResourcePackLoader> rebuildSelected(Collection<String> var0) {
        List var1 = this.getAvailablePacks(var0).collect(SystemUtils.toMutableList());
        for (ResourcePackLoader var3 : this.available.values()) {
            if (!var3.isRequired() || var1.contains(var3)) continue;
            var3.getDefaultPosition().insert(var1, var3, ResourcePackLoader::selectionConfig, false);
        }
        return ImmutableList.copyOf(var1);
    }

    private Stream<ResourcePackLoader> getAvailablePacks(Collection<String> var0) {
        return var0.stream().map(this.available::get).filter(Objects::nonNull);
    }

    public Collection<String> getAvailableIds() {
        return this.available.keySet();
    }

    public Collection<ResourcePackLoader> getAvailablePacks() {
        return this.available.values();
    }

    public Collection<String> getSelectedIds() {
        return (Collection)this.selected.stream().map(ResourcePackLoader::getId).collect(ImmutableSet.toImmutableSet());
    }

    public FeatureFlagSet getRequestedFeatureFlags() {
        return this.getSelectedPacks().stream().map(ResourcePackLoader::getRequestedFeatures).reduce(FeatureFlagSet::join).orElse(FeatureFlagSet.of());
    }

    public Collection<ResourcePackLoader> getSelectedPacks() {
        return this.selected;
    }

    @Nullable
    public ResourcePackLoader getPack(String var0) {
        return this.available.get(var0);
    }

    public boolean isAvailable(String var0) {
        return this.available.containsKey(var0);
    }

    public List<IResourcePack> openAllSelected() {
        return (List)this.selected.stream().map(ResourcePackLoader::open).collect(ImmutableList.toImmutableList());
    }
}

