/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.IRegistry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.stats.Counter;
import net.minecraft.stats.Statistic;

public class StatisticWrapper<T>
implements Iterable<Statistic<T>> {
    private final IRegistry<T> registry;
    private final Map<T, Statistic<T>> map = new IdentityHashMap<T, Statistic<T>>();
    private final IChatBaseComponent displayName;
    private final StreamCodec<RegistryFriendlyByteBuf, Statistic<T>> streamCodec;

    public StatisticWrapper(IRegistry<T> var0, IChatBaseComponent var1) {
        this.registry = var0;
        this.displayName = var1;
        this.streamCodec = ByteBufCodecs.registry(var0.key()).map(this::get, Statistic::getValue);
    }

    public StreamCodec<RegistryFriendlyByteBuf, Statistic<T>> streamCodec() {
        return this.streamCodec;
    }

    public boolean contains(T var0) {
        return this.map.containsKey(var0);
    }

    public Statistic<T> get(T var0, Counter var12) {
        return this.map.computeIfAbsent(var0, var1 -> new Statistic<Object>(this, var1, var12));
    }

    public IRegistry<T> getRegistry() {
        return this.registry;
    }

    @Override
    public Iterator<Statistic<T>> iterator() {
        return this.map.values().iterator();
    }

    public Statistic<T> get(T var0) {
        return this.get(var0, Counter.DEFAULT);
    }

    public IChatBaseComponent getDisplayName() {
        return this.displayName;
    }
}

