/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.SystemUtils;

public class ClassTreeIdRegistry {
    public static final int NO_ID_VALUE = -1;
    private final Object2IntMap<Class<?>> classToLastIdCache = (Object2IntMap)SystemUtils.make(new Object2IntOpenHashMap(), var0 -> var0.defaultReturnValue(-1));

    public int getLastIdFor(Class<?> var0) {
        int var1 = this.classToLastIdCache.getInt(var0);
        if (var1 != -1) {
            return var1;
        }
        Class<?> var2 = var0;
        while ((var2 = var2.getSuperclass()) != Object.class) {
            int var3 = this.classToLastIdCache.getInt(var2);
            if (var3 == -1) continue;
            return var3;
        }
        return -1;
    }

    public int getCount(Class<?> var0) {
        return this.getLastIdFor(var0) + 1;
    }

    public int define(Class<?> var0) {
        int var1 = this.getLastIdFor(var0);
        int var2 = var1 == -1 ? 0 : var1 + 1;
        this.classToLastIdCache.put(var0, var2);
        return var2;
    }
}

