/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;

public class Avatar
extends EntityLiving {
    public static final EnumMainHand DEFAULT_MAIN_HAND = EnumMainHand.RIGHT;
    public static final int DEFAULT_MODEL_CUSTOMIZATION = 0;
    public static final float DEFAULT_EYE_HEIGHT = 1.62f;
    public static final Vec3D DEFAULT_VEHICLE_ATTACHMENT = new Vec3D(0.0, 0.6, 0.0);
    private static final float CROUCH_BB_HEIGHT = 1.5f;
    private static final float SWIMMING_BB_WIDTH = 0.6f;
    public static final float SWIMMING_BB_HEIGHT = 0.6f;
    protected static final EntitySize STANDING_DIMENSIONS = EntitySize.scalable(0.6f, 1.8f).withEyeHeight(1.62f).withAttachments(EntityAttachments.builder().attach(EntityAttachment.VEHICLE, DEFAULT_VEHICLE_ATTACHMENT));
    protected static final Map<EntityPose, EntitySize> POSES = ImmutableMap.builder().put((Object)EntityPose.STANDING, (Object)STANDING_DIMENSIONS).put((Object)EntityPose.SLEEPING, (Object)SLEEPING_DIMENSIONS).put((Object)EntityPose.FALL_FLYING, (Object)EntitySize.scalable(0.6f, 0.6f).withEyeHeight(0.4f)).put((Object)EntityPose.SWIMMING, (Object)EntitySize.scalable(0.6f, 0.6f).withEyeHeight(0.4f)).put((Object)EntityPose.SPIN_ATTACK, (Object)EntitySize.scalable(0.6f, 0.6f).withEyeHeight(0.4f)).put((Object)EntityPose.CROUCHING, (Object)EntitySize.scalable(0.6f, 1.5f).withEyeHeight(1.27f).withAttachments(EntityAttachments.builder().attach(EntityAttachment.VEHICLE, DEFAULT_VEHICLE_ATTACHMENT))).put((Object)EntityPose.DYING, (Object)EntitySize.fixed(0.2f, 0.2f).withEyeHeight(1.62f)).build();
    protected static final DataWatcherObject<Byte> DATA_PLAYER_MAIN_HAND = DataWatcher.defineId(Avatar.class, DataWatcherRegistry.BYTE);
    public static final DataWatcherObject<Byte> DATA_PLAYER_MODE_CUSTOMISATION = DataWatcher.defineId(Avatar.class, DataWatcherRegistry.BYTE);

    protected Avatar(EntityTypes<? extends EntityLiving> var0, World var1) {
        super(var0, var1);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_PLAYER_MAIN_HAND, (byte)DEFAULT_MAIN_HAND.getId());
        var0.define(DATA_PLAYER_MODE_CUSTOMISATION, (byte)0);
    }

    @Override
    public EnumMainHand getMainArm() {
        return this.entityData.get(DATA_PLAYER_MAIN_HAND) == 0 ? EnumMainHand.LEFT : EnumMainHand.RIGHT;
    }

    public void setMainArm(EnumMainHand var0) {
        this.entityData.set(DATA_PLAYER_MAIN_HAND, (byte)(var0 != EnumMainHand.LEFT ? 1 : 0));
    }

    public boolean isModelPartShown(PlayerModelPart var0) {
        return (this.getEntityData().get(DATA_PLAYER_MODE_CUSTOMISATION) & var0.getMask()) == var0.getMask();
    }

    @Override
    public EntitySize getDefaultDimensions(EntityPose var0) {
        return POSES.getOrDefault(var0, STANDING_DIMENSIONS);
    }
}

