/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.level.pathfinder.PathType;

public class PathfinderGoalFollowOwner
extends PathfinderGoal {
    private final EntityTameableAnimal tamable;
    @Nullable
    private EntityLiving owner;
    private final double speedModifier;
    private final NavigationAbstract navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float startDistance;
    private float oldWaterCost;

    public PathfinderGoalFollowOwner(EntityTameableAnimal var0, double var1, float var3, float var4) {
        this.tamable = var0;
        this.speedModifier = var1;
        this.navigation = var0.getNavigation();
        this.startDistance = var3;
        this.stopDistance = var4;
        this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.LOOK));
        if (!(var0.getNavigation() instanceof Navigation) && !(var0.getNavigation() instanceof NavigationFlying)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    @Override
    public boolean canUse() {
        EntityLiving var0 = this.tamable.getOwner();
        if (var0 == null) {
            return false;
        }
        if (this.tamable.unableToMoveToOwner()) {
            return false;
        }
        if (this.tamable.distanceToSqr(var0) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = var0;
        return true;
    }

    @Override
    public boolean canContinueToUse() {
        if (this.navigation.isDone()) {
            return false;
        }
        if (this.tamable.unableToMoveToOwner()) {
            return false;
        }
        return !(this.tamable.distanceToSqr(this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    @Override
    public void start() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.tamable.getPathfindingMalus(PathType.WATER);
        this.tamable.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    @Override
    public void stop() {
        this.owner = null;
        this.navigation.stop();
        this.tamable.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
    }

    @Override
    public void tick() {
        boolean var0 = this.tamable.shouldTryTeleportToOwner();
        if (!var0) {
            this.tamable.getLookControl().setLookAt(this.owner, 10.0f, this.tamable.getMaxHeadXRot());
        }
        if (--this.timeToRecalcPath > 0) {
            return;
        }
        this.timeToRecalcPath = this.adjustedTickDelay(10);
        if (var0) {
            this.tamable.tryToTeleportToOwner();
        } else {
            this.navigation.moveTo(this.owner, this.speedModifier);
        }
    }
}

