/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.navigation;

import net.minecraft.core.BlockPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderFlying;
import net.minecraft.world.phys.Vec3D;

public class NavigationFlying
extends NavigationAbstract {
    public NavigationFlying(EntityInsentient var0, World var1) {
        super(var0, var1);
    }

    @Override
    protected Pathfinder createPathFinder(int var0) {
        this.nodeEvaluator = new PathfinderFlying();
        return new Pathfinder(this.nodeEvaluator, var0);
    }

    @Override
    protected boolean canMoveDirectly(Vec3D var0, Vec3D var1) {
        return NavigationFlying.isClearForMovementBetween(this.mob, var0, var1, true);
    }

    @Override
    protected boolean canUpdatePath() {
        return this.canFloat() && this.mob.isInLiquid() || !this.mob.isPassenger();
    }

    @Override
    protected Vec3D getTempMobPos() {
        return this.mob.position();
    }

    @Override
    public PathEntity createPath(Entity var0, int var1) {
        return this.createPath(var0.blockPosition(), var1);
    }

    @Override
    public void tick() {
        Vec3D var0;
        ++this.tick;
        if (this.hasDelayedRecomputation) {
            this.recomputePath();
        }
        if (this.isDone()) {
            return;
        }
        if (this.canUpdatePath()) {
            this.followThePath();
        } else if (this.path != null && !this.path.isDone()) {
            var0 = this.path.getNextEntityPos(this.mob);
            if (this.mob.getBlockX() == MathHelper.floor(var0.x) && this.mob.getBlockY() == MathHelper.floor(var0.y) && this.mob.getBlockZ() == MathHelper.floor(var0.z)) {
                this.path.advance();
            }
        }
        if (this.isDone()) {
            return;
        }
        var0 = this.path.getNextEntityPos(this.mob);
        this.mob.getMoveControl().setWantedPosition(var0.x, var0.y, var0.z, this.speedModifier);
    }

    @Override
    public boolean isStableDestination(BlockPosition var0) {
        return this.level.getBlockState(var0).entityCanStandOn(this.level, var0, this.mob);
    }

    @Override
    public boolean canNavigateGround() {
        return false;
    }
}

