/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Optional;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.World;

public interface Bucketable {
    public boolean fromBucket();

    public void setFromBucket(boolean var1);

    public void saveToBucketTag(ItemStack var1);

    public void loadFromBucketTag(NBTTagCompound var1);

    public ItemStack getBucketItemStack();

    public SoundEffect getPickupSound();

    @Deprecated
    public static void saveDefaultDataToBucketTag(EntityInsentient var0, ItemStack var12) {
        var12.copyFrom(DataComponents.CUSTOM_NAME, var0);
        CustomData.update(DataComponents.BUCKET_ENTITY_DATA, var12, var1 -> {
            if (var0.isNoAi()) {
                var1.putBoolean("NoAI", var0.isNoAi());
            }
            if (var0.isSilent()) {
                var1.putBoolean("Silent", var0.isSilent());
            }
            if (var0.isNoGravity()) {
                var1.putBoolean("NoGravity", var0.isNoGravity());
            }
            if (var0.hasGlowingTag()) {
                var1.putBoolean("Glowing", var0.hasGlowingTag());
            }
            if (var0.isInvulnerable()) {
                var1.putBoolean("Invulnerable", var0.isInvulnerable());
            }
            var1.putFloat("Health", var0.getHealth());
        });
    }

    @Deprecated
    public static void loadDefaultDataFromBucketTag(EntityInsentient var0, NBTTagCompound var1) {
        var1.getBoolean("NoAI").ifPresent(var0::setNoAi);
        var1.getBoolean("Silent").ifPresent(var0::setSilent);
        var1.getBoolean("NoGravity").ifPresent(var0::setNoGravity);
        var1.getBoolean("Glowing").ifPresent(var0::setGlowingTag);
        var1.getBoolean("Invulnerable").ifPresent(var0::setInvulnerable);
        var1.getFloat("Health").ifPresent(var0::setHealth);
    }

    public static <T extends EntityLiving> Optional<EnumInteractionResult> bucketMobPickup(EntityHuman var0, EnumHand var1, T var2) {
        ItemStack var3 = var0.getItemInHand(var1);
        if (var3.getItem() == Items.WATER_BUCKET && var2.isAlive()) {
            var2.playSound(((Bucketable)((Object)var2)).getPickupSound(), 1.0f, 1.0f);
            ItemStack var4 = ((Bucketable)((Object)var2)).getBucketItemStack();
            ((Bucketable)((Object)var2)).saveToBucketTag(var4);
            ItemStack var5 = ItemLiquidUtil.createFilledResult(var3, var0, var4, false);
            var0.setItemInHand(var1, var5);
            World var6 = var2.level();
            if (!var6.isClientSide()) {
                CriterionTriggers.FILLED_BUCKET.trigger((EntityPlayer)var0, var4);
            }
            var2.discard();
            return Optional.of(EnumInteractionResult.SUCCESS);
        }
        return Optional.empty();
    }
}

