/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.animal.AgeableWaterCreature;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3D;

public class EntitySquid
extends AgeableWaterCreature {
    public float xBodyRot;
    public float xBodyRotO;
    public float zBodyRot;
    public float zBodyRotO;
    public float tentacleMovement;
    public float oldTentacleMovement;
    public float tentacleAngle;
    public float oldTentacleAngle;
    private float speed;
    private float tentacleSpeed;
    private float rotateSpeed;
    Vec3D movementVector = Vec3D.ZERO;

    public EntitySquid(EntityTypes<? extends EntitySquid> var0, World var1) {
        super((EntityTypes<? extends AgeableWaterCreature>)var0, var1);
        this.random.setSeed(this.getId());
        this.tentacleSpeed = 1.0f / (this.random.nextFloat() + 1.0f) * 0.2f;
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, new PathfinderGoalSquid(this));
        this.goalSelector.addGoal(1, new a());
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MAX_HEALTH, 10.0);
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.SQUID_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.SQUID_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.SQUID_DEATH;
    }

    protected SoundEffect getSquirtSound() {
        return SoundEffects.SQUID_SQUIRT;
    }

    @Override
    public boolean canBeLeashed() {
        return true;
    }

    @Override
    protected float getSoundVolume() {
        return 0.4f;
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    @Override
    @Nullable
    public EntityAgeable getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        return EntityTypes.SQUID.create(var0, EntitySpawnReason.BREEDING);
    }

    @Override
    protected double getDefaultGravity() {
        return 0.08;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        this.xBodyRotO = this.xBodyRot;
        this.zBodyRotO = this.zBodyRot;
        this.oldTentacleMovement = this.tentacleMovement;
        this.oldTentacleAngle = this.tentacleAngle;
        this.tentacleMovement += this.tentacleSpeed;
        if ((double)this.tentacleMovement > Math.PI * 2) {
            if (this.level().isClientSide()) {
                this.tentacleMovement = (float)Math.PI * 2;
            } else {
                this.tentacleMovement -= (float)Math.PI * 2;
                if (this.random.nextInt(10) == 0) {
                    this.tentacleSpeed = 1.0f / (this.random.nextFloat() + 1.0f) * 0.2f;
                }
                this.level().broadcastEntityEvent(this, (byte)19);
            }
        }
        if (this.isInWater()) {
            if (this.tentacleMovement < (float)Math.PI) {
                float var0 = this.tentacleMovement / (float)Math.PI;
                this.tentacleAngle = MathHelper.sin(var0 * var0 * (float)Math.PI) * (float)Math.PI * 0.25f;
                if ((double)var0 > 0.75) {
                    if (this.isLocalInstanceAuthoritative()) {
                        this.setDeltaMovement(this.movementVector);
                    }
                    this.rotateSpeed = 1.0f;
                } else {
                    this.rotateSpeed *= 0.8f;
                }
            } else {
                this.tentacleAngle = 0.0f;
                if (this.isLocalInstanceAuthoritative()) {
                    this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
                }
                this.rotateSpeed *= 0.99f;
            }
            Vec3D var0 = this.getDeltaMovement();
            double var1 = var0.horizontalDistance();
            this.yBodyRot += (-((float)MathHelper.atan2(var0.x, var0.z)) * 57.295776f - this.yBodyRot) * 0.1f;
            this.setYRot(this.yBodyRot);
            this.zBodyRot += (float)Math.PI * this.rotateSpeed * 1.5f;
            this.xBodyRot += (-((float)MathHelper.atan2(var1, var0.y)) * 57.295776f - this.xBodyRot) * 0.1f;
        } else {
            this.tentacleAngle = MathHelper.abs(MathHelper.sin(this.tentacleMovement)) * (float)Math.PI * 0.25f;
            if (!this.level().isClientSide()) {
                double var0 = this.getDeltaMovement().y;
                var0 = this.hasEffect(MobEffects.LEVITATION) ? 0.05 * (double)(this.getEffect(MobEffects.LEVITATION).getAmplifier() + 1) : (var0 -= this.getGravity());
                this.setDeltaMovement(0.0, var0 * (double)0.98f, 0.0);
            }
            this.xBodyRot += (-90.0f - this.xBodyRot) * 0.02f;
        }
    }

    @Override
    public boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        if (super.hurtServer(var0, var1, var2) && this.getLastHurtByMob() != null) {
            this.spawnInk();
            return true;
        }
        return false;
    }

    private Vec3D rotateVector(Vec3D var0) {
        Vec3D var1 = var0.xRot(this.xBodyRotO * ((float)Math.PI / 180));
        var1 = var1.yRot(-this.yBodyRotO * ((float)Math.PI / 180));
        return var1;
    }

    private void spawnInk() {
        this.makeSound(this.getSquirtSound());
        Vec3D var0 = this.rotateVector(new Vec3D(0.0, -1.0, 0.0)).add(this.getX(), this.getY(), this.getZ());
        for (int var1 = 0; var1 < 30; ++var1) {
            Vec3D var2 = this.rotateVector(new Vec3D((double)this.random.nextFloat() * 0.6 - 0.3, -1.0, (double)this.random.nextFloat() * 0.6 - 0.3));
            float var3 = this.isBaby() ? 0.1f : 0.3f;
            Vec3D var4 = var2.scale(var3 + this.random.nextFloat() * 2.0f);
            ((WorldServer)this.level()).sendParticles(this.getInkParticle(), var0.x, var0.y + 0.5, var0.z, 0, var4.x, var4.y, var4.z, 0.1f);
        }
    }

    protected ParticleParam getInkParticle() {
        return Particles.SQUID_INK;
    }

    @Override
    public void travel(Vec3D var0) {
        this.move(EnumMoveType.SELF, this.getDeltaMovement());
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 19) {
            this.tentacleMovement = 0.0f;
        } else {
            super.handleEntityEvent(var0);
        }
    }

    public boolean hasMovementVector() {
        return this.movementVector.lengthSqr() > (double)1.0E-5f;
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        GroupDataEntity var4 = Objects.requireNonNullElseGet(var3, () -> new EntityAgeable.a(0.05f));
        return super.finalizeSpawn(var0, var1, var2, var4);
    }

    static class PathfinderGoalSquid
    extends PathfinderGoal {
        private final EntitySquid squid;

        public PathfinderGoalSquid(EntitySquid var0) {
            this.squid = var0;
        }

        @Override
        public boolean canUse() {
            return true;
        }

        @Override
        public void tick() {
            int var0 = this.squid.getNoActionTime();
            if (var0 > 100) {
                this.squid.movementVector = Vec3D.ZERO;
            } else if (this.squid.getRandom().nextInt(PathfinderGoalSquid.reducedTickDelay(50)) == 0 || !this.squid.wasTouchingWater || !this.squid.hasMovementVector()) {
                float var1 = this.squid.getRandom().nextFloat() * ((float)Math.PI * 2);
                this.squid.movementVector = new Vec3D(MathHelper.cos(var1) * 0.2f, -0.1f + this.squid.getRandom().nextFloat() * 0.2f, MathHelper.sin(var1) * 0.2f);
            }
        }
    }

    class a
    extends PathfinderGoal {
        private static final float SQUID_FLEE_SPEED = 3.0f;
        private static final float SQUID_FLEE_MIN_DISTANCE = 5.0f;
        private static final float SQUID_FLEE_MAX_DISTANCE = 10.0f;
        private int fleeTicks;

        a() {
        }

        @Override
        public boolean canUse() {
            EntityLiving var0 = EntitySquid.this.getLastHurtByMob();
            if (EntitySquid.this.isInWater() && var0 != null) {
                return EntitySquid.this.distanceToSqr(var0) < 100.0;
            }
            return false;
        }

        @Override
        public void start() {
            this.fleeTicks = 0;
        }

        @Override
        public boolean requiresUpdateEveryTick() {
            return true;
        }

        @Override
        public void tick() {
            ++this.fleeTicks;
            EntityLiving var0 = EntitySquid.this.getLastHurtByMob();
            if (var0 == null) {
                return;
            }
            Vec3D var1 = new Vec3D(EntitySquid.this.getX() - var0.getX(), EntitySquid.this.getY() - var0.getY(), EntitySquid.this.getZ() - var0.getZ());
            IBlockData var2 = EntitySquid.this.level().getBlockState(BlockPosition.containing(EntitySquid.this.getX() + var1.x, EntitySquid.this.getY() + var1.y, EntitySquid.this.getZ() + var1.z));
            Fluid var3 = EntitySquid.this.level().getFluidState(BlockPosition.containing(EntitySquid.this.getX() + var1.x, EntitySquid.this.getY() + var1.y, EntitySquid.this.getZ() + var1.z));
            if (var3.is(TagsFluid.WATER) || var2.isAir()) {
                double var4 = var1.length();
                if (var4 > 0.0) {
                    var1.normalize();
                    double var6 = 3.0;
                    if (var4 > 5.0) {
                        var6 -= (var4 - 5.0) / 5.0;
                    }
                    if (var6 > 0.0) {
                        var1 = var1.scale(var6);
                    }
                }
                if (var2.isAir()) {
                    var1 = var1.subtract(0.0, var1.y, 0.0);
                }
                EntitySquid.this.movementVector = new Vec3D(var1.x / 20.0, var1.y / 20.0, var1.z / 20.0);
            }
            if (this.fleeTicks % 10 == 5) {
                EntitySquid.this.level().addParticle(Particles.BUBBLE, EntitySquid.this.getX(), EntitySquid.this.getY(), EntitySquid.this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }
}

