/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.camel;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.camel.CamelAi;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;

public class Camel
extends EntityHorseAbstract {
    public static final float BABY_SCALE = 0.45f;
    public static final int DASH_COOLDOWN_TICKS = 55;
    public static final int MAX_HEAD_Y_ROT = 30;
    private static final float RUNNING_SPEED_BONUS = 0.1f;
    private static final float DASH_VERTICAL_MOMENTUM = 1.4285f;
    private static final float DASH_HORIZONTAL_MOMENTUM = 22.2222f;
    private static final int DASH_MINIMUM_DURATION_TICKS = 5;
    private static final int SITDOWN_DURATION_TICKS = 40;
    private static final int STANDUP_DURATION_TICKS = 52;
    private static final int IDLE_MINIMAL_DURATION_TICKS = 80;
    private static final float SITTING_HEIGHT_DIFFERENCE = 1.43f;
    private static final long DEFAULT_LAST_POSE_CHANGE_TICK = 0L;
    public static final DataWatcherObject<Boolean> DASH = DataWatcher.defineId(Camel.class, DataWatcherRegistry.BOOLEAN);
    public static final DataWatcherObject<Long> LAST_POSE_CHANGE_TICK = DataWatcher.defineId(Camel.class, DataWatcherRegistry.LONG);
    public final AnimationState sitAnimationState = new AnimationState();
    public final AnimationState sitPoseAnimationState = new AnimationState();
    public final AnimationState sitUpAnimationState = new AnimationState();
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState dashAnimationState = new AnimationState();
    private static final EntitySize SITTING_DIMENSIONS = EntitySize.scalable(EntityTypes.CAMEL.getWidth(), EntityTypes.CAMEL.getHeight() - 1.43f).withEyeHeight(0.845f);
    private int dashCooldown = 0;
    private int idleAnimationTimeout = 0;

    public Camel(EntityTypes<? extends Camel> var0, World var1) {
        super((EntityTypes<? extends EntityHorseAbstract>)var0, var1);
        this.moveControl = new c();
        this.lookControl = new b();
        Navigation var2 = (Navigation)this.getNavigation();
        var2.setCanFloat(true);
        var2.setCanWalkOverFences(true);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        var0.putLong("LastPoseTick", this.entityData.get(LAST_POSE_CHANGE_TICK));
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        long var1 = var0.getLongOr("LastPoseTick", 0L);
        if (var1 < 0L) {
            this.setPose(EntityPose.SITTING);
        }
        this.resetLastPoseChangeTick(var1);
    }

    public static AttributeProvider.Builder createAttributes() {
        return Camel.createBaseHorseAttributes().add(GenericAttributes.MAX_HEALTH, 32.0).add(GenericAttributes.MOVEMENT_SPEED, 0.09f).add(GenericAttributes.JUMP_STRENGTH, 0.42f).add(GenericAttributes.STEP_HEIGHT, 1.5);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DASH, false);
        var0.define(LAST_POSE_CHANGE_TICK, 0L);
    }

    @Override
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        CamelAi.initMemories(this, var0.getRandom());
        this.resetLastPoseChangeTickToFullStand(var0.getLevel().getGameTime());
        return super.finalizeSpawn(var0, var1, var2, var3);
    }

    public static boolean checkCamelSpawnRules(EntityTypes<Camel> var0, GeneratorAccess var1, EntitySpawnReason var2, BlockPosition var3, RandomSource var4) {
        return var1.getBlockState(var3.below()).is(TagsBlock.CAMELS_SPAWNABLE_ON) && Camel.isBrightEnoughToSpawn(var1, var3);
    }

    protected BehaviorController.b<Camel> brainProvider() {
        return CamelAi.brainProvider();
    }

    @Override
    protected void registerGoals() {
    }

    @Override
    protected BehaviorController<?> makeBrain(Dynamic<?> var0) {
        return CamelAi.makeBrain(this.brainProvider().makeBrain(var0));
    }

    @Override
    public EntitySize getDefaultDimensions(EntityPose var0) {
        return var0 == EntityPose.SITTING ? SITTING_DIMENSIONS.scale(this.getAgeScale()) : super.getDefaultDimensions(var0);
    }

    @Override
    protected void customServerAiStep(WorldServer var0) {
        GameProfilerFiller var1 = Profiler.get();
        var1.push("camelBrain");
        BehaviorController<?> var2 = this.getBrain();
        var2.tick(var0, this);
        var1.pop();
        var1.push("camelActivityUpdate");
        CamelAi.updateActivity(this);
        var1.pop();
        super.customServerAiStep(var0);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isDashing() && this.dashCooldown < 50 && (this.onGround() || this.isInLiquid() || this.isPassenger())) {
            this.setDashing(false);
        }
        if (this.dashCooldown > 0) {
            --this.dashCooldown;
            if (this.dashCooldown == 0) {
                this.level().playSound(null, this.blockPosition(), SoundEffects.CAMEL_DASH_READY, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }
        }
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
        if (this.refuseToMove()) {
            this.clampHeadRotationToBody();
        }
        if (this.isCamelSitting() && this.isInWater()) {
            this.standUpInstantly();
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.random.nextInt(40) + 80;
            this.idleAnimationState.start(this.tickCount);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.isCamelVisuallySitting()) {
            this.sitUpAnimationState.stop();
            this.dashAnimationState.stop();
            if (this.isVisuallySittingDown()) {
                this.sitAnimationState.startIfStopped(this.tickCount);
                this.sitPoseAnimationState.stop();
            } else {
                this.sitAnimationState.stop();
                this.sitPoseAnimationState.startIfStopped(this.tickCount);
            }
        } else {
            this.sitAnimationState.stop();
            this.sitPoseAnimationState.stop();
            this.dashAnimationState.animateWhen(this.isDashing(), this.tickCount);
            this.sitUpAnimationState.animateWhen(this.isInPoseTransition() && this.getPoseTime() >= 0L, this.tickCount);
        }
    }

    @Override
    protected void updateWalkAnimation(float var0) {
        float var1 = this.getPose() == EntityPose.STANDING && !this.dashAnimationState.isStarted() ? Math.min(var0 * 6.0f, 1.0f) : 0.0f;
        this.walkAnimation.update(var1, 0.2f, this.isBaby() ? 3.0f : 1.0f);
    }

    @Override
    public void travel(Vec3D var0) {
        if (this.refuseToMove() && this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.0, 1.0, 0.0));
            var0 = var0.multiply(0.0, 1.0, 0.0);
        }
        super.travel(var0);
    }

    @Override
    protected void tickRidden(EntityHuman var0, Vec3D var1) {
        super.tickRidden(var0, var1);
        if (var0.zza > 0.0f && this.isCamelSitting() && !this.isInPoseTransition()) {
            this.standUp();
        }
    }

    public boolean refuseToMove() {
        return this.isCamelSitting() || this.isInPoseTransition();
    }

    @Override
    protected float getRiddenSpeed(EntityHuman var0) {
        float var1 = var0.isSprinting() && this.getJumpCooldown() == 0 ? 0.1f : 0.0f;
        return (float)this.getAttributeValue(GenericAttributes.MOVEMENT_SPEED) + var1;
    }

    @Override
    protected Vec2F getRiddenRotation(EntityLiving var0) {
        if (this.refuseToMove()) {
            return new Vec2F(this.getXRot(), this.getYRot());
        }
        return super.getRiddenRotation(var0);
    }

    @Override
    protected Vec3D getRiddenInput(EntityHuman var0, Vec3D var1) {
        if (this.refuseToMove()) {
            return Vec3D.ZERO;
        }
        return super.getRiddenInput(var0, var1);
    }

    @Override
    public boolean canJump() {
        return !this.refuseToMove() && super.canJump();
    }

    @Override
    public void onPlayerJump(int var0) {
        if (!this.isSaddled() || this.dashCooldown > 0 || !this.onGround()) {
            return;
        }
        super.onPlayerJump(var0);
    }

    @Override
    public boolean canSprint() {
        return true;
    }

    @Override
    protected void executeRidersJump(float var0, Vec3D var1) {
        double var2 = this.getJumpPower();
        this.addDeltaMovement(this.getLookAngle().multiply(1.0, 0.0, 1.0).normalize().scale((double)(22.2222f * var0) * this.getAttributeValue(GenericAttributes.MOVEMENT_SPEED) * (double)this.getBlockSpeedFactor()).add(0.0, (double)(1.4285f * var0) * var2, 0.0));
        this.dashCooldown = 55;
        this.setDashing(true);
        this.hasImpulse = true;
    }

    public boolean isDashing() {
        return this.entityData.get(DASH);
    }

    public void setDashing(boolean var0) {
        this.entityData.set(DASH, var0);
    }

    @Override
    public void handleStartJump(int var0) {
        this.makeSound(SoundEffects.CAMEL_DASH);
        this.gameEvent(GameEvent.ENTITY_ACTION);
        this.setDashing(true);
    }

    @Override
    public void handleStopJump() {
    }

    @Override
    public int getJumpCooldown() {
        return this.dashCooldown;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.CAMEL_AMBIENT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.CAMEL_DEATH;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.CAMEL_HURT;
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        if (var1.is(TagsBlock.CAMEL_SAND_STEP_SOUND_BLOCKS)) {
            this.playSound(SoundEffects.CAMEL_STEP_SAND, 1.0f, 1.0f);
        } else {
            this.playSound(SoundEffects.CAMEL_STEP, 1.0f, 1.0f);
        }
    }

    @Override
    public boolean isFood(ItemStack var0) {
        return var0.is(TagsItem.CAMEL_FOOD);
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        ItemStack var2 = var0.getItemInHand(var1);
        if (var0.isSecondaryUseActive() && !this.isBaby()) {
            this.openCustomInventoryScreen(var0);
            return EnumInteractionResult.SUCCESS;
        }
        EnumInteractionResult var3 = var2.interactLivingEntity(var0, this, var1);
        if (var3.consumesAction()) {
            return var3;
        }
        if (this.isFood(var2)) {
            return this.fedFood(var0, var2);
        }
        if (this.getPassengers().size() < 2 && !this.isBaby()) {
            this.doPlayerRide(var0);
        }
        return EnumInteractionResult.SUCCESS;
    }

    @Override
    public void onElasticLeashPull() {
        super.onElasticLeashPull();
        if (this.isCamelSitting() && !this.isInPoseTransition() && this.canCamelChangePose()) {
            this.standUp();
        }
    }

    @Override
    public Vec3D[] getQuadLeashOffsets() {
        return Leashable.createQuadLeashOffsets(this, 0.02, 0.48, 0.25, 0.82);
    }

    public boolean canCamelChangePose() {
        return this.wouldNotSuffocateAtTargetPose(this.isCamelSitting() ? EntityPose.STANDING : EntityPose.SITTING);
    }

    @Override
    protected boolean handleEating(EntityHuman var0, ItemStack var1) {
        boolean var4;
        boolean var3;
        boolean var2;
        if (!this.isFood(var1)) {
            return false;
        }
        boolean bl = var2 = this.getHealth() < this.getMaxHealth();
        if (var2) {
            this.heal(2.0f);
        }
        boolean bl2 = var3 = this.isTamed() && this.getAge() == 0 && this.canFallInLove();
        if (var3) {
            this.setInLove(var0);
        }
        if (var4 = this.isBaby()) {
            this.level().addParticle(Particles.HAPPY_VILLAGER, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), 0.0, 0.0, 0.0);
            if (!this.level().isClientSide()) {
                this.ageUp(10);
            }
        }
        if (var2 || var3 || var4) {
            SoundEffect var5;
            if (!this.isSilent() && (var5 = this.getEatingSound()) != null) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), var5, this.getSoundSource(), 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
            }
            this.gameEvent(GameEvent.EAT);
            return true;
        }
        return false;
    }

    @Override
    protected boolean canPerformRearing() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canMate(EntityAnimal var0) {
        if (var0 == this) return false;
        if (!(var0 instanceof Camel)) return false;
        Camel var1 = (Camel)var0;
        if (!this.canParent()) return false;
        if (!var1.canParent()) return false;
        return true;
    }

    @Override
    @Nullable
    public Camel getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        return EntityTypes.CAMEL.create(var0, EntitySpawnReason.BREEDING);
    }

    @Override
    @Nullable
    protected SoundEffect getEatingSound() {
        return SoundEffects.CAMEL_EAT;
    }

    @Override
    protected void actuallyHurt(WorldServer var0, DamageSource var1, float var2) {
        this.standUpInstantly();
        super.actuallyHurt(var0, var1, var2);
    }

    @Override
    protected Vec3D getPassengerAttachmentPoint(Entity var0, EntitySize var1, float var2) {
        int var3 = Math.max(this.getPassengers().indexOf(var0), 0);
        boolean var4 = var3 == 0;
        float var5 = 0.5f;
        float var6 = (float)(this.isRemoved() ? (double)0.01f : this.getBodyAnchorAnimationYOffset(var4, 0.0f, var1, var2));
        if (this.getPassengers().size() > 1) {
            if (!var4) {
                var5 = -0.7f;
            }
            if (var0 instanceof EntityAnimal) {
                var5 += 0.2f;
            }
        }
        return new Vec3D(0.0, var6, var5 * var2).yRot(-this.getYRot() * ((float)Math.PI / 180));
    }

    @Override
    public float getAgeScale() {
        return this.isBaby() ? 0.45f : 1.0f;
    }

    private double getBodyAnchorAnimationYOffset(boolean var0, float var1, EntitySize var2, float var3) {
        double var4 = var2.height() - 0.375f * var3;
        float var6 = var3 * 1.43f;
        float var7 = var6 - var3 * 0.2f;
        float var8 = var6 - var7;
        boolean var9 = this.isInPoseTransition();
        boolean var10 = this.isCamelSitting();
        if (var9) {
            float var13;
            int var12;
            int var11;
            int n2 = var11 = var10 ? 40 : 52;
            if (var10) {
                var12 = 28;
                var13 = var0 ? 0.5f : 0.1f;
            } else {
                var12 = var0 ? 24 : 32;
                var13 = var0 ? 0.6f : 0.35f;
            }
            float var14 = MathHelper.clamp((float)this.getPoseTime() + var1, 0.0f, (float)var11);
            boolean var15 = var14 < (float)var12;
            float var16 = var15 ? var14 / (float)var12 : (var14 - (float)var12) / (float)(var11 - var12);
            float var17 = var6 - var13 * var7;
            var4 += var10 ? (double)MathHelper.lerp(var16, var15 ? var6 : var17, var15 ? var17 : var8) : (double)MathHelper.lerp(var16, var15 ? var8 - var6 : var8 - var17, var15 ? var8 - var17 : 0.0f);
        }
        if (var10 && !var9) {
            var4 += (double)var8;
        }
        return var4;
    }

    @Override
    public Vec3D getLeashOffset(float var0) {
        EntitySize var1 = this.getDimensions(this.getPose());
        float var2 = this.getAgeScale();
        return new Vec3D(0.0, this.getBodyAnchorAnimationYOffset(true, var0, var1, var2) - (double)(0.2f * var2), var1.width() * 0.56f);
    }

    @Override
    public int getMaxHeadYRot() {
        return 30;
    }

    @Override
    protected boolean canAddPassenger(Entity var0) {
        return this.getPassengers().size() <= 2;
    }

    public boolean isCamelSitting() {
        return this.entityData.get(LAST_POSE_CHANGE_TICK) < 0L;
    }

    public boolean isCamelVisuallySitting() {
        return this.getPoseTime() < 0L != this.isCamelSitting();
    }

    public boolean isInPoseTransition() {
        long var0 = this.getPoseTime();
        return var0 < (long)(this.isCamelSitting() ? 40 : 52);
    }

    private boolean isVisuallySittingDown() {
        return this.isCamelSitting() && this.getPoseTime() < 40L && this.getPoseTime() >= 0L;
    }

    public void sitDown() {
        if (this.isCamelSitting()) {
            return;
        }
        this.makeSound(SoundEffects.CAMEL_SIT);
        this.setPose(EntityPose.SITTING);
        this.gameEvent(GameEvent.ENTITY_ACTION);
        this.resetLastPoseChangeTick(-this.level().getGameTime());
    }

    public void standUp() {
        if (!this.isCamelSitting()) {
            return;
        }
        this.makeSound(SoundEffects.CAMEL_STAND);
        this.setPose(EntityPose.STANDING);
        this.gameEvent(GameEvent.ENTITY_ACTION);
        this.resetLastPoseChangeTick(this.level().getGameTime());
    }

    public void standUpInstantly() {
        this.setPose(EntityPose.STANDING);
        this.gameEvent(GameEvent.ENTITY_ACTION);
        this.resetLastPoseChangeTickToFullStand(this.level().getGameTime());
    }

    @VisibleForTesting
    public void resetLastPoseChangeTick(long var0) {
        this.entityData.set(LAST_POSE_CHANGE_TICK, var0);
    }

    private void resetLastPoseChangeTickToFullStand(long var0) {
        this.resetLastPoseChangeTick(Math.max(0L, var0 - 52L - 1L));
    }

    public long getPoseTime() {
        return this.level().getGameTime() - Math.abs(this.entityData.get(LAST_POSE_CHANGE_TICK));
    }

    @Override
    protected Holder<SoundEffect> getEquipSound(EnumItemSlot var0, ItemStack var1, Equippable var2) {
        if (var0 == EnumItemSlot.SADDLE) {
            return SoundEffects.CAMEL_SADDLE;
        }
        return super.getEquipSound(var0, var1, var2);
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        if (!this.firstTick && DASH.equals(var0)) {
            this.dashCooldown = this.dashCooldown == 0 ? 55 : this.dashCooldown;
        }
        super.onSyncedDataUpdated(var0);
    }

    @Override
    public boolean isTamed() {
        return true;
    }

    @Override
    public void openCustomInventoryScreen(EntityHuman var0) {
        if (!this.level().isClientSide()) {
            var0.openHorseInventory(this, this.inventory);
        }
    }

    @Override
    protected EntityAIBodyControl createBodyControl() {
        return new a(this);
    }

    @Override
    @Nullable
    public /* synthetic */ EntityAgeable getBreedOffspring(WorldServer worldServer, EntityAgeable entityAgeable) {
        return this.getBreedOffspring(worldServer, entityAgeable);
    }

    class c
    extends ControllerMove {
        public c() {
            super(Camel.this);
        }

        @Override
        public void tick() {
            if (this.operation == ControllerMove.Operation.MOVE_TO && !Camel.this.isLeashed() && Camel.this.isCamelSitting() && !Camel.this.isInPoseTransition() && Camel.this.canCamelChangePose()) {
                Camel.this.standUp();
            }
            super.tick();
        }
    }

    class b
    extends ControllerLook {
        b() {
            super(Camel.this);
        }

        @Override
        public void tick() {
            if (!Camel.this.hasControllingPassenger()) {
                super.tick();
            }
        }
    }

    class a
    extends EntityAIBodyControl {
        public a(Camel var1) {
            super(var1);
        }

        @Override
        public void clientTick() {
            if (!Camel.this.refuseToMove()) {
                super.clientTick();
            }
        }
    }
}

