/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ContainerChest
extends Container {
    private final IInventory container;
    private final int containerRows;

    private ContainerChest(Containers<?> var0, int var1, PlayerInventory var2, int var3) {
        this(var0, var1, var2, new InventorySubcontainer(9 * var3), var3);
    }

    public static ContainerChest oneRow(int var0, PlayerInventory var1) {
        return new ContainerChest(Containers.GENERIC_9x1, var0, var1, 1);
    }

    public static ContainerChest twoRows(int var0, PlayerInventory var1) {
        return new ContainerChest(Containers.GENERIC_9x2, var0, var1, 2);
    }

    public static ContainerChest threeRows(int var0, PlayerInventory var1) {
        return new ContainerChest(Containers.GENERIC_9x3, var0, var1, 3);
    }

    public static ContainerChest fourRows(int var0, PlayerInventory var1) {
        return new ContainerChest(Containers.GENERIC_9x4, var0, var1, 4);
    }

    public static ContainerChest fiveRows(int var0, PlayerInventory var1) {
        return new ContainerChest(Containers.GENERIC_9x5, var0, var1, 5);
    }

    public static ContainerChest sixRows(int var0, PlayerInventory var1) {
        return new ContainerChest(Containers.GENERIC_9x6, var0, var1, 6);
    }

    public static ContainerChest threeRows(int var0, PlayerInventory var1, IInventory var2) {
        return new ContainerChest(Containers.GENERIC_9x3, var0, var1, var2, 3);
    }

    public static ContainerChest sixRows(int var0, PlayerInventory var1, IInventory var2) {
        return new ContainerChest(Containers.GENERIC_9x6, var0, var1, var2, 6);
    }

    public ContainerChest(Containers<?> var0, int var1, PlayerInventory var2, IInventory var3, int var4) {
        super(var0, var1);
        ContainerChest.checkContainerSize(var3, var4 * 9);
        this.container = var3;
        this.containerRows = var4;
        var3.startOpen(var2.player);
        int var5 = 18;
        this.addChestGrid(var3, 8, 18);
        int var6 = 18 + this.containerRows * 18 + 13;
        this.addStandardInventorySlots(var2, 8, var6);
    }

    private void addChestGrid(IInventory var0, int var1, int var2) {
        for (int var3 = 0; var3 < this.containerRows; ++var3) {
            for (int var4 = 0; var4 < 9; ++var4) {
                this.addSlot(new Slot(var0, var4 + var3 * 9, var1 + var4 * 18, var2 + var3 * 18));
            }
        }
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return this.container.stillValid(var0);
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman var0, int var1) {
        ItemStack var2 = ItemStack.EMPTY;
        Slot var3 = (Slot)this.slots.get(var1);
        if (var3 != null && var3.hasItem()) {
            ItemStack var4 = var3.getItem();
            var2 = var4.copy();
            if (var1 < this.containerRows * 9 ? !this.moveItemStackTo(var4, this.containerRows * 9, this.slots.size(), true) : !this.moveItemStackTo(var4, 0, this.containerRows * 9, false)) {
                return ItemStack.EMPTY;
            }
            if (var4.isEmpty()) {
                var3.setByPlayer(ItemStack.EMPTY);
            } else {
                var3.setChanged();
            }
        }
        return var2;
    }

    @Override
    public void removed(EntityHuman var0) {
        super.removed(var0);
        this.container.stopOpen(var0);
    }

    public IInventory getContainer() {
        return this.container;
    }

    public int getRowCount() {
        return this.containerRows;
    }
}

